

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> voto di utilit\u00e0</div>", 
      "<div {countattr}>{n}</div><div {textattr}> voti di utilit\u00e0</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> problema risolto</div>", 
      "<div {countattr}>{n}</div><div {textattr}> problemi risolti</div>"
    ], 
    "A user with that email address already exists.": "Esiste gi\u00e0 un utente con questo indirizzo email.", 
    "A user with that username exists": "Esiste gi\u00e0 un utente con questo nome.", 
    "All My Questions": "Tutte le mie domande", 
    "Already registered? Sign in": "Hai gi\u00e0 un account? Accedi", 
    "An account lets you answer questions, track contributions and receive alerts.": "Con un account \u00e8 possibile rispondere alle domande, tenere traccia della collaborazione e ricevere le notifiche.", 
    "Another helper has answered this question, please choose another.": "Un altro utente ha gi\u00e0 risposto a questa domanda, scegline un'altra.", 
    "Answer Questions": "Rispondi alle domande", 
    "Answer a Question": "Rispondi a una domanda", 
    "Answer questions": "Rispondi alle richieste", 
    "Answered Questions": "Domande con risposta", 
    "Ask a Question": "Richiedi supporto", 
    "Audio/Music/FMRadio": "Audio/Musica/Radio MF", 
    "Be aware that you will lose your history when you sign in to your account.": "Attenzione: accedendo all'account verr\u00e0 persa tutta la cronologia.", 
    "Browser/Download": "Browser/Download", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp non supporta attualmente la lingua  \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Foto/Galleria/Video", 
    "Can't change this field.": "Impossibile modificare questo campo.", 
    "Cancel": "Annulla", 
    "Cancel Sign Up": "Annulla creazione account", 
    "Cellular Data/WiFi/Bluetooth": "Connessione dati cellulare/WiFi/Bluetooth", 
    "Choose a category": "Scegli categoria", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Fai clic sul link nel messaggio per confermare di essere arrivato a destinazione. Poi ritorna a BuddyUp per aiutare gli altri utenti.", 
    "Clock/Alarm": "Orologio/Sveglia", 
    "Close": "Chiudi", 
    "Confirm Account": "Conferma account", 
    "Continue": "Continua", 
    "Create Account": "Crea account", 
    "Create account or sign in": "Crea account o accedi", 
    "Device": "Dispositivo", 
    "Dialer/Contacts": "Chiamata/Contatti", 
    "Don't have an account? Register": "Non hai un account? Registrati", 
    "Done": "Fatto", 
    "Email Address": "Indirizzo email", 
    "Email/Calendar": "Email/Agenda", 
    "Failed": "Invio non riuscito", 
    "Forgot your password?": "Hai dimenticato la password?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Hai dimenticato la password? Niente paura: inserisci il nome utente e ti invieremo le istruzioni per ripristinarla.", 
    "Get a Buddy to help you with your device": "Fatti aiutare da un Buddy per il tuo dispositivo", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Apri una nuova scheda per rispondere ad alcune domande. Qui verr\u00e0 tenuta traccia.", 
    "Has your question been solved?": "Il tuo problema \u00e8 stato risolto?", 
    "Have Answers?": "Hai risposte?", 
    "Have Questions?": "Hai domande?", 
    "Help Article": "Articolo di supporto", 
    "Help other users around the world": "Aiuta gli altri utenti in tutto il mondo", 
    "Incompatible version": "Versione non compatibile", 
    "Keyboard": "Tastiera", 
    "Language": "Lingua", 
    "Last sync:": "Ultima sincronizzazione", 
    "Load more": "Mostra di pi\u00f9", 
    "Maps/GPS": "Mappe/GPS", 
    "Marketplace/Apps Install": "Marketplace/Installazione App", 
    "My Profile": "Il mio profilo", 
    "My Question": "La mia domanda", 
    "My Questions": "Le mie domande", 
    "My list": "Il mio elenco", 
    "My preferences": "Preferenze", 
    "New": "Nuovo", 
    "No active questions": "Nessuna richiesta attiva", 
    "No matching user setting found.": "Impossibile trovare impostazioni utente corrispondenti.", 
    "No questions": "Nessuna richiesta", 
    "OK": "OK", 
    "Ok": "OK", 
    "Operator": "Operatore", 
    "Other": "Altro", 
    "Password": "Password", 
    "Performance": "Performance", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Rispondi alle domande in inglese oppure vai su <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> per ulteriore supporto.", 
    "Previously Answered": "Con risposta", 
    "Quit": "Esci", 
    "Reset Password": "Ripristina password", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Invio in corso", 
    "Settings": "Impostazioni", 
    "Sign In": "Accedi", 
    "Sign in to answer questions from Firefox OS users.": "Accedi per rispondere alle domande degli utenti Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Accedi per rispondere alle domande della comunit\u00e0 Mozilla.", 
    "Sign in to reply": "Scrivi il tuo messaggio\u2026", 
    "Solution \u2713": "Soluzione \u2713", 
    "Storage/SD card": "Archiviazione/Scheda SD", 
    "Support": "Supporto", 
    "System Updates": "Aggiornamenti di sistema", 
    "Thank you for your question!": "Grazie per la domanda", 
    "There was a problem with Buddy Up, please try again.": "Si \u00e8 verificato un errore con Buddy Up: riprovare.", 
    "This field is required.": "Questo campo non pu\u00f2 essere lasciato vuoto.", 
    "This solved my question": "Questa risposta ha risolto il problema", 
    "This will close the question and let your buddy know you no longer need help.": "In questo modo la richiesta verr\u00e0 chiusa e il tuo Buddy sapr\u00e0 che non hai pi\u00f9 bisogno di aiuto.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Troppe richieste? Restringi i risultati in elenco utilizzando le impostazioni seguenti.", 
    "Top Helpers this Week": "Migliori utenti sul supporto questa settimana", 
    "Unable to generate username.": "Impossibile generare il nome utente.", 
    "Unknown error: \"{error}\"": "Si \u00e8 verificato un errore sconosciuto: \"{error}\"", 
    "Unsupported Language": "Lingua non supportata", 
    "User not found.": "Utente non trovato", 
    "Username": "Nome utente", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "I nomi utente possono contenere solo lettere, numeri, \".\" e \"-\".", 
    "We can help<br>Ask us anything!": "Siamo qui per aiutare<br>Chiedi per avere una risposta", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Siamo spiacenti, ma BuddyUp non pu\u00f2 essere installata su questa versione di Firefox OS. Chiudere la finestra per ritornare alla schermata iniziale.", 
    "We've sent a welcome email to:": "Un'email di benvenuto \u00e8 stata inviata a:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Ti abbiamo inviato un'email: segui il link contenuto nel messaggio per reimpostare la password.", 
    "Whoops!": "Errore", 
    "Write your message\u2026": "Scrivi il tuo messaggio&hellip;", 
    "Yay, you're almost done!": "Manca poco al completamento dell'operazione...", 
    "You are not online, please check your connection.": "Non sei online: controlla la tua connessione", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Riceverai una notifica appena un Buddy si far\u00e0 vivo con la risposta", 
    "just now": "Proprio adesso", 
    "x hours ago": "x ore fa", 
    "{n} day ago": [
      "{n} giorno fa", 
      "{n} giorni fa"
    ], 
    "{n} helpful vote": [
      "{n} voto di utilit\u00e0", 
      "{n} voti di utilit\u00e0"
    ], 
    "{n} hour ago": [
      "{n} ora fa", 
      "{n} ore fa"
    ], 
    "{n} minute ago": [
      "{n} minuto fa", 
      "{n} minuti fa"
    ], 
    "{n} question solved": [
      "{n} problema risolto", 
      "{n} problemi risolti"
    ], 
    "{user} chose your answer as a solution": "{user} ha scelto la tua risposta come soluzione", 
    "{user} left a comment on your question": "{user} ha lasciato un commento alla tua domanda"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "l d F Y H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S", 
      "%d/%m/%Y %H:%M:%S.%f", 
      "%d/%m/%Y %H:%M", 
      "%d/%m/%Y", 
      "%d/%m/%y %H:%M:%S", 
      "%d/%m/%y %H:%M:%S.%f", 
      "%d/%m/%y %H:%M", 
      "%d/%m/%y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%d-%m-%Y %H:%M:%S", 
      "%d-%m-%Y %H:%M:%S.%f", 
      "%d-%m-%Y %H:%M", 
      "%d-%m-%Y", 
      "%d-%m-%y %H:%M:%S", 
      "%d-%m-%y %H:%M:%S.%f", 
      "%d-%m-%y %H:%M", 
      "%d-%m-%y"
    ], 
    "DATE_FORMAT": "d F Y", 
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y", 
      "%Y/%m/%d", 
      "%d-%m-%Y", 
      "%Y-%m-%d", 
      "%d-%m-%y", 
      "%d/%m/%y"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j/F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i:s", 
    "SHORT_DATE_FORMAT": "d/m/Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

