

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> hasznos szavazat</div>", 
      "<div {countattr}>{n}</div><div {textattr}> hasznos szavazat</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> k\u00e9rd\u00e9s megoldva</div>", 
      "<div {countattr}>{n}</div><div {textattr}> k\u00e9rd\u00e9s megoldva</div>"
    ], 
    "A user with that email address already exists.": "M\u00e1r l\u00e9tezik felhaszn\u00e1l\u00f3 ezzel az e-mail c\u00edmmel.", 
    "A user with that username exists": "M\u00e1r l\u00e9tezik felhaszn\u00e1l\u00f3 ezzel a felhaszn\u00e1l\u00f3n\u00e9vvel.", 
    "All My Questions": "\u00d6sszes k\u00e9rd\u00e9sem", 
    "Already registered? Sign in": "Bel\u00e9p\u00e9s regisztr\u00e1lt felhaszn\u00e1l\u00f3k\u00e9nt", 
    "An account lets you answer questions, track contributions and receive alerts.": "Felhaszn\u00e1l\u00f3i fi\u00f3kkal v\u00e1laszolni tud k\u00e9rd\u00e9sekre, k\u00f6vetni tudja a hozz\u00e1sz\u00f3l\u00e1sokat, \u00e9s \u00e9rtes\u00edt\u00e9seket k\u00e9rhet.", 
    "Another helper has answered this question, please choose another.": "Valaki m\u00e1r megv\u00e1laszolta ezt a k\u00e9rd\u00e9st, v\u00e1lasszon m\u00e1sikat.", 
    "Answer Questions": "V\u00e1laszoljon k\u00e9rd\u00e9sekre", 
    "Answer a Question": "K\u00e9rd\u00e9s megv\u00e1laszol\u00e1sa", 
    "Answer questions": "K\u00e9rd\u00e9sek megv\u00e1laszol\u00e1sa", 
    "Answered Questions": "Megv\u00e1laszolt k\u00e9rd\u00e9sek", 
    "Ask a Question": "K\u00e9rdezzen", 
    "Audio/Music/FMRadio": "Hang/Zene/FM r\u00e1di\u00f3", 
    "Be aware that you will lose your history when you sign in to your account.": "Ne feledje, hogy el\u0151zm\u00e9nyei elvesznek, amikor bejelentkezik fi\u00f3kj\u00e1ba.", 
    "Browser/Download": "B\u00f6ng\u00e9sz\u0151/Let\u00f6lt\u00e9s", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "A BuddyUp jelenleg nem t\u00e1mogatja ezt: \u201e<span id=\"language\"></span>\u201d.", 
    "Camera/Gallery/Video": "Kamera/Gal\u00e9ria/Vide\u00f3", 
    "Can't change this field.": "Ez a mez\u0151 nem m\u00f3dos\u00edthat\u00f3.", 
    "Cancel": "M\u00e9gse", 
    "Cancel Sign Up": "Feliratkoz\u00e1s megszak\u00edt\u00e1sa", 
    "Cellular Data/WiFi/Bluetooth": "Mobil adat/Wi-Fi/Bluetooth", 
    "Choose a category": "V\u00e1lasszon egy kateg\u00f3ri\u00e1t", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Kattintson az e-mailben l\u00e9v\u0151 hivatkoz\u00e1sra a c\u00edmz\u00e9s meger\u0151s\u00edt\u00e9s\u00e9hez. Majd t\u00e9rjen vissza a BuddyUp-hoz, \u00e9s m\u00e1r seg\u00edtheti is a t\u00f6bbi felhaszn\u00e1l\u00f3t!", 
    "Clock/Alarm": "\u00d3ra/riaszt\u00e1s", 
    "Close": "Bez\u00e1r\u00e1s", 
    "Confirm Account": "Fi\u00f3k meger\u0151s\u00edt\u00e9se", 
    "Continue": "Folytat\u00e1s", 
    "Create Account": "Fi\u00f3k l\u00e9trehoz\u00e1sa", 
    "Create account or sign in": "Regisztr\u00e1ci\u00f3 vagy bejelentkez\u00e9s", 
    "Device": "Eszk\u00f6z", 
    "Dialer/Contacts": "T\u00e1rcs\u00e1z\u00f3/N\u00e9vjegyek", 
    "Don't have an account? Register": "Nincs felhaszn\u00e1l\u00f3i fi\u00f3kja? Hozzon l\u00e9tre egyet", 
    "Done": "K\u00e9sz", 
    "Email Address": "E-mail c\u00edm", 
    "Email/Calendar": "E-mail/napt\u00e1r", 
    "Failed": "Sikertelen", 
    "Forgot your password?": "Elfelejtette a jelszav\u00e1t?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Elfelejtette jelszav\u00e1t? Semmi gond, adja meg felhaszn\u00e1l\u00f3nev\u00e9t, \u00e9s e-mailben le\u00edrjuk, mit kell tennie egy \u00faj be\u00e1ll\u00edt\u00e1s\u00e1hoz.", 
    "Get a Buddy to help you with your device": "Valaki seg\u00edteni tud az eszk\u00f6zzel kapcsolatos probl\u00e9m\u00e1k megold\u00e1s\u00e1ban", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "L\u00e9pjen az \u00daj lapra n\u00e9h\u00e1ny k\u00e9rd\u00e9s megv\u00e1laszol\u00e1s\u00e1hoz. Ezeket itt tartjuk nyilv\u00e1n.", 
    "Has your question been solved?": "Megold\u00f3dott a probl\u00e9ma?", 
    "Have Answers?": "Tud v\u00e1laszolni?", 
    "Have Questions?": "K\u00e9rd\u00e9sei vannak?", 
    "Help Article": "Seg\u00edt\u0151 le\u00edr\u00e1s", 
    "Help other users around the world": "Seg\u00edtsen m\u00e1s felhaszn\u00e1l\u00f3knak", 
    "Incompatible version": "Nem kompatibilis verzi\u00f3", 
    "Keyboard": "Billenty\u0171zet", 
    "Language": "Nyelv", 
    "Last sync:": "Utols\u00f3 szinkroniz\u00e1l\u00e1s:", 
    "Load more": "Tov\u00e1bbiak", 
    "Maps/GPS": "T\u00e9rk\u00e9pek/GPS", 
    "Marketplace/Apps Install": "Marketplace/App telep\u00edt\u00e9s", 
    "My Profile": "Profilom", 
    "My Question": "K\u00e9rd\u00e9sem", 
    "My Questions": "K\u00e9rd\u00e9seim", 
    "My list": "List\u00e1m", 
    "My preferences": "Saj\u00e1t be\u00e1ll\u00edt\u00e1saim", 
    "New": "\u00daj", 
    "No active questions": "Nincsenek akt\u00edv k\u00e9rd\u00e9sek", 
    "No matching user setting found.": "Nem tal\u00e1lhat\u00f3 megfelel\u0151 felhaszn\u00e1l\u00f3i be\u00e1ll\u00edt\u00e1s.", 
    "No questions": "Nincsenek k\u00e9rd\u00e9sek", 
    "OK": "OK", 
    "Ok": "Rendben", 
    "Operator": "Szolg\u00e1ltat\u00f3", 
    "Other": "Egy\u00e9b", 
    "Password": "Jelsz\u00f3", 
    "Performance": "Teljes\u00edtm\u00e9ny", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "K\u00e9rd\u00e9s\u00e9t angolul tegye fel, vagy tov\u00e1bbi seg\u00edts\u00e9g\u00e9rt keresse fel a <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> oldalt.", 
    "Previously Answered": "Kor\u00e1bban megv\u00e1laszolva", 
    "Quit": "Kil\u00e9p\u00e9s", 
    "Reset Password": "Jelsz\u00f3 vissza\u00e1ll\u00edt\u00e1sa", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "K\u00fcld\u00e9s\u2026", 
    "Settings": "Be\u00e1ll\u00edt\u00e1sok", 
    "Sign In": "Bel\u00e9p\u00e9s", 
    "Sign in to answer questions from Firefox OS users.": "Jelentkezzen be a Firefox OS felhaszn\u00e1l\u00f3kt\u00f3l \u00e9rkez\u0151 k\u00e9rd\u00e9sek megv\u00e1laszol\u00e1s\u00e1hoz.", 
    "Sign in to answer questions from the Mozilla community.": "Jelentkezzen be a Mozilla k\u00f6z\u00f6ss\u00e9gt\u0151l \u00e9rkez\u0151 k\u00e9rd\u00e9sek megv\u00e1laszol\u00e1s\u00e1hoz.", 
    "Sign in to reply": "A v\u00e1laszhoz jelentkezzen be", 
    "Solution \u2713": "Megold\u00e1s \u2713", 
    "Storage/SD card": "T\u00e1rol\u00f3/SD-k\u00e1rtya", 
    "Support": "T\u00e1mogat\u00e1s", 
    "System Updates": "Rendszerfriss\u00edt\u00e9sek", 
    "Thank you for your question!": "K\u00f6sz\u00f6nj\u00fck k\u00e9rd\u00e9s\u00e9t.", 
    "There was a problem with Buddy Up, please try again.": "Hiba t\u00f6rt\u00e9nt a Buddy Uppal, pr\u00f3b\u00e1lja \u00fajra.", 
    "This field is required.": "Ez a mez\u0151 k\u00f6telez\u0151.", 
    "This solved my question": "Ez megoldotta a probl\u00e9m\u00e1m", 
    "This will close the question and let your buddy know you no longer need help.": "Ez lez\u00e1rja ezt a t\u00e9m\u00e1t, \u00e9s m\u00e1sok tudni fogj\u00e1k, hogy ebben m\u00e1r nem ig\u00e9nyel seg\u00edts\u00e9get.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "T\u00fal sok a k\u00e9rd\u00e9s? Haszn\u00e1lja a lenti list\u00e1t a \u201eV\u00e1laszoljon egy k\u00e9rd\u00e9sre\u201d lista sz\u0171k\u00edt\u00e9s\u00e9re.", 
    "Top Helpers this Week": "A legt\u00f6bbet seg\u00edt\u0151k ezen a h\u00e9ten", 
    "Unable to generate username.": "Nem \u00e1ll\u00edthat\u00f3 el\u0151 felhaszn\u00e1l\u00f3n\u00e9v.", 
    "Unknown error: \"{error}\"": "Ismeretlen hiba: \u201e{error}\u201d", 
    "Unsupported Language": "Nem t\u00e1mogatott nyelv", 
    "User not found.": "A felhaszn\u00e1l\u00f3 nem tal\u00e1lhat\u00f3.", 
    "Username": "Felhaszn\u00e1l\u00f3n\u00e9v", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "A felhaszn\u00e1l\u00f3n\u00e9vben csak bet\u0171k, sz\u00e1mok, \u201e.\u201d \u00e9s \u201e-\u201d lehet.", 
    "We can help<br>Ask us anything!": "Tudunk seg\u00edteni.<br>K\u00e9rdezzen b\u00e1rmit!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Eln\u00e9z\u00e9st, a BuddyUp nem telep\u00edthet\u0151 erre a Firefox OS verzi\u00f3ra. Z\u00e1rja be ezt az ablakot a kezd\u0151k\u00e9perny\u0151h\u00f6z val\u00f3 visszat\u00e9r\u00e9shez.", 
    "We've sent a welcome email to:": "K\u00fcldt\u00fcnk egy \u00fcdv\u00f6zl\u0151 e-mailt erre a c\u00edmre:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "K\u00fcldt\u00fcnk \u00d6nnek egy e-mailt. Kattintson az e-mailben l\u00e9v\u0151 hivatkoz\u00e1sra a jelsz\u00f3 vissza\u00e1ll\u00edt\u00e1s\u00e1hoz.", 
    "Whoops!": "Hopp\u00e1!", 
    "Write your message\u2026": "\u00cdrja be az \u00fczenetet\u2026", 
    "Yay, you're almost done!": "Majdnem k\u00e9sz.", 
    "You are not online, please check your connection.": "Ellen\u0151rizze az internetkapcsolatot.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "\u00c9rtes\u00edt\u00e9st k\u00fcld\u00fcnk, ha valaki tud seg\u00edteni.", 
    "just now": "\u00e9pp most", 
    "x hours ago": "x \u00f3r\u00e1ja", 
    "{n} day ago": [
      "{n} napja", 
      "{n} napja"
    ], 
    "{n} helpful vote": [
      "{n} hasznos szavazat", 
      "{n} hasznos szavazat"
    ], 
    "{n} hour ago": [
      "{n} \u00f3r\u00e1ja", 
      "{n} \u00f3r\u00e1ja"
    ], 
    "{n} minute ago": [
      "{n} perce", 
      "{n} perce"
    ], 
    "{n} question solved": [
      "{n} k\u00e9rd\u00e9s megoldva", 
      "{n} k\u00e9rd\u00e9s megoldva"
    ], 
    "{user} chose your answer as a solution": "{user} megold\u00e1sk\u00e9nt v\u00e1lasztotta ki a v\u00e1lasz\u00e1t", 
    "{user} left a comment on your question": "{user} hozz\u00e1sz\u00f3lt a k\u00e9rd\u00e9s\u00e9hez"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "Y. F j. G.i.s", 
    "DATETIME_INPUT_FORMATS": [
      "%Y.%m.%d. %H.%M.%S", 
      "%Y.%m.%d. %H.%M.%S.%f", 
      "%Y.%m.%d. %H.%M", 
      "%Y.%m.%d.", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "Y. F j.", 
    "DATE_INPUT_FORMATS": [
      "%Y.%m.%d.", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "F j.", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "Y.m.d. G.i.s", 
    "SHORT_DATE_FORMAT": "Y.m.d.", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "G.i.s", 
    "TIME_INPUT_FORMATS": [
      "%H.%M.%S", 
      "%H.%M", 
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "Y. F"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

