

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=0;
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \ub3c4\uc6c0\uc774 \ub418\ub294 \ud22c\ud45c</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \ud574\uacb0 \uc644\ub8cc</div>"
    ], 
    "Answer questions": "\ub2f5\ubcc0\ud558\uae30", 
    "Ask a Question": "\uc9c8\ubb38\ud558\uae30", 
    "Audio/Music/FMRadio": "\uc624\ub514\uc624/\uc74c\uc545/FM\ub77c\ub514\uc624", 
    "Browser/Download": "\uc778\ud130\ub137/\ub2e4\uc6b4\ub85c\ub4dc", 
    "Camera/Gallery/Video": "\uce74\uba54\ub77c/\uac24\ub7ec\ub9ac/\ube44\ub514\uc624", 
    "Cellular Data/WiFi/Bluetooth": "\uc140\ub8f0\ub7ec \ub370\uc774\ud130/\uc640\uc774\ud30c\uc774/\ube14\ub8e8\ud22c\uc2a4", 
    "Choose a category": "\ubd84\ub958 \uc120\ud0dd", 
    "Clock/Alarm": "\uc2dc\uacc4/\uc54c\ub78c", 
    "Close": "\ub2eb\uae30", 
    "Create Account": "\uacc4\uc815 \uc0dd\uc131", 
    "Create account or sign in": "\uac00\uc785 \ud639\uc740 \ub85c\uadf8\uc778", 
    "Dialer/Contacts": "\uc804\ud654/\uc5f0\ub77d\ucc98", 
    "Email/Calendar": "\uc774\uba54\uc77c/\uce98\ub9b0\ub354", 
    "Failed": "\uc2e4\ud328", 
    "Forgot your password?": "\ube44\ubc00\ubc88\ud638\ub97c \uc78a\uc73c\uc168\ub098\uc694?", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\uc9c8\ubb38\ub4e4\uc744 \uc0c8\ub85c \ud0ed\ud558\uc138\uc694. \uc800\ud76c\ub294 \uacc4\uc18d \ud655\uc778\ud558\uace0 \uc788\uaca0\uc2b5\ub2c8\ub2e4.", 
    "Has your question been solved?": "\uc9c8\ubb38\uc774 \ud574\uacb0 \ub410\ub098\uc694?", 
    "Have Questions?": "\uc9c8\ubb38\uc774 \uc788\uc73c\uc2e0\uac00\uc694?", 
    "Keyboard": "\ud0a4\ubcf4\ub4dc", 
    "Language": "\uc5b8\uc5b4", 
    "Maps/GPS": "\uc9c0\ub3c4/GPS", 
    "Marketplace/Apps Install": "\ub9c8\ucf13/\uc571 \uc124\uce58", 
    "My preferences": "\ud658\uacbd \uc124\uc815", 
    "No active questions": "\uc0c8 \uc9c8\ubb38 \uc5c6\uc74c", 
    "No questions": "\uc0c8 \uc9c8\ubb38 \uc5c6\uc74c", 
    "OK": "\uc644\ub8cc", 
    "Other": "\uc774\uc678\uc758 \uac83", 
    "Password": "\ube44\ubc00\ubc88\ud638", 
    "Performance": "\uc131\ub2a5", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "\ubcf4\ub0b4\ub294 \uc911\uc785\ub2c8\ub2e4...", 
    "Sign In": "\ub85c\uadf8\uc778", 
    "Sign in to answer questions from Firefox OS users.": "Firefox OS \uc0ac\uc6a9\uc790 \uc9c8\ubb38\uc5d0 \ub2f5\ubcc0\ud558\ub824\uba74 \ub85c\uadf8\uc778 \ud574 \uc8fc\uc138\uc694.", 
    "Sign in to answer questions from the Mozilla community.": "\ub2f5\ubcc0\ud558\uae30", 
    "Solution \u2713": "\ud574\uacb0\ubc29\ubc95", 
    "Storage/SD card": "\uc800\uc7a5\uacf5\uac04/SD \uce74\ub4dc", 
    "System Updates": "\uc2dc\uc2a4\ud15c \uc5c5\ub370\uc774\ud2b8", 
    "There was a problem with Buddy Up, please try again.": "\ubb38\uc81c\uac00 \uc0dd\uacbc\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc2e4\ud589\ud574\uc8fc\uc138\uc694", 
    "This solved my question": "\uc81c \ubb38\uc81c\uac00 \ud574\uacb0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\ub108\ubb34 \ub9ce\uc740 \uc9c8\ubb38\ub4e4\uc774 \uc788\ub098\uc694? \"FAQ\ub97c \uc774\uc6a9\ud574\ubcf4\uc138\uc694.", 
    "User not found.": "\uc0ac\uc6a9\uc790\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", 
    "Username": "\uc0ac\uc6a9\uc790\uba85", 
    "Whoops!": "\uc774\ub7f0!", 
    "You are not online, please check your connection.": "\uc628\ub77c\uc778 \uc0c1\ud0dc\uac00 \uc544\ub2cc \uac83 \uac19\uc2b5\ub2c8\ub2e4. \uc778\ud130\ub137 \uc5f0\uacb0\uc744 \ud655\uc778\ud558\uc138\uc694.", 
    "{n} helpful vote": [
      "\ud22c\ud45c: {n}\uac1c"
    ], 
    "{n} question solved": [
      "{n} \uc9c8\ubb38 \ud574\uacb0"
    ], 
    "{user} chose your answer as a solution": "{user}\uac00 \ud574\uacb0\ubc29\ubc95\uc73c\ub85c \uc120\ud0dd", 
    "{user} left a comment on your question": "\uc9c8\ubb38\uc5d0 \ub2f5\ubcc0 \ub0a8\uae34 \uc0ac\uc6a9\uc790: {user}"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "Y\ub144 n\uc6d4 j\uc77c g:i:s A", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y", 
      "%Y\ub144 %m\uc6d4 %d\uc77c %H\uc2dc %M\ubd84 %S\ucd08", 
      "%Y\ub144 %m\uc6d4 %d\uc77c %H\uc2dc %M\ubd84"
    ], 
    "DATE_FORMAT": "Y\ub144 n\uc6d4 j\uc77c", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y", 
      "%Y\ub144 %m\uc6d4 %d\uc77c"
    ], 
    "DECIMAL_SEPARATOR": ".", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "F\uc6d4 j\uc77c", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "Y-n-j H:i", 
    "SHORT_DATE_FORMAT": "Y-n-j.", 
    "THOUSAND_SEPARATOR": ",", 
    "TIME_FORMAT": "A g:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M", 
      "%H\uc2dc %M\ubd84 %S\ucd08", 
      "%H\uc2dc %M\ubd84"
    ], 
    "YEAR_MONTH_FORMAT": "Y\ub144 F\uc6d4"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

