

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && (n%100<10 || n%100>=20) ? 1 : 2);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "Choose a category": "Pasirinkite kategorij\u0105", 
    "Create account or sign in": "Susikurkite paskyr\u0105 arba prisijunkite", 
    "Failed": "Nepavyko", 
    "Language": "Kalba", 
    "My preferences": "J\u016bs\u0173 nuostatos", 
    "No active questions": "Aktyvi\u0173 klausim\u0173 n\u0117ra", 
    "Performance": "Na\u0161umas", 
    "Sending\u2026": "Siun\u010diama\u2026", 
    "Sign in to answer questions from the Mozilla community.": "Prisijunkite, jei norite atsakyti \u012f \u201eMozillos\u201c bendruomen\u0117s nari\u0173 klausimus.", 
    "Solution \u2713": "Sprendimas \u2713", 
    "System Updates": "Sistemos naujinimai", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Per daug klausim\u0173? Pakeiskite apa\u010dioje esan\u010dias parinktis ir sutrumpinkite \u0161\u012f s\u0105ra\u0161\u0105.", 
    "User not found.": "Naudotojas nerastas.", 
    "Whoops!": "Oi!", 
    "{user} chose your answer as a solution": "{user} pasirinko j\u016bs\u0173 atsakym\u0105 kaip savo problemos sprendim\u0105", 
    "{user} left a comment on your question": "{user} pakomentavo j\u016bs\u0173 klausim\u0105"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "Y \\m. E j \\d., H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%d.%m.%y %H:%M:%S", 
      "%d.%m.%y %H:%M:%S.%f", 
      "%d.%m.%y %H:%M", 
      "%d.%m.%y %H.%M.%S", 
      "%d.%m.%y %H.%M.%S.%f", 
      "%d.%m.%y %H.%M", 
      "%d.%m.%y", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "Y \\m. E j \\d.", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%d.%m.%Y", 
      "%d.%m.%y"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "E j \\d.", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "Y-m-d H:i", 
    "SHORT_DATE_FORMAT": "Y-m-d", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M", 
      "%H.%M.%S", 
      "%H.%M.%S.%f", 
      "%H.%M"
    ], 
    "YEAR_MONTH_FORMAT": "Y \\m. F"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

