

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> stem voor \u2018nuttig\u2019</div>", 
      "<div {countattr}>{n}</div><div {textattr}> stemmen voor \u2018nuttig\u2019</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> probleem opgelost</div>", 
      "<div {countattr}>{n}</div><div {textattr}> problemen opgelost</div>"
    ], 
    "A user with that email address already exists.": "Er bestaat al een gebruiker met dat e-mailadres.", 
    "A user with that username exists": "Er bestaat een gebruiker met die gebruikersnaam", 
    "All My Questions": "Al mijn vragen", 
    "Already registered? Sign in": "Al geregistreerd? Aanmelden", 
    "An account lets you answer questions, track contributions and receive alerts.": "Met een account kunt u vragen beantwoorden, bijdragen volgen en meldingen ontvangen.", 
    "Another helper has answered this question, please choose another.": "Een andere helper heeft deze vraag beantwoord, kies een andere.", 
    "Answer Questions": "Vragen beantwoorden", 
    "Answer a Question": "Eem vraag beantwoorden", 
    "Answer questions": "Vragen beantwoorden", 
    "Answered Questions": "Beantwoorde vragen", 
    "Ask a Question": "Een vraag stellen", 
    "Audio/Music/FMRadio": "Audio/Muziek/FM-radio", 
    "Be aware that you will lose your history when you sign in to your account.": "Houd er rekening mee dat uw geschiedenis verloren gaat als u zich bij uw account aanmeldt.", 
    "Browser/Download": "Browser/Downloaden", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp ondersteunt momenteel geen \u2018<span id=\"language\"></span>\u2019.", 
    "Camera/Gallery/Video": "Camera/Galerij/Video", 
    "Can't change this field.": "Kan dit veld niet wijzigen.", 
    "Cancel": "Annuleren", 
    "Cancel Sign Up": "Registratie annuleren", 
    "Cellular Data/WiFi/Bluetooth": "Mobiele gegevens/Wifi/Bluetooth", 
    "Choose a category": "Kies een categorie", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Klik op de koppeling in uw e-mailbericht om te laten weten dat het is ontvangen. Keer daarna terug naar BuddyUp en maak andere gebruikers blij!", 
    "Clock/Alarm": "Klok/Alarm", 
    "Close": "Sluiten", 
    "Confirm Account": "Account bevestigen", 
    "Continue": "Doorgaan", 
    "Create Account": "Account aanmaken", 
    "Create account or sign in": "Account aanmaken of aanmelden", 
    "Device": "Apparaat", 
    "Dialer/Contacts": "Kiezer/Contacten", 
    "Don't have an account? Register": "Hebt u geen account? Registreren", 
    "Done": "Gereed", 
    "Email Address": "E-mailadres", 
    "Email/Calendar": "E-mail/Agenda", 
    "Enter a valid email address.": "Voer een geldig e-mailadres in.", 
    "Failed": "Mislukt", 
    "Forgot your password?": "Uw wachtwoord vergeten?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Uw wachtwoord vergeten? Geen zorgen. Voer hieronder uw gebruikersnaam in en we sturen instructies voor het instellen van een nieuwe.", 
    "Get a Buddy to help you with your device": "Een buddy vinden om u te helpen met uw apparaat", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Ga naar het Nieuwe tabblad om enkele vragen te beantwoorden. We houden ze hier bij.", 
    "Has your question been solved?": "Is uw probleem opgelost?", 
    "Have Answers?": "Hebt u antwoorden?", 
    "Have Questions?": "Hebt u vragen?", 
    "Help Article": "Hulpartikel", 
    "Help other users around the world": "Help andere gebruikers over de hele wereld", 
    "Incompatible version": "Incompatibele versie", 
    "Keyboard": "Toetsenbord", 
    "Language": "Taal", 
    "Last sync:": "Laatste synchronisatie:", 
    "Load more": "Meer laden", 
    "Maps/GPS": "Kaarten/Gps", 
    "Marketplace/Apps Install": "Marketplace/App-installatie", 
    "My Profile": "Mijn profiel", 
    "My Question": "Mijn vraag", 
    "My Questions": "Mijn vragen", 
    "My list": "Mijn lijst", 
    "My preferences": "Mijn voorkeuren", 
    "New": "Nieuw", 
    "No active questions": "Geen actieve vragen", 
    "No matching user setting found.": "Geen overeenkomende gebruikersinstelling gevonden.", 
    "No questions": "Geen vragen", 
    "OK": "OK", 
    "Ok": "OK", 
    "Operator": "Operator", 
    "Other": "Overig", 
    "Password": "Wachtwoord", 
    "Performance": "Prestaties", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Stel uw vragen in het Engels, of ga naar <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> voor meer hulp.", 
    "Previously Answered": "Eerder beantwoord", 
    "Quit": "Afsluiten", 
    "Reset Password": "Wachtwoord herinitialiseren", 
    "SMS/MMS": "Sms/Mms", 
    "Sending\u2026": "Verzenden\u2026", 
    "Settings": "Instellingen", 
    "Sign In": "Aanmelden", 
    "Sign in to answer questions from Firefox OS users.": "Meld u aan om vragen van Firefox OS-gebruikers te beantwoorden.", 
    "Sign in to answer questions from the Mozilla community.": "Meld u aan om vragen van de Mozilla-gemeenschap te beantwoorden.", 
    "Sign in to reply": "Meld u aan om te antwoorden", 
    "Solution \u2713": "Oplossing \u2713", 
    "Storage/SD card": "Opslag/SD-kaart", 
    "Support": "Ondersteuning", 
    "System Updates": "Systeemupdates", 
    "Thank you for your question!": "Bedankt voor uw vraag!", 
    "There was a problem with Buddy Up, please try again.": "Er was een probleem met Buddy Up, probeer het opnieuw.", 
    "This field is required.": "Dit veld is verplicht.", 
    "This solved my question": "Dit heeft mijn probleem opgelost", 
    "This will close the question and let your buddy know you no longer need help.": "Hierdoor wordt de vraag gesloten en uw buddy ge\u00efnformeerd dat u geen hulp meer nodig hebt.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Te veel vragen? Gebruik de onderstaande instellingen om de lijst \u2018Een vraag beantwoorden\u2019 te verkleinen.", 
    "Top Helpers this Week": "Tophelpers deze week", 
    "Unable to generate username.": "Kan geen gebruikersnaam genereren.", 
    "Unable to log in with provided credentials.": "Kan niet aanmelden met opgegeven referenties.", 
    "Unknown error: \"{error}\"": "Onbekende fout: \u2018{error}\u2019", 
    "Unsupported Language": "Niet-ondersteunde taal", 
    "User account is disabled.": "Gebruikersaccount is uitgeschakeld.", 
    "User not found.": "Gebruiker niet gevonden.", 
    "Username": "Gebruikersnaam", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Gebruikersnamen mogen alleen letters, cijfers, \u2018.\u2019 en \u2018-\u2019 bevatten.", 
    "We can help<br>Ask us anything!": "We kunnen helpen<br>U kunt alles vragen!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Het spijt ons, maar BuddyUp kan niet in uw versie van Firefox OS worden ge\u00efnstalleerd. Sluit dit venster om naar uw startscherm terug te keren.", 
    "We've sent a welcome email to:": "Er is een welkomstmailtje verstuurd naar:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "We hebben een e-mailbericht gestuurd. Klik op de koppeling in het e-mailbericht om uw wachtwoord opnieuw in te stellen.", 
    "Whoops!": "Oeps!", 
    "Write your message\u2026": "Schrijf uw bericht\u2026", 
    "Yay, you're almost done!": "Joepie, u bent bijna klaar!", 
    "You are not online, please check your connection.": "U bent niet online, controleer uw verbinding.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "U ontvangt een melding zodra een Buddy de vraag oppakt.", 
    "just now": "zojuist", 
    "x hours ago": "x uur geleden", 
    "{n} day ago": [
      "{n} dag geleden", 
      "{n} dagen geleden"
    ], 
    "{n} helpful vote": [
      "{n} stem voor \u2018nuttig\u2019", 
      "{n} stemmen voor \u2018nuttig\u2019"
    ], 
    "{n} hour ago": [
      "{n} uur geleden", 
      "{n} uur geleden"
    ], 
    "{n} minute ago": [
      "{n} minuut geleden", 
      "{n} minuten geleden"
    ], 
    "{n} question solved": [
      "{n} probleem opgelost", 
      "{n} problemen opgelost"
    ], 
    "{user} chose your answer as a solution": "{user} heeft uw antwoord als oplossing gekozen", 
    "{user} left a comment on your question": "{user} heeft een reactie op uw vraag geplaatst"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j F Y H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%d-%m-%Y %H:%M:%S", 
      "%d-%m-%y %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S", 
      "%d/%m/%Y %H:%M:%S", 
      "%d/%m/%y %H:%M:%S", 
      "%Y/%m/%d %H:%M:%S", 
      "%d-%m-%Y %H:%M:%S.%f", 
      "%d-%m-%y %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%d/%m/%Y %H:%M:%S.%f", 
      "%d/%m/%y %H:%M:%S.%f", 
      "%Y/%m/%d %H:%M:%S.%f", 
      "%d-%m-%Y %H.%M:%S", 
      "%d-%m-%y %H.%M:%S", 
      "%d/%m/%Y %H.%M:%S", 
      "%d/%m/%y %H.%M:%S", 
      "%d-%m-%Y %H.%M:%S.%f", 
      "%d-%m-%y %H.%M:%S.%f", 
      "%d/%m/%Y %H.%M:%S.%f", 
      "%d/%m/%y %H.%M:%S.%f", 
      "%d-%m-%Y %H:%M", 
      "%d-%m-%y %H:%M", 
      "%Y-%m-%d %H:%M", 
      "%d/%m/%Y %H:%M", 
      "%d/%m/%y %H:%M", 
      "%Y/%m/%d %H:%M", 
      "%d-%m-%Y %H.%M", 
      "%d-%m-%y %H.%M", 
      "%d/%m/%Y %H.%M", 
      "%d/%m/%y %H.%M", 
      "%d-%m-%Y", 
      "%d-%m-%y", 
      "%Y-%m-%d", 
      "%d/%m/%Y", 
      "%d/%m/%y", 
      "%Y/%m/%d"
    ], 
    "DATE_FORMAT": "j F Y", 
    "DATE_INPUT_FORMATS": [
      "%d-%m-%Y", 
      "%d-%m-%y", 
      "%d/%m/%Y", 
      "%d/%m/%y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "j-n-Y H:i", 
    "SHORT_DATE_FORMAT": "j-n-Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H.%M:%S", 
      "%H.%M:%S.%f", 
      "%H.%M", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

