

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n==1 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> podzi\u0119kowanie</div>", 
      "<div {countattr}>{n}</div><div {textattr}> podzi\u0119kowania</div>", 
      "<div {countattr}>{n}</div><div {textattr}> podzi\u0119kowa\u0144</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> problem zosta\u0142 rozwi\u0105zany</div>", 
      "<div {countattr}>{n}</div><div {textattr}> problemy zosta\u0142y rozwi\u0105zane</div>", 
      "<div {countattr}>{n}</div><div {textattr}> problem\u00f3w zosta\u0142o rozwi\u0105zanych</div>"
    ], 
    "A user with that email address already exists.": "U\u017cytkownik o podanym adresie e-mail ju\u017c istnieje", 
    "A user with that username exists": "U\u017cytkownik o podanej nazwie ju\u017c istnieje", 
    "All My Questions": "Wszystkie moje pytania", 
    "Already registered? Sign in": "Masz ju\u017c rejestracj\u0119? Zaloguj si\u0119.", 
    "An account lets you answer questions, track contributions and receive alerts.": "Konto umo\u017cliwia odpowiadanie na pytania, \u015bledzenie zmian i nowych artyku\u0142\u00f3w oraz otrzymywanie powiadomie\u0144.", 
    "Another helper has answered this question, please choose another.": "Kto\u015b inny odpowiedzia\u0142 na to pytanie. Wybierz nast\u0119pnego.", 
    "Answer Questions": "Odpowiedzi na pytania", 
    "Answer a Question": "Odpowiedz na pytanie", 
    "Answer questions": "Odpowiadanie na pytania", 
    "Answered Questions": "Odpowiedzi na pytania", 
    "Ask a Question": "Zadaj pytanie", 
    "Audio/Music/FMRadio": "Audio/Muzyka/RadioFM", 
    "Be aware that you will lose your history when you sign in to your account.": "Gdy zalogujesz si\u0119 na swoje konto, stracisz histori\u0119.", 
    "Browser/Download": "Przegl\u0105darka/Pobieranie", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "Aktualnie Pomocnik nie obs\u0142uguje j\u0119zyka \u201e<span id=\"language\"></span>\u201d.", 
    "Camera/Gallery/Video": "Kamera/Galeria/Wideo", 
    "Can't change this field.": "Nie mo\u017cna zmieni\u0107 zawarto\u015bci tego pola", 
    "Cancel": "Anuluj", 
    "Cancel Sign Up": "Anuluj rejestracj\u0119", 
    "Cellular Data/WiFi/Bluetooth": "Dane kom\u00f3rkowe/WiFi/Bluetooth", 
    "Choose a category": "Wybierz kategori\u0119", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Kliknij odno\u015bnik zawarty w otrzymanej wiadomo\u015bci, by potwierdzi\u0107 rejestracj\u0119 i wr\u00f3\u0107 do BuddyUp, aby uszcz\u0119\u015bliwia\u0107 innych!", 
    "Clock/Alarm": "Zegar/Alarm", 
    "Close": "Zamknij", 
    "Confirm Account": "Potwierd\u017a konto", 
    "Continue": "Kontynuuj", 
    "Create Account": "Utw\u00f3rz konto", 
    "Create account or sign in": "Utw\u00f3rz konto lub zaloguj si\u0119", 
    "Device": "Urz\u0105dzenie", 
    "Dialer/Contacts": "Dialer/Kontakty", 
    "Don't have an account? Register": "Nie masz konta? Zarejestruj si\u0119.", 
    "Done": "Gotowe", 
    "Email Address": "Adres e-mail", 
    "Email/Calendar": "E-mail/Kalendarz", 
    "Failed": "Nie powiod\u0142o si\u0119", 
    "Forgot your password?": "Nie pami\u0119tasz has\u0142a?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Nie pami\u0119tasz has\u0142a? Nie martw si\u0119. Poni\u017cej podaj swoj\u0105 nazw\u0119 u\u017cytkownika, a my wy\u015blemy ci instrukcj\u0119, jak ustanowi\u0107 nowe has\u0142o.", 
    "Get a Buddy to help you with your device": "Popro\u015b Pomocnika, by pom\u00f3g\u0142 ci rozwi\u0105za\u0107 problem z twoim urz\u0105dzeniem.", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Przejd\u017a do nowej karty, aby odpowiedzie\u0107 na kilka pyta\u0144. B\u0119dziemy \u015bledzi\u0107 je tutaj.", 
    "Has your question been solved?": "Czy tw\u00f3j problem zosta\u0142 rozwi\u0105zany?", 
    "Have Answers?": "Znasz odpowiedzi?", 
    "Have Questions?": "Masz pytania?", 
    "Help Article": "Pomocny artyku\u0142", 
    "Help other users around the world": "Pom\u00f3\u017c innym u\u017cytkownikom na ca\u0142ym \u015bwiecie", 
    "Incompatible version": "Niekompatybilna wersja", 
    "Keyboard": "Klawiatura", 
    "Language": "J\u0119zyk", 
    "Last sync:": "Ostatnia synchronizacja:", 
    "Load more": "Pobierz wi\u0119cej", 
    "Maps/GPS": "Mapy/GPS", 
    "Marketplace/Apps Install": "Marketplace/Instalacja aplikacji", 
    "My Profile": "M\u00f3j profil", 
    "My Question": "Moje pytanie", 
    "My Questions": "Moje pytania", 
    "My list": "Moja lista", 
    "My preferences": "Moje preferencje", 
    "New": "Nowe", 
    "No active questions": "Nie ma aktywnych pyta\u0144", 
    "No matching user setting found.": "Nie znaleziono ustawienia u\u017cytkownika", 
    "No questions": "Nie ma pyta\u0144", 
    "OK": "OK", 
    "Ok": "OK", 
    "Operator": "Operator", 
    "Other": "Inne", 
    "Password": "Has\u0142o", 
    "Performance": "Wydajno\u015b\u0107", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Zadaj swoje pytanie w j\u0119zyku angielskim, lub przejd\u017a na stron\u0119 <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a>, by uzyska\u0107 wi\u0119cej informacji.", 
    "Previously Answered": "Wcze\u015bniej odpowiedziane", 
    "Quit": "Zako\u0144cz", 
    "Reset Password": "Resetuj has\u0142o", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Wysy\u0142anie\u2026", 
    "Settings": "Ustawienia", 
    "Sign In": "Zaloguj si\u0119", 
    "Sign in to answer questions from Firefox OS users.": "Zaloguj si\u0119, aby odpowiedzie\u0107 na pytania u\u017cytkownik\u00f3w Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Zaloguj si\u0119, aby odpowiedzie\u0107 na pytania spo\u0142eczno\u015bci Mozilli.", 
    "Sign in to reply": "Zaloguj si\u0119, aby odpowiedzie\u0107", 
    "Solution \u2713": "Rozwi\u0105zanie \u2713", 
    "Storage/SD card": "Przechowywanie/Karta SD", 
    "Support": "Pomoc", 
    "System Updates": "Aktualizacje systemu", 
    "Thank you for your question!": "Dzi\u0119kujemy za pytanie!", 
    "There was a problem with Buddy Up, please try again.": "Wyst\u0105pi\u0142 problem z Pomocnikiem, spr\u00f3buj ponownie.", 
    "This field is required.": "To pole jest wymagane", 
    "This solved my question": "To rozwi\u0105za\u0142o m\u00f3j problem", 
    "This will close the question and let your buddy know you no longer need help.": "Spowoduje to zamkni\u0119cie pytania i powiadomi Pomocnika, \u017ce nie potrzebujesz ju\u017c pomocy.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Zbyt wiele pyta\u0144? U\u017cyj poni\u017cszych ustawie\u0144, aby zaw\u0119zi\u0107 list\u0119 \u201eOdpowiedz na pytanie\u201d.", 
    "Top Helpers this Week": "Czo\u0142owi Pomocnicy w tym tygodniu", 
    "Unable to generate username.": "Nie mo\u017cna wygenerowa\u0107 nazwy u\u017cytkownika", 
    "Unknown error: \"{error}\"": "Nieznany b\u0142\u0105d: \"{error}\"", 
    "Unsupported Language": "Nieobs\u0142ugiwane j\u0119zyki", 
    "User not found.": "Nie znaleziono u\u017cytkownika.", 
    "Username": "Nazwa u\u017cytkownika", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Nazwa u\u017cytkownika mo\u017ce zawiera\u0107 tylko litery, cyfry oraz znak \".\" i \"-\"", 
    "We can help<br>Ask us anything!": "Mo\u017cemy ci pom\u00f3c<br>Mo\u017cesz nas pyta\u0107 o wszystko!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Przepraszamy, ale na twojej wersji systemu Firefox OS nie mo\u017cna zainstalowa\u0107 Pomocnika.", 
    "We've sent a welcome email to:": "Wiadomo\u015b\u0107 powitalna zosta\u0142a wys\u0142ana do:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Wys\u0142ali\u015bmy ci wiadomo\u015b\u0107. Kliknij odno\u015bnik znajduj\u0105cy si\u0119 w wiadomo\u015bci, by zresetowa\u0107 swoje has\u0142o.", 
    "Whoops!": "Ups!", 
    "Write your message\u2026": "Napisz swoj\u0105 wiadomo\u015b\u0107&hellip;", 
    "Yay, you're almost done!": "O! Prawie wszystko gotowe.", 
    "You are not online, please check your connection.": "Nie jeste\u015b online. Sprawd\u017a swoje po\u0142\u0105czenie.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Otrzymasz powiadomienie, gdy tylko Pomocnik przyb\u0119dzie ci na ratunek.", 
    "just now": "teraz", 
    "x hours ago": "x godzin temu", 
    "{n} day ago": [
      "{n} dzie\u0144 temu", 
      "{n} dni temu", 
      "{n} dni temu"
    ], 
    "{n} helpful vote": [
      "{n} podzi\u0119kowanie", 
      "{n} podzi\u0119kowania", 
      "{n} podzi\u0119kowa\u0144"
    ], 
    "{n} hour ago": [
      "{n} godzin\u0119 temu", 
      "{n} godziny temu", 
      "{n} godzin temu"
    ], 
    "{n} minute ago": [
      "{n} minut\u0119 temu", 
      "{n} minuty temu", 
      "{n} minut temu"
    ], 
    "{n} question solved": [
      "rozwi\u0105zano {n} problem", 
      "rozwi\u0105zano {n} problemy", 
      "rozwi\u0105zano {n} problem\u00f3w"
    ], 
    "{user} chose your answer as a solution": "{user} wybra\u0142 twoj\u0105 odpowied\u017a jako rozwi\u0105zanie", 
    "{user} left a comment on your question": "{user} skomentowa\u0142 twoje pytanie"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j E Y H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j E Y", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%y-%m-%d", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d-m-Y  H:i:s", 
    "SHORT_DATE_FORMAT": "d-m-Y", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

