

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n > 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u00fatil</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u00fateis</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> resolvida</div>", 
      "<div {countattr}>{n}</div><div {textattr}> resolvidas</div>"
    ], 
    "A user with that email address already exists.": "J\u00e1 existe um usu\u00e1rio com esse endere\u00e7o de e-mail.", 
    "A user with that username exists": "J\u00e1 existe um usu\u00e1rio com esse nome de usu\u00e1rio", 
    "All My Questions": "Todas as minhas perguntas", 
    "Already registered? Sign in": "J\u00e1 se registrou? Entre", 
    "An account lets you answer questions, track contributions and receive alerts.": "Uma conta para responde perguntas, monitorar contribui\u00e7\u00f5es e recebe alertas.", 
    "Another helper has answered this question, please choose another.": "Outra pessoa respondeu esta pergunta, passe para a pr\u00f3xima.", 
    "Answer Questions": "Perguntas respondidas", 
    "Answer a Question": "Responder uma pergunta", 
    "Answer questions": "Responder", 
    "Answered Questions": "Perguntas respondidas", 
    "Ask a Question": "Fa\u00e7a uma pergunta", 
    "Audio/Music/FMRadio": "\u00c1udio/M\u00fasica/RadioFM", 
    "Be aware that you will lose your history when you sign in to your account.": "Esteja ciente que voc\u00ea perder\u00e1 seu hist\u00f3rico quando acessar sua conta.", 
    "Browser/Download": "Navegador/Download", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp atualmente n\u00e3o suporta \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "C\u00e2mera/Galeria/v\u00eddeo", 
    "Can't change this field.": "Este campo n\u00e3o pode ser alterado.", 
    "Cancel": "Cancelar", 
    "Cancel Sign Up": "Cancelar cadastro", 
    "Cellular Data/WiFi/Bluetooth": "Dados celular/Wi-Fi/Bluetooth", 
    "Choose a category": "Escolha uma categoria", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Clique no link do seu e-mail para que possamos saber que ele foi para o lugar certo. Depois disso, retorne ao BuddyUp e fa\u00e7a outros usu\u00e1rios felizes!", 
    "Clock/Alarm": "Rel\u00f3gio/Alarme", 
    "Close": "Fechar", 
    "Confirm Account": "Confirmar conta", 
    "Continue": "Continue", 
    "Create Account": "Criar conta", 
    "Create account or sign in": "Crie uma conta ou entre", 
    "Device": "Dispositivo", 
    "Dialer/Contacts": "Discador/Contatos", 
    "Don't have an account? Register": "N\u00e3o tem uma conta? Registre-se", 
    "Done": "Pronto", 
    "Email Address": "Endere\u00e7o de e-mail", 
    "Email/Calendar": "E-mail/Calend\u00e1rio", 
    "Enter a valid email address.": "Informe um endere\u00e7o de email v\u00e1lido.", 
    "Failed": "Falhou", 
    "Forgot your password?": "Esqueceu sua senha?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Esqueceu sua senha? N\u00e3o se preocupe. Digite seu nome de usu\u00e1rio abaixo e enviaremos instru\u00e7\u00f5es para criar uma nova.", 
    "Get a Buddy to help you with your device": "Ter um amigo para ajudar com seu dispositivo", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "V\u00e1 para a Nova aba para responder algumas perguntas. Vamos mant\u00ea-las aqui.", 
    "Has your question been solved?": "Sua pergunta foi resolvida?", 
    "Have Answers?": "Sabe as respostas?", 
    "Have Questions?": "Tem perguntas?", 
    "Help Article": "Artigo de ajuda", 
    "Help other users around the world": "Ajude outros usu\u00e1rios ao redor do mundo", 
    "Incompatible version": "Vers\u00e3o incompat\u00edvel", 
    "Keyboard": "Teclado", 
    "Language": "Idioma", 
    "Last sync:": "\u00daltima sincroniza\u00e7\u00e3o:", 
    "Load more": "Carregar mais", 
    "Maps/GPS": "Mapas/GPS", 
    "Marketplace/Apps Install": "Marketplace/Instala\u00e7\u00e3o de Apps", 
    "My Profile": "Meu perfil", 
    "My Question": "Minha pergunta", 
    "My Questions": "Minhas perguntas", 
    "My list": "Minha lista", 
    "My preferences": "Minhas prefer\u00eancias", 
    "New": "Novo", 
    "No active questions": "Nenhuma pergunta ativa", 
    "No matching user setting found.": "Nenhuma configura\u00e7\u00e3o de usu\u00e1rio correspondente foi encontrada.", 
    "No questions": "Sem perguntas", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Operator": "Operadora", 
    "Other": "Outro", 
    "Password": "Senha", 
    "Performance": "Desempenho", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Por favor, fa\u00e7a suas perguntas em ingl\u00eas, ou v\u00e1 para <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> para obter mais ajuda.", 
    "Previously Answered": "Respondida anteriormente", 
    "Quit": "Sair", 
    "Reset Password": "Redefinir Senha", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Enviando\u2026", 
    "Settings": "Configura\u00e7\u00f5es", 
    "Sign In": "Entrar", 
    "Sign in to answer questions from Firefox OS users.": "Entre para responder perguntas de usu\u00e1rios do Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Entre para responder \u00e0s perguntas da comunidade Mozilla.", 
    "Sign in to reply": "Entre para responder", 
    "Solution \u2713": "Solu\u00e7\u00e3o \u2713", 
    "Storage/SD card": "Armazenamento/SD card", 
    "Support": "Suporte", 
    "System Updates": "Atualiza\u00e7\u00f5es do sistema", 
    "Thank you for your question!": "Obrigado por sua pergunta!", 
    "There was a problem with Buddy Up, please try again.": "Houve um problema com o Buddy Up, tente novamente.", 
    "This field is required.": "Este campo \u00e9 necess\u00e1rio.", 
    "This solved my question": "Resolveu meu problema", 
    "This will close the question and let your buddy know you no longer need help.": "Isso fechar\u00e1 a pergunta e avisar\u00e1 seu amigo que voc\u00ea n\u00e3o precisa mais de ajuda.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Muitas perguntas? Use as configura\u00e7\u00f5es abaixo para diminuir a lista \"Responder\".", 
    "Top Helpers this Week": "Ajudantes em destaque esta semana", 
    "Unable to generate username.": "N\u00e3o foi poss\u00edvel gerar o nome de usu\u00e1rio.", 
    "Unable to log in with provided credentials.": "N\u00e3o foi poss\u00edvel entrar com as credenciais fornecidas.", 
    "Unknown error: \"{error}\"": "Erro desconhecido: \"{error}\"", 
    "Unsupported Language": "Idioma n\u00e3o suportado", 
    "User account is disabled.": "Conta de usu\u00e1rio desabilitada.", 
    "User not found.": "Usu\u00e1rio n\u00e3o encontrado.", 
    "Username": "Nome de usu\u00e1rio", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Os nomes de usu\u00e1rio s\u00f3 podem ter letras, n\u00fameros, \".\" e \"-\".", 
    "We can help<br>Ask us anything!": "N\u00f3s podemos ajudar<br>Pergunte alguma coisa!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Lamentamos, mas o BuddyUp n\u00e3o pode ser instalado na sua vers\u00e3o do Firefox OS. Por favor, feche esta janela para retornar \u00e0 sua tela inicial.", 
    "We've sent a welcome email to:": "Enviamos um e-mail de boas-vindas para:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Enviamos um e-mail para voc\u00ea. Basta clicar no link no e-mail para redefinir sua senha.", 
    "Whoops!": "Ooops!", 
    "Write your message\u2026": "Escreva a sua mensagem\u2026", 
    "Yay, you're almost done!": "Legal, voc\u00ea est\u00e1 quase pronto!", 
    "You are not online, please check your connection.": "Voc\u00ea n\u00e3o est\u00e1 online, verifique sua conex\u00e3o.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Voc\u00ea receber\u00e1 uma notifica\u00e7\u00e3o assim que um amigo chegar para ajuda-lo.", 
    "just now": "s\u00f3 agora", 
    "x hours ago": "x horas atr\u00e1s", 
    "{n} day ago": [
      "\u00e0 {n} dia", 
      "\u00e0 {n} dias"
    ], 
    "{n} helpful vote": [
      "{n} \u00fatil", 
      "{n} \u00fateis"
    ], 
    "{n} hour ago": [
      "\u00e0 {n} hora", 
      "\u00e0 {n} horas"
    ], 
    "{n} minute ago": [
      "\u00e0 {n} minuto", 
      "\u00e0 {n} minutos"
    ], 
    "{n} question solved": [
      "{n} pergunta resolvida", 
      "{n} perguntas resolvidas"
    ], 
    "{user} chose your answer as a solution": "{user} escolheu sua resposta como uma solu\u00e7\u00e3o", 
    "{user} left a comment on your question": "{user} deixou um coment\u00e1rio na sua pergunta"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j \\d\\e F \\d\\e Y \u00e0\\s H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S", 
      "%d/%m/%Y %H:%M:%S.%f", 
      "%d/%m/%Y %H:%M", 
      "%d/%m/%Y", 
      "%d/%m/%y %H:%M:%S", 
      "%d/%m/%y %H:%M:%S.%f", 
      "%d/%m/%y %H:%M", 
      "%d/%m/%y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j \\d\\e F \\d\\e Y", 
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y", 
      "%d/%m/%y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "j \\d\\e F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i", 
    "SHORT_DATE_FORMAT": "d/m/Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F \\d\\e Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

