

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> voto de utilidade</div>", 
      "<div {countattr}>{n}</div><div {textattr}> votos de utilidade</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> quest\u00e3o resolvida</div>", 
      "<div {countattr}>{n}</div><div {textattr}> quest\u00f5es resolvidas</div>"
    ], 
    "A user with that email address already exists.": "J\u00e1 existe um utilizador com esse endere\u00e7o de email.", 
    "A user with that username exists": "J\u00e1 existe um utilizador com esse nome de utilizador.", 
    "All My Questions": "Todas as Minhas Peguntas", 
    "Already registered? Sign in": "J\u00e1 se registrou? Entre", 
    "An account lets you answer questions, track contributions and receive alerts.": "Uma conta lhe permite responder perguntas, monitorar contribui\u00e7\u00f5es e receber alertas.", 
    "Another helper has answered this question, please choose another.": "Outro ajudante respondeu essa pergunta, por favor, outra.", 
    "Answer Questions": "Perguntas Respondidas", 
    "Answer a Question": "Responder uma Pergunta", 
    "Answer questions": "Responder a quest\u00f5es", 
    "Answered Questions": "Perguntas Respondidas", 
    "Ask a Question": "Fa\u00e7a uma Pergunta", 
    "Audio/Music/FMRadio": "\u00c1udio/M\u00fasica/R\u00e1dio FM", 
    "Be aware that you will lose your history when you sign in to your account.": "Esteja ciente que voc\u00ea perder\u00e1 seu hist\u00f3rico quando voc\u00ea acessar sua conta.", 
    "Browser/Download": "Navegador/Transfer\u00eancia", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "O BuddyUp atualmente n\u00e3o suporta \"<span id=\"language\"></span>\".\"", 
    "Camera/Gallery/Video": "C\u00e2mara/Fotografia/V\u00eddeo", 
    "Can't change this field.": "Este campo n\u00e3o pode ser alterado.", 
    "Cancel": "Cancelar", 
    "Cancel Sign Up": "Cancelar Cadastro", 
    "Cellular Data/WiFi/Bluetooth": "Dados m\u00f3veis/WiFi/Bluetooth", 
    "Choose a category": "Escolha uma categoria", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Clique no link do seu e-mail para que possamos saber que ele foi para o lugar certo. Depois disso, retorne ao BuddyUp e fa\u00e7a outros usu\u00e1rios felizes!", 
    "Clock/Alarm": "Rel\u00f3gio/Alarme", 
    "Close": "Fechar", 
    "Confirm Account": "Confirmar Conta", 
    "Continue": "Continuar", 
    "Create Account": "Criar Conta", 
    "Create account or sign in": "Crie uma conta ou entre", 
    "Device": "Dispositivo", 
    "Dialer/Contacts": "Marcador/Contactos", 
    "Don't have an account? Register": "N\u00e3o tem uma conta? Registre-se", 
    "Done": "Feito", 
    "Email Address": "Endere\u00e7o de e-mail", 
    "Email/Calendar": "E-mail/Calend\u00e1rio", 
    "Enter a valid email address.": "Introduza um endere\u00e7o de email v\u00e1lido.", 
    "Failed": "Erro", 
    "Forgot your password?": "Esqueceu sua senha?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Esqueceu sua senha? N\u00e3o se preocupe. Digite seu nome de usu\u00e1rio abaixo e lhe enviaremos instru\u00e7\u00f5es para criar uma nova.", 
    "Get a Buddy to help you with your device": "Obter um Colega para ajudar com seu dispositivo", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Aceda ao Novo separador para responder a algumas quest\u00f5es. Iremos acompanh\u00e1-las aqui.", 
    "Has your question been solved?": "Sua d\u00favida foi resolvida?", 
    "Have Answers?": "Sabe as respostas?", 
    "Have Questions?": "Alguma d\u00favida?", 
    "Help Article": "Artigo de Ajuda", 
    "Help other users around the world": "Ajude outros usu\u00e1rios ao redor do mundo", 
    "Incompatible version": "Vers\u00e3o Incompat\u00edvel", 
    "Keyboard": "Teclado", 
    "Language": "Idioma", 
    "Last sync:": "\u00daltima sincroniza\u00e7\u00e3o:", 
    "Load more": "Carregar mais", 
    "Maps/GPS": "Mapas/GPS", 
    "Marketplace/Apps Install": "Marketplace/Instala\u00e7\u00e3o de aplica\u00e7\u00f5es", 
    "My Profile": "Meu Perfil", 
    "My Question": "Minha Pergunta", 
    "My Questions": "Minhas Perguntas", 
    "My list": "Minha lista", 
    "My preferences": "As minhas prefer\u00eancias", 
    "New": "Nova", 
    "No active questions": "Sem perguntas ativas", 
    "No matching user setting found.": "N\u00e3o foi encontrada uma defini\u00e7\u00e3o de utilizador coincidente.", 
    "No questions": "Sem perguntas", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Operator": "Operador", 
    "Other": "Outro", 
    "Password": "Palavra-passe", 
    "Performance": "Desempenho", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Por favor fa\u00e7a sua pergunta em Ingl\u00eas, ou aceda a <a href=\"http://support.mozilla.org/pt-PT/\">http://support.mozilla.org/pt-PT/</a> para mais ajuda.", 
    "Previously Answered": "Respondidas Anteriormente", 
    "Quit": "Sair", 
    "Reset Password": "Redefinir Senha", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "A enviar\u2026", 
    "Settings": "Configura\u00e7\u00f5es", 
    "Sign In": "Entrar", 
    "Sign in to answer questions from Firefox OS users.": "Entre para responder perguntas de usu\u00e1rios do Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Entre para responder perguntas da comunidade Mozilla.", 
    "Sign in to reply": "Entre para responder", 
    "Solution \u2713": "Resolvido \u2713", 
    "Storage/SD card": "Armazenamento/cart\u00e3o SD", 
    "Support": "Suporte", 
    "System Updates": "Atualiza\u00e7\u00f5es de sistema", 
    "Thank you for your question!": "Obrigado por sua pergunta!", 
    "There was a problem with Buddy Up, please try again.": "Ocorreu um problema com o Buddy Up, por favor tente novamente.", 
    "This field is required.": "Este campo \u00e9 necess\u00e1rio.", 
    "This solved my question": "Isto respondeu \u00e0 minha quest\u00e3o", 
    "This will close the question and let your buddy know you no longer need help.": "Isso encerrar\u00e1 sua d\u00favida e avisar\u00e1 seu colega que voc\u00ea n\u00e3o precisa mais de ajuda.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Demasiadas quest\u00f5es? Utilize as defini\u00e7\u00f5es em baixo para diminuir a lista de \"Quest\u00f5es a responder\".", 
    "Top Helpers this Week": "Principais Ajudantes dessa Semana", 
    "Unable to generate username.": "N\u00e3o foi poss\u00edvel gerar o nome de utilizador.", 
    "Unable to log in with provided credentials.": "N\u00e3o foi poss\u00edvel iniciar sess\u00e3o com as credenciais fornecidas.", 
    "Unknown error: \"{error}\"": "Erro desconhecido: \"{error}\"", 
    "Unsupported Language": "Idioma n\u00e3o-suportado", 
    "User account is disabled.": "A conta de utilizador est\u00e1 desativada.", 
    "User not found.": "Utilizador n\u00e3o encontrado.", 
    "Username": "Nome de utilizador", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Os nomes de utilizador s\u00f3 podem conter letras, n\u00fameros, \".\" e \"-\".", 
    "We can help<br>Ask us anything!": "Podemos ajudar<br>Nos pergunte qualquer coisa!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Sentimos muito, mas o BuddyUp nao pode ser instalado na sua vers\u00e3o do Firefox OS. Por favor, feche essa janela para retornar \u00e0 sua tela inicial.", 
    "We've sent a welcome email to:": "Enviamos um e-mail de boas-vindas para:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Lhe enviamos um e-mail. Apenas siga o link no e-mail para redefinir sua senha. ", 
    "Whoops!": "Ops!", 
    "Write your message\u2026": "Escreva sua mensagem\u2026", 
    "Yay, you're almost done!": "Legal, voc\u00ea est\u00e1 quase pronto!", 
    "You are not online, please check your connection.": "Voc\u00ea n\u00e3o est\u00e1 online, por favor, verifique sua conex\u00e3o.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Voc\u00ea receber\u00e1 uma notifica\u00e7\u00e3o assim que um Colega saltar para o resgate.", 
    "just now": "mesmo agora", 
    "x hours ago": "x horas atr\u00e1s", 
    "{n} day ago": [
      "\u00e0 {n} dia", 
      "\u00e0 {n} dias"
    ], 
    "{n} helpful vote": [
      "{n} voto de utilidade", 
      "{n} votos de utilidade"
    ], 
    "{n} hour ago": [
      "\u00e0 {n} hora", 
      "\u00e0 {n} horas"
    ], 
    "{n} minute ago": [
      "\u00e0 {n} minuto", 
      "\u00e0 {n} minutos"
    ], 
    "{n} question solved": [
      "{n} quest\u00e3o resolvida", 
      "{n} quest\u00f5es resolvidas"
    ], 
    "{user} chose your answer as a solution": "{user} escolheu a sua resposta como uma solu\u00e7\u00e3o", 
    "{user} left a comment on your question": "{user} deixou um coment\u00e1rio na sua quest\u00e3o"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j \\d\\e F \\d\\e Y \u00e0\\s H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%d/%m/%Y %H:%M:%S", 
      "%d/%m/%Y %H:%M:%S.%f", 
      "%d/%m/%Y %H:%M", 
      "%d/%m/%Y", 
      "%d/%m/%y %H:%M:%S", 
      "%d/%m/%y %H:%M:%S.%f", 
      "%d/%m/%y %H:%M", 
      "%d/%m/%y"
    ], 
    "DATE_FORMAT": "j \\d\\e F \\d\\e Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%d/%m/%Y", 
      "%d/%m/%y"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "j \\d\\e F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d/m/Y H:i", 
    "SHORT_DATE_FORMAT": "d/m/Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F \\d\\e Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

