

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n==1 ? 0 : (n==0 || (n%100 > 0 && n%100 < 20)) ? 1 : 2);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> vot util</div>", 
      "de <div {countattr}>{n}</div><div {textattr}> voturi utile</div>", 
      "de <div {countattr}>{n}</div><div {textattr}> de voturi utile</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u00eentrebare rezolvat\u0103</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u00eentreb\u0103ri rezolvate</div>", 
      "<div {countattr}>{n}</div><div {textattr}> de \u00eentreb\u0103ri rezolvate</div>"
    ], 
    "A user with that email address already exists.": "Exist\u0103 deja un utilizator cu acea adres\u0103 de e-mail.", 
    "A user with that username exists": "Exist\u0103 deja un utilizator cu acest nume de utilizator", 
    "All My Questions": "Toate \u00eentreb\u0103rile mele", 
    "Already registered? Sign in": "E\u0219ti deja \u00eenregistrat? Autentific\u0103-te", 
    "An account lets you answer questions, track contributions and receive alerts.": "Un cont \u00ee\u021bi permite s\u0103 r\u0103spunzi la \u00eentreb\u0103ri, s\u0103 urm\u0103re\u0219ti contribu\u021biile \u0219i s\u0103 prime\u0219ti alerte.", 
    "Another helper has answered this question, please choose another.": "O alt\u0103 persoan\u0103 ajut\u0103toare a r\u0103spuns acestei \u00eentreb\u0103ri, te rug\u0103m s\u0103 alegi o alt\u0103 \u00eentrebare.", 
    "Answer Questions": "R\u0103spunde la \u00eentreb\u0103ri", 
    "Answer a Question": "R\u0103spunde la o \u00eentrebare", 
    "Answer questions": "R\u0103spunde la \u00eentreb\u0103ri", 
    "Answered Questions": "\u00centreb\u0103ri cu r\u0103spuns", 
    "Ask a Question": "Adreseaz\u0103 o \u00eentrebare", 
    "Audio/Music/FMRadio": "Audio/Muzic\u0103/RadioFM", 
    "Be aware that you will lose your history when you sign in to your account.": "Fii con\u0219tient de faptul c\u0103 vei pierde istoricul c\u00e2nd te autentifici \u00een cont.", 
    "Browser/Download": "Navigare/Desc\u0103rcare", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp nu suport\u0103 momentan \u201e<span id=\"language\"></span>\u201d.", 
    "Camera/Gallery/Video": "Camer\u0103/Galerie/Video", 
    "Can't change this field.": "Nu se poate modifica acest c\u00e2mp.", 
    "Cancel": "Renun\u021b\u0103", 
    "Cancel Sign Up": "Anuleaz\u0103 \u00eenregistrarea", 
    "Cellular Data/WiFi/Bluetooth": "Date mobile/WiFi/Bluetooth", 
    "Choose a category": "Alege o categorie", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Clic pe linkul din e-mailul primit pentru a ne anun\u021ba c\u0103 ai ajuns unde trebuie. Dup\u0103 aceasta, revino la BuddyUp pentru a face al\u021bi utilizatori ferici\u021bi!", 
    "Clock/Alarm": "Ceas/Alarm\u0103", 
    "Close": "\u00cenchide", 
    "Confirm Account": "Confirm\u0103 contul", 
    "Continue": "Continu\u0103", 
    "Create Account": "Creeaz\u0103 un cont", 
    "Create account or sign in": "Creeaz\u0103 un cont sau autentific\u0103-te", 
    "Device": "Dispozitivul", 
    "Dialer/Contacts": "Apelare/Contacte", 
    "Don't have an account? Register": "Nu ai un cont? \u00cenregistreaz\u0103-te", 
    "Done": "Gata", 
    "Email Address": "Adresa de e-mail", 
    "Email/Calendar": "E-mail/Calendar", 
    "Failed": "E\u0219uat", 
    "Forgot your password?": "Ai uitat parola?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Ai uitat parola? Nu te \u00eengrijora. Introdu numele de utilizator mai jos \u0219i-\u021bi vom trimite instruc\u021biuni despre cum po\u021bi seta una nou\u0103.", 
    "Get a Buddy to help you with your device": "Contacteaz\u0103 un amic pentru a te ajuta cu dispozitivul t\u0103u", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Mergi la \u201eFil\u0103 nou\u0103\u201d pentru a r\u0103spunde la c\u00e2teva \u00eentreb\u0103ri. Vom p\u0103stra eviden\u021ba acestora de aici.", 
    "Has your question been solved?": "A fost rezolvat\u0103 problema ta?", 
    "Have Answers?": "Ai r\u0103spunsuri?", 
    "Have Questions?": "Ai \u00eentreb\u0103ri?", 
    "Help Article": "Articol de ajutor", 
    "Help other users around the world": "Ajut\u0103 al\u021bi utilizatori din lumea \u00eentreag\u0103", 
    "Incompatible version": "Versiune incompatibil\u0103", 
    "Keyboard": "Tastatur\u0103", 
    "Language": "Limba", 
    "Last sync:": "Ultima sincronizare:", 
    "Load more": "\u00cencarc\u0103 mai multe", 
    "Maps/GPS": "H\u0103r\u021bi/GPS", 
    "Marketplace/Apps Install": "Marketplace/Instalare aplica\u021bii", 
    "My Profile": "Profilul meu", 
    "My Question": "\u00centrebarea mea", 
    "My Questions": "\u00centreb\u0103rile mele", 
    "My list": "Lista mea", 
    "My preferences": "Preferin\u021bele mele", 
    "New": "Nou", 
    "No active questions": "Nicio \u00eentrebare activ\u0103", 
    "No matching user setting found.": "Nu se pot g\u0103si set\u0103ri de utilizator potrivite.", 
    "No questions": "F\u0103r\u0103 \u00eentreb\u0103ri", 
    "OK": "Ok", 
    "Ok": "Ok", 
    "Operator": "Operatorul", 
    "Other": "Altele", 
    "Password": "Parol\u0103", 
    "Performance": "Performan\u021b\u0103", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Te rug\u0103m s\u0103 adresezi \u00eentreb\u0103ri \u00een englez\u0103 sau s\u0103 mergi la <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> pentru mai mult ajutor.", 
    "Previously Answered": "R\u0103spunse anterior", 
    "Quit": "\u00cenchide", 
    "Reset Password": "Reseteaz\u0103 parola", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Se trimite\u2026", 
    "Settings": "Set\u0103ri", 
    "Sign In": "Autentific\u0103-te", 
    "Sign in to answer questions from Firefox OS users.": "Autentific\u0103-te pentru a r\u0103spunde la \u00eentreb\u0103ri din partea utilizatorilor Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Autentific\u0103-te pentru a r\u0103spunde la \u00eentreb\u0103ri din partea comunit\u0103\u021bii Mozilla.", 
    "Sign in to reply": "\u00cenregistreaz\u0103-te pentru a r\u0103spunde", 
    "Solution \u2713": "Solu\u021bie \u2713", 
    "Storage/SD card": "Stocare/Card SD", 
    "Support": "Suport", 
    "System Updates": "Actualiz\u0103ri de sistem", 
    "Thank you for your question!": "Mul\u021bumim pentru \u00eentrebare!", 
    "There was a problem with Buddy Up, please try again.": "S-a produs o eroare cu Buddy Up, te rug\u0103m s\u0103 \u00eencerci din nou.", 
    "This field is required.": "Acest c\u00e2mp este obligatoriu.", 
    "This solved my question": "Aceasta mi-a rezolvat problema", 
    "This will close the question and let your buddy know you no longer need help.": "Aceasta va \u00eenchide \u00eentrebarea \u0219i va anun\u021ba amicul c\u0103 nu mai ai nevoie de ajutor.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Prea multe \u00eentreb\u0103ri? Folose\u0219te set\u0103rile de mai jos pentru a mic\u0219ora lista cu \u201eR\u0103spunde la o \u00eentrebare\u201d.", 
    "Top Helpers this Week": "Top persoane ajut\u0103toare s\u0103pt\u0103m\u00e2na aceasta", 
    "Unable to generate username.": "Nu se poate genera un nume de utilizator.", 
    "Unknown error: \"{error}\"": "Eroare necunoscut\u0103: \u201e{error}\u201d", 
    "Unsupported Language": "Limb\u0103 nesuportat\u0103", 
    "User not found.": "Utilizatorul nu a fost g\u0103sit.", 
    "Username": "Nume de utilizator", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Numele de utilizatori pot fi doar litere, numere, \u201e.\u201d \u0219i \u201e-\u201d.", 
    "We can help<br>Ask us anything!": "Te putem ajuta<br>\u00centreab\u0103-ne orice!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Ne pare r\u0103u, dar BuddyUp nu poate fi instalat pe versiunea ta de Firefox OS. \u00cenchide aceast\u0103 fereastr\u0103 pentru a reveni la ecranul principal.", 
    "We've sent a welcome email to:": "\u021ai-am trimis un mesaj de bun-venit la:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "\u021ai-am trimis un e-mail. Pur \u0219i simplu urmeaz\u0103 linkul din e-mail pentru a reseta parola.", 
    "Whoops!": "Ups!", 
    "Write your message\u2026": "Scrie mesajul t\u0103u\u2026", 
    "Yay, you're almost done!": "Ura, aproape ai terminat!", 
    "You are not online, please check your connection.": "Nu e\u0219ti online, te rug\u0103m s\u0103 verifici conexiunea.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Vei primi o notificare imediat ce un amic sare \u00een ajutor.", 
    "just now": "chiar acum", 
    "x hours ago": "acum x ore", 
    "{n} day ago": [
      "acum {n} zi", 
      "acum {n} zile", 
      "acum {n} de zile"
    ], 
    "{n} helpful vote": [
      "{n} vot util", 
      "{n} voturi utile", 
      "{n} de voturi utile"
    ], 
    "{n} hour ago": [
      "acum {n} or\u0103", 
      "acum {n} ore", 
      "acum {n} de ore"
    ], 
    "{n} minute ago": [
      "acum {n} minut", 
      "acum {n} minute", 
      "acum {n} de minute"
    ], 
    "{n} question solved": [
      "{n} \u00eentrebare rezolvat\u0103", 
      "{n} \u00eentreb\u0103ri rezolvate", 
      "{n} de \u00eentreb\u0103ri rezolvate"
    ], 
    "{user} chose your answer as a solution": "{user} a ales r\u0103spunsul t\u0103u ca solu\u021bie", 
    "{user} left a comment on your question": "{user} a l\u0103sat un comentariu la \u00eentrebarea ta"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j F Y, H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "j F Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y", 
      "%b %d %Y", 
      "%b %d, %Y", 
      "%d %b %Y", 
      "%d %b, %Y", 
      "%B %d %Y", 
      "%B %d, %Y", 
      "%d %B %Y", 
      "%d %B, %Y"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "0", 
    "SHORT_DATETIME_FORMAT": "d.m.Y, H:i:s", 
    "SHORT_DATE_FORMAT": "d.m.Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

