

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u043e\u0447\u043a\u043e \u0437\u0430 \u043f\u043e\u043c\u043e\u0449\u044c</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043e\u0447\u043a\u0430 \u0437\u0430 \u043f\u043e\u043c\u043e\u0449\u044c</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043e\u0447\u043a\u043e\u0432 \u0437\u0430 \u043f\u043e\u043c\u043e\u0449\u044c</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0439 \u0432\u043e\u043f\u0440\u043e\u0441</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445 \u0432\u043e\u043f\u0440\u043e\u0441\u0430</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432</div>"
    ], 
    "A user with that email address already exists.": "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u044d\u043b. \u043f\u043e\u0447\u0442\u044b \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.", 
    "A user with that username exists": "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442", 
    "All My Questions": "\u0412\u0441\u0435 \u043c\u043e\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u044b", 
    "Already registered? Sign in": "\u0423\u0436\u0435 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u044b? \u0412\u043e\u0439\u0442\u0438", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u0423\u0447\u0451\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u043f\u043e\u0437\u0432\u043e\u043b\u0438\u0442 \u0432\u0430\u043c \u043e\u0442\u0432\u0435\u0447\u0430\u0442\u044c \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u044b, \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0442\u044c \u043f\u043e\u043c\u043e\u0449\u044c \u0438 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f.", 
    "Another helper has answered this question, please choose another.": "\u0414\u0440\u0443\u0433\u043e\u0439 \u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a \u043e\u0442\u0432\u0435\u0442\u0438\u043b \u043d\u0430 \u044d\u0442\u043e\u0442 \u0432\u043e\u043f\u0440\u043e\u0441. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u0432\u043e\u043f\u0440\u043e\u0441.", 
    "Answer Questions": "\u041e\u0442\u0432\u0435\u0442\u0438\u0442\u044c \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u044b", 
    "Answer a Question": "\u041e\u0442\u0432\u0435\u0442\u0438\u0442\u044c \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441", 
    "Answer questions": "\u041e\u0442\u0432\u0435\u0442\u0438\u0442\u044c \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u044b", 
    "Answered Questions": "\u041e\u0442\u0432\u0435\u0447\u0435\u043d\u043d\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b", 
    "Ask a Question": "\u0417\u0430\u0434\u0430\u0442\u044c \u0432\u043e\u043f\u0440\u043e\u0441", 
    "Audio/Music/FMRadio": "\u0410\u0443\u0434\u0438\u043e/\u041c\u0443\u0437\u044b\u043a\u0430/FM-\u0440\u0430\u0434\u0438\u043e", 
    "Be aware that you will lose your history when you sign in to your account.": "\u041f\u043e\u043c\u043d\u0438\u0442\u0435, \u0447\u0442\u043e \u0432\u044b \u043f\u043e\u0442\u0435\u0440\u044f\u0435\u0442\u0435 \u0441\u0432\u043e\u044e \u0438\u0441\u0442\u043e\u0440\u0438\u044e, \u043a\u043e\u0433\u0434\u0430 \u0432\u044b \u0432\u043e\u0439\u0434\u0451\u0442\u0435 \u0432 \u0441\u0432\u043e\u044e \u0443\u0447\u0451\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c.", 
    "Browser/Download": "\u0411\u0440\u0430\u0443\u0437\u0435\u0440/\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0438", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp \u0432 \u0434\u0430\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "\u041a\u0430\u043c\u0435\u0440\u0430/\u0413\u0430\u043b\u0435\u0440\u0435\u044f/\u0412\u0438\u0434\u0435\u043e", 
    "Can't change this field.": "\u041d\u0435 \u043c\u043e\u0433\u0443 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e \u043f\u043e\u043b\u0435.", 
    "Cancel": "\u041e\u0442\u043c\u0435\u043d\u0430", 
    "Cancel Sign Up": "\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e", 
    "Cellular Data/WiFi/Bluetooth": "\u0414\u0430\u043d\u043d\u044b\u0435 \u0441\u043e\u0442\u043e\u0432\u043e\u0439 \u0441\u0435\u0442\u0438/WiFi/Bluetooth", 
    "Choose a category": "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "\u0429\u0451\u043b\u043a\u043d\u0438\u0442\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u0432 \u0432\u0430\u0448\u0435\u043c \u043f\u0438\u0441\u044c\u043c\u0435, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u044c \u043d\u0430\u043c, \u0447\u0442\u043e \u043e\u043d\u043e \u043f\u043e\u043f\u0430\u043b\u043e \u0432 \u043d\u0443\u0436\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e. \u041f\u043e\u0441\u043b\u0435 \u044d\u0442\u043e\u0433\u043e \u0432\u0435\u0440\u043d\u0438\u0442\u0435\u0441\u044c \u043a BuddyUp \u0438 \u0441\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u0434\u0440\u0443\u0433\u0438\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0441\u0447\u0430\u0441\u0442\u043b\u0438\u0432\u044b\u043c\u0438!", 
    "Clock/Alarm": "\u0427\u0430\u0441\u044b/\u0411\u0443\u0434\u0438\u043b\u044c\u043d\u0438\u043a", 
    "Close": "\u0417\u0430\u043a\u0440\u044b\u0442\u044c", 
    "Confirm Account": "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u044c \u0443\u0447\u0451\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c", 
    "Continue": "\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c", 
    "Create Account": "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0443\u0447\u0451\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c", 
    "Create account or sign in": "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0443\u0447\u0451\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0438\u043b\u0438 \u0432\u043e\u0439\u0442\u0438", 
    "Device": "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", 
    "Dialer/Contacts": "\u041d\u0430\u0431\u043e\u0440 \u043d\u043e\u043c\u0435\u0440\u0430/\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b", 
    "Don't have an account? Register": "\u041d\u0435\u0442 \u0443\u0447\u0451\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438? \u0417\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u0443\u0439\u0442\u0435\u0441\u044c", 
    "Done": "\u0413\u043e\u0442\u043e\u0432\u043e", 
    "Email Address": "\u0410\u0434\u0440\u0435\u0441 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0439 \u043f\u043e\u0447\u0442\u044b", 
    "Email/Calendar": "\u042d\u043b. \u043f\u043e\u0447\u0442\u0430/\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c", 
    "Failed": "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c", 
    "Forgot your password?": "\u0417\u0430\u0431\u044b\u043b\u0438 \u0441\u0432\u043e\u0439 \u200b\u200b\u043f\u0430\u0440\u043e\u043b\u044c?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "\u0417\u0430\u0431\u044b\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c? \u041d\u0435 \u0432\u043e\u043b\u043d\u0443\u0439\u0442\u0435\u0441\u044c. \u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0438\u0436\u0435 \u0441\u0432\u043e\u0451 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438 \u043c\u044b \u0432\u044b\u0448\u043b\u0435\u043c \u0432\u0430\u043c \u0438\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u043d\u043e\u0432\u043e\u0433\u043e.", 
    "Get a Buddy to help you with your device": "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u0435 Buddy, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043c\u043e\u0447\u044c \u0432\u0430\u043c \u0441  \u0432\u0430\u0448\u0438\u043c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\u041f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043d\u0430 \u043d\u043e\u0432\u0443\u044e \u0432\u043a\u043b\u0430\u0434\u043a\u0443, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u0432\u0435\u0442\u0438\u0442\u044c \u043d\u0430 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0432\u043e\u043f\u0440\u043e\u0441\u044b. \u041c\u044b \u0431\u0443\u0434\u0435\u043c \u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0442\u044c \u0438\u0445 \u0437\u0434\u0435\u0441\u044c.", 
    "Has your question been solved?": "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u0438 \u043e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0432\u0430\u0448 \u0432\u043e\u043f\u0440\u043e\u0441?", 
    "Have Answers?": "\u0415\u0441\u0442\u044c \u043e\u0442\u0432\u0435\u0442\u044b?", 
    "Have Questions?": "\u0415\u0441\u0442\u044c \u0432\u043e\u043f\u0440\u043e\u0441\u044b?", 
    "Help Article": "\u0421\u0442\u0430\u0442\u044c\u044f \u043f\u043e\u043c\u043e\u0449\u0438", 
    "Help other users around the world": "\u041f\u043e\u043c\u043e\u0433\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u0438\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f\u043c \u043f\u043e \u0432\u0441\u0435\u043c\u0443 \u043c\u0438\u0440\u0443", 
    "Incompatible version": "\u041d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f", 
    "Keyboard": "\u041a\u043b\u0430\u0432\u0438\u0430\u0442\u0443\u0440\u0430", 
    "Language": "\u042f\u0437\u044b\u043a", 
    "Last sync:": "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f:", 
    "Load more": "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0435\u0449\u0451", 
    "Maps/GPS": "\u041a\u0430\u0440\u0442\u044b/GPS", 
    "Marketplace/Apps Install": "Marketplace/\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0439", 
    "My Profile": "\u041c\u043e\u0439 \u041f\u0440\u043e\u0444\u0438\u043b\u044c", 
    "My Question": "\u041c\u043e\u0439 \u0432\u043e\u043f\u0440\u043e\u0441", 
    "My Questions": "\u041c\u043e\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u044b", 
    "My list": "\u041c\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a", 
    "My preferences": "\u041c\u043e\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 
    "New": "\u041d\u043e\u0432\u044b\u0439", 
    "No active questions": "\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432", 
    "No matching user setting found.": "\u041f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.", 
    "No questions": "\u041d\u0435\u0442 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Operator": "\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440", 
    "Other": "\u0414\u0440\u0443\u0433\u043e\u0435", 
    "Password": "\u041f\u0430\u0440\u043e\u043b\u044c", 
    "Performance": "\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0437\u0430\u0434\u0430\u0432\u0430\u0439\u0442\u0435 \u0441\u0432\u043e\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435 \u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043d\u0430 <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043c\u043e\u0449\u0438.", 
    "Previously Answered": "\u0420\u0430\u043d\u0435\u0435 \u043e\u0442\u0432\u0435\u0447\u0435\u043d", 
    "Quit": "\u0412\u044b\u0445\u043e\u0434", 
    "Reset Password": "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430\u2026", 
    "Settings": "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", 
    "Sign In": "\u0412\u043e\u0439\u0442\u0438", 
    "Sign in to answer questions from Firefox OS users.": "\u0412\u043e\u0439\u0434\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u0432\u0435\u0442\u0438\u0442\u044c \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043e\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "\u0412\u043e\u0439\u0434\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u043e\u0442\u0432\u0435\u0442\u0438\u0442\u044c \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u044b \u043e\u0442 \u0441\u043e\u043e\u0431\u0449\u0435\u0441\u0442\u0432\u0430 Mozilla.", 
    "Sign in to reply": "\u0412\u043e\u0439\u0442\u0438 \u0434\u043b\u044f \u043e\u0442\u0432\u0435\u0442\u0430 ", 
    "Solution \u2713": "\u0420\u0435\u0448\u0435\u043d\u0438\u0435 \u2713", 
    "Storage/SD card": "\u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435/SD-\u043a\u0430\u0440\u0442\u0430", 
    "Support": "\u041f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430", 
    "System Updates": "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b", 
    "Thank you for your question!": "\u0421\u043f\u0430\u0441\u0438\u0431\u043e \u0437\u0430 \u0432\u0430\u0448 \u0432\u043e\u043f\u0440\u043e\u0441!", 
    "There was a problem with Buddy Up, please try again.": "\u0421 Buddy Up \u0432\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0435\u0449\u0451 \u0440\u0430\u0437.", 
    "This field is required.": "\u042d\u0442\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435.", 
    "This solved my question": "\u042d\u0442\u043e \u0440\u0435\u0448\u0438\u043b\u043e \u043c\u043e\u0439 \u0432\u043e\u043f\u0440\u043e\u0441", 
    "This will close the question and let your buddy know you no longer need help.": "\u042d\u0442\u043e \u0437\u0430\u043a\u0440\u043e\u0435\u0442 \u0432\u043e\u043f\u0440\u043e\u0441 \u0438 \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u0432\u0430\u0448\u0435\u043c\u0443 buddy, \u0447\u0442\u043e \u0432\u044b \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043d\u0443\u0436\u0434\u0430\u0435\u0442\u0435\u0441\u044c \u0432 \u043f\u043e\u043c\u043e\u0449\u0438.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432? \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0440\u0430\u0437\u043c\u0435\u0449\u0451\u043d\u043d\u044b\u0435 \u043d\u0438\u0436\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438, \u0447\u0442\u043e\u0431\u044b \u0441\u0443\u0437\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \"\u041e\u0442\u0432\u0435\u0442\u043e\u0432 \u043d\u0430 \u0432\u043e\u043f\u0440\u043e\u0441\u044b\".", 
    "Top Helpers this Week": "\u0422\u043e\u043f \u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a\u043e\u0432 \u043d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435", 
    "Unable to generate username.": "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f.", 
    "Unknown error: \"{error}\"": "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430: \"{error}\"", 
    "Unsupported Language": "\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u044f\u0437\u044b\u043a", 
    "User not found.": "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.", 
    "Username": "\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "\u0418\u043c\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u043c\u043e\u0433\u0443\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b, \".\" \u0438 \"-\".", 
    "We can help<br>Ask us anything!": "\u041c\u044b \u043c\u043e\u0436\u0435\u043c \u043f\u043e\u043c\u043e\u0447\u044c<br>\u0421\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u0430\u043c \u043e \u0447\u0451\u043c \u0443\u0433\u043e\u0434\u043d\u043e!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "\u041c\u044b \u0441\u043e\u0436\u0430\u043b\u0435\u0435\u043c, \u043d\u043e BuddyUp \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043d\u0430 \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 Firefox OS. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0437\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u044d\u0442\u043e \u043e\u043a\u043d\u043e, \u0447\u0442\u043e\u0431\u044b \u0432\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0438\u0439 \u044d\u043a\u0440\u0430\u043d.", 
    "We've sent a welcome email to:": "\u041c\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u043f\u0440\u0438\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 \u043f\u0438\u0441\u044c\u043c\u043e \u043d\u0430:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "\u041c\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u043b\u0438 \u0432\u0430\u043c \u043f\u0438\u0441\u044c\u043c\u043e. \u041f\u0440\u043e\u0441\u0442\u043e \u043f\u0440\u043e\u0439\u0434\u0438\u0442\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u0432 \u043f\u0438\u0441\u044c\u043c\u0435, \u0447\u0442\u043e\u0431\u044b \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0432\u043e\u0439 \u043f\u0430\u0440\u043e\u043b\u044c.", 
    "Whoops!": "\u041e\u0439!", 
    "Write your message\u2026": "\u041d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u0432\u0430\u0448\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435\u2026", 
    "Yay, you're almost done!": "\u0423\u0440\u0430, \u0432\u044b \u043f\u043e\u0447\u0442\u0438 \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0438!", 
    "You are not online, please check your connection.": "\u0412\u044b \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u043b\u0438\u0441\u044c \u043a \u0418\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0432\u0430\u0448\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "\u0412\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435, \u043a\u0430\u043a \u0442\u043e\u043b\u044c\u043a\u043e Buddy \u043f\u0440\u0438\u0434\u0451\u0442 \u043d\u0430 \u043f\u043e\u043c\u043e\u0449\u044c.", 
    "just now": "\u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0442\u043e", 
    "x hours ago": "x \u0447\u0430\u0441\u043e\u0432 \u043d\u0430\u0437\u0430\u0434", 
    "{n} day ago": [
      "{n} \u0434\u0435\u043d\u044c \u043d\u0430\u0437\u0430\u0434", 
      "{n} \u0434\u043d\u044f \u043d\u0430\u0437\u0430\u0434", 
      "{n} \u0434\u043d\u0435\u0439 \u043d\u0430\u0437\u0430\u0434"
    ], 
    "{n} helpful vote": [
      "{n} \u043e\u0447\u043a\u043e \u0437\u0430 \u043f\u043e\u043c\u043e\u0449\u044c", 
      "{n} \u043e\u0447\u043a\u0430 \u0437\u0430 \u043f\u043e\u043c\u043e\u0449\u044c", 
      "{n} \u043e\u0447\u043a\u043e\u0432 \u0437\u0430 \u043f\u043e\u043c\u043e\u0449\u044c"
    ], 
    "{n} hour ago": [
      "{n} \u0447\u0430\u0441 \u043d\u0430\u0437\u0430\u0434", 
      "{n} \u0447\u0430\u0441\u0430 \u043d\u0430\u0437\u0430\u0434", 
      "{n} \u0447\u0430\u0441\u043e\u0432 \u043d\u0430\u0437\u0430\u0434"
    ], 
    "{n} minute ago": [
      "{n} \u043c\u0438\u043d\u0443\u0442\u0443 \u043d\u0430\u0437\u0430\u0434", 
      "{n} \u043c\u0438\u043d\u0443\u0442\u044b \u043d\u0430\u0437\u0430\u0434", 
      "{n} \u043c\u0438\u043d\u0443\u0442 \u043d\u0430\u0437\u0430\u0434"
    ], 
    "{n} question solved": [
      "\u0440\u0435\u0448\u0435\u043d {n} \u0432\u043e\u043f\u0440\u043e\u0441", 
      "\u0440\u0435\u0448\u0435\u043d\u043e {n} \u0432\u043e\u043f\u0440\u043e\u0441\u0430", 
      "\u0440\u0435\u0448\u0435\u043d\u043e {n} \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432"
    ], 
    "{user} chose your answer as a solution": "{user} \u0432\u044b\u0431\u0440\u0430\u043b \u0432\u0430\u0448 \u043e\u0442\u0432\u0435\u0442 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0440\u0435\u0448\u0435\u043d\u0438\u044f", 
    "{user} left a comment on your question": "{user} \u043f\u0440\u043e\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0438\u0440\u043e\u0432\u0430\u043b \u0432\u0430\u0448 \u0432\u043e\u043f\u0440\u043e\u0441"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j E Y \u0433. G:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%d.%m.%y %H:%M:%S", 
      "%d.%m.%y %H:%M:%S.%f", 
      "%d.%m.%y %H:%M", 
      "%d.%m.%y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j E Y \u0433.", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d.m.Y H:i", 
    "SHORT_DATE_FORMAT": "d.m.Y", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "G:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y \u0433."
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

