

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n==1) ? 0 : (n>=2 && n<=4) ? 1 : 2;
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> hlas o u\u017eito\u010dnosti</div>", 
      "<div {countattr}>{n}</div><div {textattr}> hlasy o u\u017eito\u010dnosti</div>", 
      "<div {countattr}>{n}</div><div {textattr}> hlasov o u\u017eito\u010dnosti</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}>odpove\u010f vyrie\u0161en\u00e1</div>", 
      "<div {countattr}>{n}</div><div {textattr}>odpovede vyrie\u0161en\u00e9</div>", 
      "<div {countattr}>{n}</div><div {textattr}>odpoved\u00ed vyrie\u0161en\u00fdch</div>"
    ], 
    "A user with that email address already exists.": "Pou\u017e\u00edvate\u013e s touto e-mailovou adresou u\u017e existuje.", 
    "A user with that username exists": "Pou\u017e\u00edvate\u013e s t\u00fdmto pou\u017e\u00edvate\u013esk\u00fdm menom u\u017e existuje", 
    "All My Questions": "V\u0161etky moje ot\u00e1zky", 
    "Already registered? Sign in": "Ste u\u017e zaregistrovan\u00fd? Prihl\u00e1ste sa ", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u00da\u010det v\u00e1m umo\u017en\u00ed odpoveda\u0165 na ot\u00e1zky, sledova\u0165 pr\u00edspevky a dost\u00e1va\u0165 upozornenia.", 
    "Another helper has answered this question, please choose another.": "Na t\u00fato ot\u00e1zku u\u017e odpovedal in\u00fd prispievate\u013e, vyberte si pros\u00edm in\u00fa.", 
    "Answer Questions": "Odpoveda\u0165 na ot\u00e1zky", 
    "Answer a Question": "Odpoveda\u0165 na ot\u00e1zku", 
    "Answer questions": "Odpoveda\u0165 na ot\u00e1zky", 
    "Answered Questions": "Zodpovedan\u00e9 ot\u00e1zky", 
    "Ask a Question": "Sp\u00fdta\u0165 sa ot\u00e1zku", 
    "Audio/Music/FMRadio": "Audio/Hudba/FM R\u00e1dio", 
    "Be aware that you will lose your history when you sign in to your account.": "Berte na vedomie, \u017ee prihl\u00e1sen\u00edm k svojmu \u00fa\u010dtu strat\u00edte svoju hist\u00f3riu.", 
    "Browser/Download": "Prehliada\u010d/Preberanie", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp teraz nepodporuje jazyk \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Fotoapar\u00e1t/Gal\u00e9ria/Video", 
    "Can't change this field.": "Toto pole nemo\u017eno meni\u0165.", 
    "Cancel": "Zru\u0161i\u0165", 
    "Cancel Sign Up": "Zru\u0161i\u0165 registr\u00e1ciu", 
    "Cellular Data/WiFi/Bluetooth": "Mobiln\u00e9 d\u00e1ta/Wi-Fi/Bluetooth", 
    "Choose a category": "Vyberte kateg\u00f3riu", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Kliknite na odkaz vo va\u0161om e-maili a dajte n\u00e1m tak vedie\u0165, \u017ee dorazil na spr\u00e1vne miesto. N\u00e1sledne sa vr\u00e1\u0165te na BuddyUp a za\u010dnite robi\u0165 rados\u0165 \u010fal\u0161\u00edm pou\u017e\u00edvate\u013eom!", 
    "Clock/Alarm": "Hodiny/Bud\u00edk", 
    "Close": "Zavrie\u0165", 
    "Confirm Account": "Potvrdi\u0165 \u00fa\u010det", 
    "Continue": "Pokra\u010dova\u0165", 
    "Create Account": "Vytvori\u0165 \u00fa\u010det", 
    "Create account or sign in": "Vytvori\u0165 \u00fa\u010det, alebo sa prihl\u00e1si\u0165", 
    "Device": "Zariadenie", 
    "Dialer/Contacts": "Hovory/Kontakty", 
    "Don't have an account? Register": "Nem\u00e1te \u00fa\u010det? Zaregistrujte sa", 
    "Done": "Hotovo", 
    "Email Address": "E-mailov\u00e1 adresa", 
    "Email/Calendar": "E-mail/Kalend\u00e1r", 
    "Enter a valid email address.": "Zadajte platn\u00fa e-mailov\u00fa adresu.", 
    "Failed": "Zlyhalo", 
    "Forgot your password?": "Zabudli ste heslo?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Zabudli ste heslo? Nebojte sa. Zadajte va\u0161e pou\u017e\u00edvate\u013esk\u00e9 meno a my v\u00e1m za\u0161leme in\u0161trukcie na vytvorenie nov\u00e9ho.", 
    "Get a Buddy to help you with your device": "Z\u00edskajte kamar\u00e1ta, ktor\u00fd v\u00e1m s va\u0161im zariaden\u00edm pom\u00f4\u017ee", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Pre zodpovedanie ot\u00e1zok prejdite na nov\u00fa kartu prehliada\u010da. Budeme ich tam str\u00e1\u017ei\u0165.", 
    "Has your question been solved?": "Bola va\u0161a ot\u00e1zka zodpovedan\u00e1?", 
    "Have Answers?": "M\u00e1te odpovede?", 
    "Have Questions?": "M\u00e1te ot\u00e1zky?", 
    "Help Article": "\u010cl\u00e1nok podpory", 
    "Help other users around the world": "Pom\u00f4\u017ete pou\u017e\u00edvate\u013eom na celom svete", 
    "Incompatible version": "Nekompatibiln\u00e1 verzia", 
    "Keyboard": "Kl\u00e1vesnica", 
    "Language": "Jazyk", 
    "Last sync:": "Posledn\u00e1 synchroniz\u00e1cia:", 
    "Load more": "Na\u010d\u00edta\u0165 viac", 
    "Maps/GPS": "Mapy/GPS", 
    "Marketplace/Apps Install": "Marketplace/In\u0161tal\u00e1cia aplik\u00e1ci\u00ed", 
    "My Profile": "M\u00f4j profil", 
    "My Question": "Moja ot\u00e1zka", 
    "My Questions": "Moje ot\u00e1zky", 
    "My list": "M\u00f4j zoznam", 
    "My preferences": "Moje predvo\u013eby", 
    "New": "Nov\u00e1", 
    "No active questions": "\u017diadne akt\u00edvne ot\u00e1zky", 
    "No matching user setting found.": "Po\u017eadovan\u00e9 pou\u017e\u00edvate\u013esk\u00e9 meno nebolo n\u00e1jden\u00e9.", 
    "No questions": "\u017diadne ot\u00e1zky", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Operator": "Oper\u00e1tor", 
    "Other": "In\u00e9", 
    "Password": "Heslo", 
    "Performance": "R\u00fdchlos\u0165", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Zad\u00e1vajte pros\u00edm svoje ot\u00e1zky v angli\u010dtine, alebo nav\u0161t\u00edvte <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> pre \u010fal\u0161iu pomoc.", 
    "Previously Answered": "Sk\u00f4r zodpovedan\u00e9", 
    "Quit": "Ukon\u010di\u0165", 
    "Reset Password": "Obnovi\u0165 heslo", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Odosielanie\u2026", 
    "Settings": "Nastavenia", 
    "Sign In": "Prihl\u00e1si\u0165", 
    "Sign in to answer questions from Firefox OS users.": "Pre odpovedanie na ot\u00e1zky pou\u017e\u00edvate\u013eov Firefox OS sa pros\u00edm prihl\u00e1ste.", 
    "Sign in to answer questions from the Mozilla community.": "Pre odpovedanie na ot\u00e1zky komunity Mozilla sa pros\u00edm prihl\u00e1ste.", 
    "Sign in to reply": "Ak chcete odpoveda\u0165, mus\u00edte sa prihl\u00e1si\u0165", 
    "Solution \u2713": "Vyrie\u0161en\u00e9 \u2713", 
    "Storage/SD card": "\u00dalo\u017eisko/SD karta", 
    "Support": "Podpora", 
    "System Updates": "Aktualiz\u00e1cie syst\u00e9mu", 
    "Thank you for your question!": "\u010eakujeme za va\u0161u ot\u00e1zku!", 
    "There was a problem with Buddy Up, please try again.": "Do\u0161lo k probl\u00e9mu s BuddyUp, vysk\u00fa\u0161ajte to pros\u00edm znovu.", 
    "This field is required.": "Toto pole je po\u017eadovan\u00e9.", 
    "This solved my question": "Toto vyrie\u0161ilo moju ot\u00e1zku", 
    "This will close the question and let your buddy know you no longer need help.": "T\u00fdmto uzatvor\u00edte ot\u00e1zku a d\u00e1te kamar\u00e1tom vedie\u0165, \u017ee u\u017e nepotrebujete \u010fal\u0161iu pomoc.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Pr\u00edli\u0161 ve\u013ea ot\u00e1zok? Pou\u017eite mo\u017enosti nastavenia ni\u017e\u0161ie pre skr\u00e1tenie zoznamu.", 
    "Top Helpers this Week": "Najlep\u0161\u00ed prispievatelia tohoto t\u00fd\u017ed\u0148a", 
    "Unable to generate username.": "Pou\u017e\u00edvate\u013esk\u00e9 meno nemo\u017eno vygenerova\u0165.", 
    "Unable to log in with provided credentials.": "Zo zadan\u00fdmi \u00fadajmi sa nemo\u017eno prihl\u00e1si\u0165.", 
    "Unknown error: \"{error}\"": "Nezn\u00e1ma chyba: \"{error}\"", 
    "Unsupported Language": "Nepodporovan\u00fd jazyk", 
    "User account is disabled.": "Pou\u017e\u00edvate\u013esk\u00fd \u00fa\u010det je deaktivovan\u00fd.", 
    "User not found.": "Pou\u017e\u00edvate\u013e nebol n\u00e1jden\u00fd.", 
    "Username": "Pou\u017e\u00edvate\u013esk\u00e9 meno", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Pou\u017e\u00edvate\u013esk\u00e9 men\u00e1 m\u00f4\u017eu obsahova\u0165 iba p\u00edsmen\u00e1, \u010d\u00edsla a symboly \".\" a \"-\".", 
    "We can help<br>Ask us anything!": "M\u00f4\u017eeme v\u00e1m pom\u00f4c\u0165<br>Sp\u00fdtajte sa n\u00e1s \u010doko\u013evek!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Je n\u00e1m to \u013e\u00fato, ale BuddyUp nemo\u017eno nain\u0161talova\u0165 na va\u0161u verziu Firefox OS. Pre n\u00e1vrat na domovsk\u00fa obrazovku pros\u00edm zavrite toto okno.", 
    "We've sent a welcome email to:": "Poslali sme v\u00e1m uv\u00edtac\u00ed e-mail na:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Poslali sme v\u00e1m e-mail. Pre obnovenie hesla sta\u010d\u00ed otvori\u0165 odkaz, ktor\u00fd v e-maili n\u00e1jdete.", 
    "Whoops!": "Hopps!", 
    "Write your message\u2026": "Nap\u00ed\u0161te svoju spr\u00e1vu...", 
    "Yay, you're almost done!": "Hur\u00e1, u\u017e je skoro hotovo!", 
    "You are not online, please check your connection.": "Nie ste online, skontrolujte va\u0161e pripojenie.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Okam\u017eite, ako pr\u00edde nejak\u00fd kamar\u00e1t na pomoc, po\u0161leme v\u00e1m upozornenie.", 
    "just now": "pr\u00e1ve teraz", 
    "x hours ago": "x hod\u00edn nasp\u00e4\u0165", 
    "{n} day ago": [
      "pred {n} d\u0148om", 
      "pred {n} d\u0148ami", 
      "pred {n} d\u0148ami"
    ], 
    "{n} helpful vote": [
      "{n} hlas o u\u017eito\u010dnosti", 
      "{n} hlasy o u\u017eito\u010dnosti", 
      "{n} hlasov o u\u017eito\u010dnosti"
    ], 
    "{n} hour ago": [
      "pred {n} hodinou", 
      "pred {n} hodinami", 
      "pred {n} hodinami"
    ], 
    "{n} minute ago": [
      "pred {n} min\u00fatou", 
      "pred {n} min\u00fatami", 
      "pred {n} min\u00fatami"
    ], 
    "{n} question solved": [
      "{n} hlas o u\u017eito\u010dnosti", 
      "{n} hlasy o u\u017eito\u010dnosti", 
      "{n} hlasov o u\u017eito\u010dnosti"
    ], 
    "{user} chose your answer as a solution": "{user} vybral(a) va\u0161u odpove\u010f ako rie\u0161enie", 
    "{user} left a comment on your question": "{user} okomentoval(a) va\u0161u ot\u00e1zku"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j. F Y G:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j. F Y", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%y-%m-%d", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j. F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d.m.Y G:i:s", 
    "SHORT_DATE_FORMAT": "d.m.Y", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "G:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

