

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> glas za koristno</div>", 
      "<div {countattr}>{n}</div><div {textattr}> glasova za koristno</div>", 
      "<div {countattr}>{n}</div><div {textattr}> glasovi za koristno</div>", 
      "<div {countattr}>{n}</div><div {textattr}> glasov za koristno</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> vpra\u0161anje re\u0161eno</div>", 
      "<div {countattr}>{n}</div><div {textattr}> vpra\u0161anji re\u0161eni</div>", 
      "<div {countattr}>{n}</div><div {textattr}> vpra\u0161anja re\u0161ena</div>", 
      "<div {countattr}>{n}</div><div {textattr}> vpra\u0161anj re\u0161enih</div>"
    ], 
    "A user with that email address already exists.": "Uporabnik s tem e-po\u0161tnim naslovom \u017ee obstaja.", 
    "A user with that username exists": "Uporabnik s tem uporabni\u0161kim imenom obstaja", 
    "All My Questions": "Vsa moja vpra\u0161anja", 
    "Already registered? Sign in": "Ste \u017ee registrirani? Prijavite se", 
    "An account lets you answer questions, track contributions and receive alerts.": "Ra\u010dun vam omogo\u010da odgovarjati na vpra\u0161anja, slediti prispevkom in prejemati opozorila.", 
    "Another helper has answered this question, please choose another.": "Drug pomo\u010dnik je \u017ee odgovoril na to vpra\u0161anje, izberite drugega.", 
    "Answer Questions": "Odgovori na vpra\u0161anja", 
    "Answer a Question": "Odgovori na vpra\u0161anje", 
    "Answer questions": "Odgovori na vpra\u0161anja", 
    "Answered Questions": "Odgovorjena vpra\u0161anja", 
    "Ask a Question": "Vpra\u0161ajte", 
    "Audio/Music/FMRadio": "Zvok/Glasba/FMRadio", 
    "Be aware that you will lose your history when you sign in to your account.": "Zavedajte se, da boste izgubili svojo zgodovino, ko se prijavite v ra\u010dun.", 
    "Browser/Download": "Brskalnik/Prenosi", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp trenutno ne podpira \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Kamera/Galerija/Video", 
    "Can't change this field.": "Tega polja ni mogo\u010de spremeniti.", 
    "Cancel": "Prekli\u010di", 
    "Cancel Sign Up": "Prekli\u010di registracijo", 
    "Cellular Data/WiFi/Bluetooth": "Mobilni podatki/WiFi/Bluetooth", 
    "Choose a category": "Izberite kategorijo", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "S klikom na povezavo v svojem e-po\u0161tnem sporo\u010dilu nam sporo\u010dite, da je prispelo na pravi naslov. Po tem se vrnite v BuddyUp in osre\u010dite druge uporabnike!", 
    "Clock/Alarm": "Ura/Alarm", 
    "Close": "Zapri", 
    "Confirm Account": "Potrdite ra\u010dun", 
    "Continue": "Nadaljuj", 
    "Create Account": "Ustvarite ra\u010dun", 
    "Create account or sign in": "Ustvarite ra\u010dun ali se prijavite", 
    "Device": "Naprava", 
    "Dialer/Contacts": "Klici/Stiki", 
    "Don't have an account? Register": "Nimate ra\u010duna? Registracija", 
    "Done": "Kon\u010dano", 
    "Email Address": "E-po\u0161tni naslov", 
    "Email/Calendar": "E-po\u0161ta/Koledar", 
    "Failed": "Neuspe\u0161no", 
    "Forgot your password?": "Ste pozabili svoje geslo?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Ste pozabili svoje geslo? Brez skrbi. Vnesite svoje uporabni\u0161ko ime in poslali vam bomo navodila, kako ustvariti novega.", 
    "Get a Buddy to help you with your device": "Najdi pomo\u010dnika, da ti pomaga pri tvoji napravi", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Pojdite na nov zavihek, da odgovorite na nekaj vpra\u0161anj. Tu jih bomo bele\u017eili.", 
    "Has your question been solved?": "Je bilo va\u0161e vpra\u0161anje re\u0161eno?", 
    "Have Answers?": "Imate odgovore?", 
    "Have Questions?": "Imate vpra\u0161anja?", 
    "Help Article": "\u010clanek za pomo\u010d", 
    "Help other users around the world": "Pomagajte drugim uporabnikom po svetu", 
    "Incompatible version": "Nezdru\u017eljiva razli\u010dica", 
    "Keyboard": "Tipkovnica", 
    "Language": "Jezik", 
    "Last sync:": "Zadnja sinhronizacija:", 
    "Load more": "Nalo\u017ei ve\u010d", 
    "Maps/GPS": "Zemljevidi/GPS", 
    "Marketplace/Apps Install": "Marketplace/Namestitev aplikacij", 
    "My Profile": "Moj profil", 
    "My Question": "Moje vpra\u0161anje", 
    "My Questions": "Moja vpra\u0161anja", 
    "My list": "Moj seznam", 
    "My preferences": "Moje nastavitve", 
    "New": "Novo", 
    "No active questions": "Ni aktivnih vpra\u0161anj", 
    "No matching user setting found.": "Ni najdenih ujemajo\u010dih se uporabni\u0161kih nastavitev.", 
    "No questions": "Ni vpra\u0161anj", 
    "OK": "V redu", 
    "Ok": "V redu", 
    "Operator": "Operater", 
    "Other": "Drugo", 
    "Password": "Geslo", 
    "Performance": "Zmogljivost", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Svoje vpra\u0161anje zastavite v angle\u0161\u010dini ali pojdite na <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> za ve\u010d pomo\u010di.", 
    "Previously Answered": "Predhodno odgovorjeno", 
    "Quit": "Izhod", 
    "Reset Password": "Ponastavite geslo", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Po\u0161iljanje \u2026", 
    "Settings": "Nastavitve", 
    "Sign In": "Prijava", 
    "Sign in to answer questions from Firefox OS users.": "Prijavite se, \u010de \u017eelite odgovarjati na vpra\u0161anja uporabnikov Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "Prijavite se, \u010de \u017eelite odgovarjati na vpra\u0161anja Mozilline skupnosti.", 
    "Sign in to reply": "Prijavite se, da odgovorite", 
    "Solution \u2713": "Re\u0161itev \u2713", 
    "Storage/SD card": "Shramba/Kartica SD", 
    "Support": "Podpora", 
    "System Updates": "Sistemske posodobitve", 
    "Thank you for your question!": "Hvala za va\u0161e vpra\u0161anje!", 
    "There was a problem with Buddy Up, please try again.": "Pri\u0161lo je do te\u017eave z Buddy Up, poskusite znova.", 
    "This field is required.": "To polje je potrebno izpolniti.", 
    "This solved my question": "To je re\u0161ilo moje vpra\u0161anje", 
    "This will close the question and let your buddy know you no longer need help.": "To bo zaprlo va\u0161e vpra\u0161anje in sporo\u010dilo va\u0161emu pomo\u010dniku, da ne potrebujete ve\u010d pomo\u010di.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Preve\u010d vpra\u0161anj? Uporabite spodnje nastavitve, da skraj\u0161ate seznam \"Odgovori na vpra\u0161anje\".", 
    "Top Helpers this Week": "Najbolj\u0161i pomo\u010dniki ta teden", 
    "Unable to generate username.": "Uporabni\u0161kega imena ni mo\u010d ustvariti.", 
    "Unknown error: \"{error}\"": "Neznana napaka: \"{error}\"", 
    "Unsupported Language": "Nepodprt jezik", 
    "User not found.": "Uporabnika ni mogo\u010de najti.", 
    "Username": "Uporabni\u0161ko ime", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Uporabni\u0161ko ime lahko sestoji samo iz \u010drk, \u0161tevilk, \".\" in \"-\".", 
    "We can help<br>Ask us anything!": "Mi lahko pomagamo<br>Vpra\u0161ajte nas karkoli!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "\u017dal nam je, a aplikacije BuddyUp ne morete namestiti na to razli\u010dico Firefox OS. Zaprite to okno, da se vrnete na svoj doma\u010di zaslon.", 
    "We've sent a welcome email to:": "Za dobrodo\u0161lico smo vam poslali e-po\u0161to na:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Poslali smo vam e-po\u0161to. Sledite povezavi v sporo\u010dilu, da ponastavite geslo.", 
    "Whoops!": "Ups!", 
    "Write your message\u2026": "Napi\u0161ite svoje sporo\u010dilo \u2026", 
    "Yay, you're almost done!": "Juhu, skoraj ste \u017ee nared!", 
    "You are not online, please check your connection.": "Niste povezani s spletom, preverite svojo povezavo.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Obvestilo boste dobili takoj, ko vam pomo\u010dnik prisko\u010di na pomo\u010d.", 
    "just now": "pravkar", 
    "x hours ago": "pred x urami", 
    "{n} day ago": [
      "pred {n} dnevom", 
      "pred {n} dnevoma", 
      "pred {n} dnevi", 
      "pred {n} dnevi"
    ], 
    "{n} helpful vote": [
      "{n} glas za koristno", 
      "{n} glasova za koristno", 
      "{n} glasovi za koristno", 
      "{n} glasov za koristno"
    ], 
    "{n} hour ago": [
      "pred {n} uro", 
      "pred {n} urama", 
      "pred {n} urami", 
      "pred {n} urami"
    ], 
    "{n} minute ago": [
      "pred {n} minuto", 
      "pred {n} minutama", 
      "pred {n} minutami", 
      "pred {n} minutami"
    ], 
    "{n} question solved": [
      "{n} vpra\u0161anje re\u0161eno", 
      "{n} vpra\u0161anji re\u0161eni", 
      "{n} vpra\u0161anja re\u0161ena", 
      "{n} vpra\u0161anj re\u0161enih"
    ], 
    "{user} chose your answer as a solution": "{user} je izbral va\u0161 odgovor za re\u0161itev", 
    "{user} left a comment on your question": "{user} je komentiral va\u0161e vpra\u0161anje"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j. F Y. H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y %H:%M:%S", 
      "%d.%m.%Y %H:%M:%S.%f", 
      "%d.%m.%Y %H:%M", 
      "%d.%m.%Y", 
      "%d.%m.%y %H:%M:%S", 
      "%d.%m.%y %H:%M:%S.%f", 
      "%d.%m.%y %H:%M", 
      "%d.%m.%y", 
      "%d-%m-%Y %H:%M:%S", 
      "%d-%m-%Y %H:%M:%S.%f", 
      "%d-%m-%Y %H:%M", 
      "%d-%m-%Y", 
      "%d. %m. %Y %H:%M:%S", 
      "%d. %m. %Y %H:%M:%S.%f", 
      "%d. %m. %Y %H:%M", 
      "%d. %m. %Y", 
      "%d. %m. %y %H:%M:%S", 
      "%d. %m. %y %H:%M:%S.%f", 
      "%d. %m. %y %H:%M", 
      "%d. %m. %y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "d. F Y", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y", 
      "%d.%m.%y", 
      "%d-%m-%Y", 
      "%d. %m. %Y", 
      "%d. %m. %y", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "j. F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "j.n.Y. H:i", 
    "SHORT_DATE_FORMAT": "j. M. Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

