

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> vot\u00eb dobie</div>", 
      "<div {countattr}>{n}</div><div {textattr}> vota dobie</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> problem i zgjidhur</div>", 
      "<div {countattr}>{n}</div><div {textattr}> probleme t\u00eb zgjidhura</div>"
    ], 
    "All My Questions": "Krejt Pyetjet e Mia", 
    "Already registered? Sign in": "I regjistruar tashm\u00eb? Hyni", 
    "An account lets you answer questions, track contributions and receive alerts.": "Nj\u00eb llogari ju lejon t\u00eb b\u00ebni pyetje, t\u00eb ndiqni kontributet dhe t\u00eb merrni njoftime.", 
    "Another helper has answered this question, please choose another.": "Nj\u00eb tjet\u00ebr p\u00ebrdorues i \u00ebsht\u00eb p\u00ebrgjigjur k\u00ebsaj pyetjeje, ju lutemi, zgjidhni nj\u00eb tjet\u00ebr.", 
    "Answer Questions": "P\u00ebrgjigjiuni Pyetjeve", 
    "Answer a Question": "P\u00ebrgjigjjuni nj\u00eb Pyetjeje", 
    "Answered Questions": "Pyetje Me P\u00ebrgjigje", 
    "Ask a Question": "B\u00ebni nj\u00eb Pyetje", 
    "Audio/Music/FMRadio": "Audio/Muzik\u00eb/FMRadio", 
    "Be aware that you will lose your history when you sign in to your account.": "Kini parasysh se do t\u00eb humbni historikun tuaj, kur t\u00eb hyni n\u00eb llogarin\u00eb tuaj.", 
    "Browser/Download": "Shfletues/Shkarkim", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "H\u00ebp\u00ebrh\u00eb, BuddyUp s\u2019e mbulon gjuh\u00ebn \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Kamer\u00eb/Galeri/Video", 
    "Cancel": "Anuloje", 
    "Cancel Sign Up": "Anuloje Regjistrimin", 
    "Cellular Data/WiFi/Bluetooth": "T\u00eb dh\u00ebna Celulari/WiFi/Bluetooth", 
    "Choose a category": "Zgjidhni nj\u00eb kategori", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Klikoni mbi lidhjen te email-i juaj q\u00eb t\u00eb na b\u00ebni t\u00eb ditur se arriti n\u00eb vendin e duhur. Pas k\u00ebsaj, kthehuni te BuddyUp dhe b\u00ebni t\u00eb g\u00ebzohen edhe p\u00ebrdorues t\u00eb tjer\u00eb!", 
    "Clock/Alarm": "Or\u00eb/Alarm", 
    "Close": "Mbylle", 
    "Confirm Account": "Ripohoni Llogarin\u00eb", 
    "Continue": "Vazhdoni", 
    "Create Account": "Krijoje Llogarin\u00eb", 
    "Create account or sign in": "Krijoni nj\u00eb llogari ose b\u00ebni hyrjen", 
    "Dialer/Contacts": "Thirrje Numrash/Kontakte", 
    "Don't have an account? Register": "S'keni llogari? Regjistrohuni", 
    "Done": "U b\u00eb", 
    "Email/Calendar": "Email/Kalendar", 
    "Failed": "D\u00ebshtoi", 
    "Forgot your password?": "Harruat fjal\u00ebkalimin tuaj?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Harruat fjal\u00ebkalimin tuaj? Mos u shqet\u00ebsoni. Jepni m\u00eb posht\u00eb emrin tuaj t\u00eb p\u00ebrdoruesit dhe do t\u2019ju d\u00ebrgojm\u00eb udh\u00ebzime p\u00ebr caktimin e nj\u00eb t\u00eb riu.", 
    "Get a Buddy to help you with your device": "Merrni ndihm\u00eb rreth pajisjes suaj nga nj\u00eb Shok", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Kaloni te skeda e Re q\u00eb t\u2019i p\u00ebrgjigjeni ndonj\u00eb pyetjeje. Do t\u2019i ndjekim nga k\u00ebtu.", 
    "Has your question been solved?": "U zgjidh pyetja juaj?", 
    "Have Answers?": "Keni P\u00ebrgjigje?", 
    "Have Questions?": "Keni Pyetje?", 
    "Help Article": "Artikull Ndihme", 
    "Help other users around the world": "Ndihmoni p\u00ebrdorues t\u00eb tjer\u00eb anemban\u00eb bot\u00ebs", 
    "Incompatible version": "Version i pap\u00ebrputhsh\u00ebm", 
    "Keyboard": "Tastier\u00eb", 
    "Language": "Gjuh\u00eb", 
    "Last sync:": "Nj\u00ebkoh\u00ebsimi i fundit:", 
    "Load more": "Ngarkoni m\u00eb tep\u00ebr", 
    "Maps/GPS": "Harta/GPS", 
    "Marketplace/Apps Install": "Marketplace/Instalim Aplikacionesh", 
    "My Profile": "Profili Im", 
    "My Question": "Pyetjet e Mia", 
    "My Questions": "Pyetjet e Mia", 
    "My list": "Lista ime", 
    "My preferences": "Parap\u00eblqimet e mia", 
    "New": "E re", 
    "No active questions": "S\u2019ka pyetje aktive", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Other": "Tjet\u00ebr", 
    "Performance": "Suksesshm\u00ebri", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "Ju lutemi, pyetjen tuaj b\u00ebjeni n\u00eb Anglisht, ose kaloni te <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> p\u00ebr m\u00eb tep\u00ebr ndihm\u00eb.", 
    "Previously Answered": "Me P\u00ebrgjigje t\u00eb Dikurshme", 
    "Quit": "Dilni", 
    "Reset Password": "Ricaktoni Fjal\u00ebkalimin", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Po d\u00ebrgohet\u2026", 
    "Settings": "Rregullime", 
    "Sign In": "Hyni", 
    "Sign in to answer questions from Firefox OS users.": "B\u00ebni hyrjen, q\u00eb t\u2019u p\u00ebrgjigjeni pyetjeve nga p\u00ebrdorues t\u00eb Firefox OS-it.", 
    "Sign in to answer questions from the Mozilla community.": "B\u00ebni hyrjen q\u00eb t\u2019iu jepni p\u00ebrgjigje pyetjeve nga bashk\u00ebsia Mozilla.", 
    "Sign in to reply": "Hyni, p\u00ebr t\u2019u p\u00ebrgjigjur", 
    "Solution \u2713": "Zgjidhje \u2713", 
    "Storage/SD card": "Depozitim/Kart\u00eb SD", 
    "Support": "Asistenc\u00eb", 
    "System Updates": "P\u00ebrdit\u00ebsime Sistemi", 
    "Thank you for your question!": "Faleminderit p\u00ebr pyetjen!", 
    "There was a problem with Buddy Up, please try again.": "Pati nj\u00eb problem me Buddy Up, ju lutemi, riprovoni.", 
    "This solved my question": "Kjo e zgjidhi problemin tim", 
    "This will close the question and let your buddy know you no longer need help.": "Kjo do ta mbyll\u00eb pyetjen dhe do t\u2019i b\u00ebj\u00eb t\u00eb ditur shokut tuaj se s\u2019keni m\u00eb nevoj\u00eb p\u00ebr ndihm\u00eb.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Shum\u00eb pyetje? P\u00ebrdorni rregullimet m\u00eb posht\u00eb p\u00ebr ta ngushtuar list\u00ebn \"P\u00ebrgjigjiuni nj\u00eb Pyetjeje\".", 
    "Top Helpers this Week": "Ndihm\u00ebtar\u00ebt Kryesues e k\u00ebsaj Jave", 
    "Unsupported Language": "Gjuh\u00eb t\u00eb Pambuluara", 
    "User not found.": "Nuk u gjet p\u00ebrdorues.", 
    "We can help<br>Ask us anything!": "Mund t\u2019ju ndihmojm\u00eb<br>Pyesni p\u00ebr \u00e7far\u00ebdo!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Na ndjeni, por BuddyUp s\u2019mund t\u00eb instalohet dot n\u00eb versionin tuaj t\u00eb Firefox OS-it. Ju lutemi, mbylleni k\u00ebt\u00eb dritare q\u00eb t\u00eb ktheheni te skena juaj e kreut.", 
    "We've sent a welcome email to:": "Kemi d\u00ebrguar nj\u00eb email mir\u00ebseardhjeje te:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Ju d\u00ebrguam nj\u00eb email. Q\u00eb t\u00eb ricaktoni fjal\u00ebkalimin tuaj, thjesht ndiqni lidhjen te email-i.", 
    "Whoops!": "Ooh!", 
    "Yay, you're almost done!": "Po, thuajse mbaruat!", 
    "You are not online, please check your connection.": "Nuk jeni i lidhur, ju lutemi, kontrolloni lidhjen tuaj.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Do t\u00eb merrni nj\u00eb njoftim sapo nj\u00eb Shok t\u2019ju vij\u00eb n\u00eb ndihm\u00eb.", 
    "x hours ago": "x or\u00eb m\u00eb par\u00eb", 
    "{n} helpful vote": [
      "{n} vot\u00eb dobie", 
      "{n} vota dobie"
    ], 
    "{n} question solved": [
      "{n} problem i zgjidhur", 
      "{n} probleme t\u00eb zgjidhura"
    ], 
    "{user} chose your answer as a solution": "{user} zgjodhi p\u00ebrgjigjen tuaj si zgjidhje", 
    "{user} left a comment on your question": "{user} la nj\u00eb koment lidhur me pyetjen tuaj"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "N j, Y, P", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "d F Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y", 
      "%b %d %Y", 
      "%b %d, %Y", 
      "%d %b %Y", 
      "%d %b, %Y", 
      "%B %d %Y", 
      "%B %d, %Y", 
      "%d %B %Y", 
      "%d %B, %Y"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "0", 
    "SHORT_DATETIME_FORMAT": "m/d/Y P", 
    "SHORT_DATE_FORMAT": "Y-m-d", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "g.i.s.A", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

