

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u043a\u043e\u0440\u0438\u0441\u0430\u043d \u0433\u043b\u0430\u0441</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043a\u043e\u0440\u0438\u0441\u043d\u0430 \u0433\u043b\u0430\u0441\u0430</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0445 \u0433\u043b\u0430\u0441\u043e\u0432\u0430</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u043f\u0438\u0442\u0430\u045a\u0435 \u0440\u0435\u0448\u0435\u043d\u043e</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043f\u0438\u0442\u0430\u045a\u0430 \u0440\u0435\u0448\u0435\u043d\u0430</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043f\u0438\u0442\u0430\u045a\u0430 \u0440\u0435\u0448\u0435\u043d\u0430</div>"
    ], 
    "A user with that email address already exists.": "\u041a\u043e\u0440\u0438\u0441\u043d\u0438\u043a \u0441\u0430 \u043d\u0430\u0432\u0435\u0434\u0435\u043d\u043e\u043c \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u0435-\u043f\u043e\u0448\u0442\u0435 \u0432\u0435\u045b \u043f\u043e\u0441\u0442\u043e\u0458\u0438.", 
    "A user with that username exists": "\u041a\u043e\u0440\u0438\u0441\u043d\u0438\u043a \u0441\u0430 \u043d\u0430\u0432\u0435\u0434\u0435\u043d\u0438\u043c \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0447\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u043e\u043c \u0432\u0435\u045b \u043f\u043e\u0441\u0442\u043e\u0458\u0438", 
    "All My Questions": "\u0421\u0432\u0430 \u043c\u043e\u0458\u0430 \u043f\u0438\u0442\u0430\u045a\u0430", 
    "Already registered? Sign in": "\u0412\u0435\u045b \u0441\u0442\u0435 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432\u0430\u043d\u0438? \u041f\u0440\u0438\u0458\u0430\u0432\u0438\u0442\u0435 \u0441\u0435", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u041d\u0430\u043b\u043e\u0433 \u0432\u0430\u043c \u043e\u043c\u043e\u0433\u0443\u045b\u0430\u0432\u0430 \u0434\u0430 \u043e\u0434\u0433\u043e\u0432\u0430\u0440\u0430\u0442\u0435 \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0430, \u043f\u0440\u0430\u0442\u0438\u0442\u0435 \u0434\u043e\u043f\u0440\u0438\u043d\u043e\u0441\u0435 \u0438 \u043f\u0440\u0438\u043c\u0430\u0442\u0435 \u043e\u0431\u0430\u0432\u0435\u0448\u0442\u0435\u045a\u0430.", 
    "Another helper has answered this question, please choose another.": "\u0414\u0440\u0443\u0433\u0438 \u0430\u0441\u0438\u0441\u0442\u0435\u043d\u0442 \u0458\u0435 \u043e\u0434\u0433\u043e\u0432\u043e\u0440\u0438\u043e \u043d\u0430 \u043e\u0432\u043e \u043f\u0438\u0442\u0430\u045a\u0435, \u0438\u0437\u0430\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e \u043f\u0438\u0442\u0430\u045a\u0435.", 
    "Answer Questions": "\u041e\u0434\u0433\u043e\u0432\u043e\u0440\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0435", 
    "Answer a Question": "\u041e\u0434\u0433\u043e\u0432\u043e\u0440\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0435", 
    "Answer questions": "\u041e\u0434\u0433\u043e\u0432\u043e\u0440\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0435", 
    "Answered Questions": "\u041e\u0434\u0433\u043e\u0432\u043e\u0440\u0435\u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0430", 
    "Ask a Question": "\u041f\u043e\u0441\u0442\u0430\u0432\u0438 \u043f\u0438\u0442\u0430\u045a\u0435", 
    "Audio/Music/FMRadio": "\u0410\u0443\u0434\u0438\u043e/\u041c\u0443\u0437\u0438\u043a\u0430/FM\u0420\u0430\u0434\u0438\u043e", 
    "Be aware that you will lose your history when you sign in to your account.": "\u0418\u043c\u0430\u0458\u0442\u0435 \u0443 \u0432\u0438\u0434\u0443 \u0434\u0430 \u045b\u0435\u0442\u0435 \u0438\u0437\u0433\u0443\u0431\u0438\u0442\u0438 \u0438\u0441\u0442\u043e\u0440\u0438\u0458\u0430\u0442 \u043a\u0430\u0434\u0430 \u0441\u0435 \u043f\u0440\u0438\u0458\u0430\u0432\u0438\u0442\u0435.", 
    "Browser/Download": "\u041f\u0440\u0435\u0433\u043b\u0435\u0434\u0430\u0447/\u041f\u0440\u0435\u0443\u0437\u0438\u043c\u0430\u045a\u0430", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp \u0442\u0440\u0435\u043d\u0443\u0442\u043d\u043e \u043d\u0435 \u043f\u043e\u0434\u0440\u0436\u0430\u0432\u0430 \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "\u041a\u0430\u043c\u0435\u0440\u0430/\u0413\u0430\u043b\u0435\u0440\u0438\u0458\u0430/\u0412\u0438\u0434\u0435\u043e", 
    "Can't change this field.": "\u041d\u0435 \u043c\u043e\u0433\u0443 \u0434\u0430 \u043f\u0440\u043e\u043c\u0435\u043d\u0438\u043c \u043e\u0432\u043e \u043f\u043e\u0459\u0435.", 
    "Cancel": "\u041e\u0442\u043a\u0430\u0436\u0438", 
    "Cancel Sign Up": "\u041e\u0442\u043a\u0430\u0436\u0438 \u043f\u0440\u0438\u0458\u0430\u0432\u0443", 
    "Cellular Data/WiFi/Bluetooth": "\u041c\u043e\u0431\u0438\u043b\u043d\u0438 \u043f\u043e\u0434\u0430\u0446\u0438/WiFi/Bluetooth", 
    "Choose a category": "\u0418\u0437\u0430\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0458\u0443", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "\u041a\u043b\u0438\u043a\u043d\u0438\u0442\u0435 \u043d\u0430 \u0432\u0435\u0437\u0443 \u0443 \u0435-\u043f\u043e\u0448\u0442\u0438 \u0434\u0430 \u043d\u0430\u043c \u043a\u0430\u0436\u0435\u0442\u0435 \u0434\u0430 \u0441\u0442\u0435 \u0441\u0442\u0438\u0433\u043b\u0438 \u0434\u043e \u043f\u0440\u0430\u0432\u043e\u0433 \u043c\u0435\u0441\u0442\u0430. \u041d\u0430\u043a\u043e\u043d \u0442\u043e\u0433\u0430 \u0441\u0435 \u0432\u0440\u0430\u0442\u0438\u0442\u0435 \u043d\u0430 BuddyUp \u0438 \u0443\u0447\u0438\u043d\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u0435 \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u043a\u0435 \u0441\u0440\u0435\u0442\u043d\u0438\u043c!", 
    "Clock/Alarm": "\u0421\u0430\u0442/\u0411\u0443\u0434\u0438\u043b\u043d\u0438\u043a", 
    "Close": "\u0417\u0430\u0442\u0432\u043e\u0440\u0438", 
    "Confirm Account": "\u041f\u043e\u0442\u0432\u0440\u0434\u0438 \u043d\u0430\u043b\u043e\u0433", 
    "Continue": "\u041d\u0430\u0441\u0442\u0430\u0432\u0438", 
    "Create Account": "\u041d\u0430\u043f\u0440\u0430\u0432\u0438 \u043d\u0430\u043b\u043e\u0433", 
    "Create account or sign in": "\u041d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u0435 \u043d\u0430\u043b\u043e\u0433 \u0438\u043b\u0438 \u0441\u0435 \u043f\u0440\u0438\u0458\u0430\u0432\u0438\u0442\u0435", 
    "Device": "\u0423\u0440\u0435\u0452\u0430\u0458", 
    "Dialer/Contacts": "\u0422\u0435\u043b\u0435\u0444\u043e\u043d/\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0438", 
    "Don't have an account? Register": "\u041d\u0435\u043c\u0430\u0442\u0435 \u043d\u0430\u043b\u043e\u0433? \u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0443\u0458\u0442\u0435 \u0441\u0435", 
    "Done": "\u0413\u043e\u0442\u043e\u0432\u043e", 
    "Email Address": "\u0410\u0434\u0440\u0435\u0441\u0430 \u0435-\u043f\u043e\u0448\u0442\u0435", 
    "Email/Calendar": "\u0415-\u043f\u043e\u0448\u0442\u0430/\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440", 
    "Enter a valid email address.": "\u0423\u043d\u0435\u0441\u0438\u0442\u0435 \u0438\u0441\u043f\u0440\u0430\u0432\u043d\u0443 \u0430\u0434\u0440\u0435\u0441\u0443 \u0435-\u043f\u043e\u0448\u0442\u0435.", 
    "Failed": "\u041d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e", 
    "Forgot your password?": "\u0417\u0430\u0431\u043e\u0440\u0430\u0432\u0438\u043b\u0438 \u0441\u0442\u0435 \u043b\u043e\u0437\u0438\u043d\u043a\u0443?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "\u0417\u0430\u0431\u043e\u0440\u0430\u0432\u0438\u043b\u0438 \u0441\u0442\u0435 \u043b\u043e\u0437\u0438\u043d\u043a\u0443? \u041d\u0435 \u0431\u0440\u0438\u043d\u0438\u0442\u0435. \u0423\u043d\u0435\u0441\u0438\u0442\u0435 \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0447\u043a\u043e \u0438\u043c\u0435 \u0438\u0441\u043f\u043e\u0434 \u0438 \u043c\u0438 \u045b\u0435\u043c\u043e \u0432\u0430\u043c \u043f\u043e\u0441\u043b\u0430\u0442\u0438 \u0438\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0458\u0435 \u0437\u0430 \u043f\u043e\u0434\u0435\u0448\u0430\u0432\u0430\u045a\u0435 \u043d\u043e\u0432\u0435.", 
    "Get a Buddy to help you with your device": "\u041d\u0430\u0452\u0438\u0442\u0435 \u043f\u0440\u0438\u0458\u0430\u0442\u0435\u045a\u0430 \u043a\u043e\u0458\u0438 \u045b\u0435 \u0432\u0430\u043c \u043f\u043e\u043c\u043e\u045b\u0438 \u043e\u043a\u043e \u0432\u0430\u0448\u0435\u0433 \u0443\u0440\u0435\u0452\u0430\u0458\u0430", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\u0418\u0434\u0438\u0442\u0435 \u043d\u0430 \u043d\u043e\u0432\u0438 \u0458\u0435\u0437\u0438\u0447\u0430\u043a \u0434\u0430 \u043e\u0434\u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0435 \u043d\u0430 \u043d\u0435\u043a\u0430 \u043f\u0438\u0442\u0430\u045a\u0430. \u041f\u0440\u0430\u0442\u0438\u045b\u0435\u043c\u043e \u0438\u0445 \u043e\u0432\u0434\u0435.", 
    "Has your question been solved?": "\u0414\u0430 \u043b\u0438 \u0458\u0435 \u0432\u0430\u0448 \u043f\u0440\u043e\u0431\u043b\u0435\u043c \u0440\u0435\u0448\u0435\u043d?", 
    "Have Answers?": "\u0418\u043c\u0430\u0442\u0435 \u043f\u0438\u0442\u0430\u045a\u0430?", 
    "Have Questions?": "\u0418\u043c\u0430\u0442\u0435 \u043f\u0438\u0442\u0430\u045a\u0430?", 
    "Help Article": "\u0427\u043b\u0430\u043d\u0430\u043a \u043f\u043e\u0434\u0440\u0448\u043a\u0435", 
    "Help other users around the world": "\u041f\u043e\u043c\u043e\u0437\u0438\u0442\u0435 \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0446\u0438\u043c\u0430 \u0438\u0437 \u0446\u0435\u043b\u043e\u0433 \u0441\u0432\u0435\u0442\u0430", 
    "Incompatible version": "\u041d\u0435\u043a\u043e\u043c\u043f\u0430\u0442\u0430\u0431\u0438\u043b\u043d\u0430 \u0432\u0435\u0440\u0437\u0438\u0458\u0430", 
    "Keyboard": "\u0422\u0430\u0441\u0442\u0430\u0442\u0443\u0440\u0430", 
    "Language": "\u0408\u0435\u0437\u0438\u043a", 
    "Last sync:": "\u041f\u043e\u0441\u043b\u0435\u0434\u045a\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0458\u0430:", 
    "Load more": "\u0423\u0447\u0438\u0442\u0430\u0458 \u0432\u0438\u0448\u0435", 
    "Maps/GPS": "\u041c\u0430\u043f\u0435/GPS", 
    "Marketplace/Apps Install": "Marketplace/\u0418\u043d\u0441\u0442\u0430\u043b\u0430\u0446\u0438\u0458\u0430 \u0430\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0458\u0430", 
    "My Profile": "\u041c\u043e\u0458 \u043f\u0440\u043e\u0444\u0438\u043b", 
    "My Question": "\u041c\u043e\u0458\u0435 \u043f\u0438\u0442\u0430\u045a\u0435", 
    "My Questions": "\u041c\u043e\u0458\u0430 \u043f\u0438\u0442\u0430\u045a\u0430", 
    "My list": "\u041c\u043e\u0458\u0430 \u043b\u0438\u0441\u0442\u0430", 
    "My preferences": "\u041c\u043e\u0458\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0435", 
    "New": "\u041d\u043e\u0432\u043e", 
    "No active questions": "\u041d\u0435\u043c\u0430 \u0430\u043a\u0442\u0438\u0432\u043d\u0438\u0445 \u043f\u0438\u0442\u0430\u045a\u0430", 
    "No matching user setting found.": "\u041d\u0438\u0441\u0443 \u043f\u0440\u043e\u043d\u0430\u0452\u0435\u043d\u0435 \u043f\u043e\u0434\u0443\u0434\u0430\u0440\u0430\u0458\u0443\u045b\u0435 \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0447\u043a\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0435.", 
    "No questions": "\u041d\u0435\u043c\u0430 \u043f\u0438\u0442\u0430\u045a\u0430", 
    "OK": "\u0423 \u0440\u0435\u0434\u0443", 
    "Ok": "\u0423 \u0440\u0435\u0434\u0443", 
    "Operator": "\u041e\u043f\u0435\u0440\u0430\u0442\u0435\u0440", 
    "Other": "\u041e\u0441\u0442\u0430\u043b\u043e", 
    "Password": "\u041b\u043e\u0437\u0438\u043d\u043a\u0430", 
    "Performance": "\u041f\u0435\u0440\u0444\u043e\u0440\u043c\u0430\u043d\u0441\u0435", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "\u041c\u043e\u043b\u0438\u043c\u043e \u0432\u0430\u0441 \u043f\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u0435 \u043f\u0438\u0442\u0430\u045a\u0435 \u043d\u0430 \u0435\u043d\u0433\u043b\u0435\u0441\u043a\u043e\u043c, \u0438\u043b\u0438 \u0438\u0434\u0438\u0442\u0435 \u043d\u0430 <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> \u0437\u0430 \u0432\u0438\u0448\u0435 \u043f\u043e\u043c\u043e\u045b\u0438.", 
    "Previously Answered": "\u041f\u0440\u0435\u0442\u0445\u043e\u0434\u043d\u043e \u043e\u0434\u0433\u043e\u0432\u043e\u0440\u0435\u043d\u043e", 
    "Quit": "\u0418\u0437\u0430\u0452\u0438", 
    "Reset Password": "\u0420\u0435\u0441\u0435\u0442\u0443\u0458 \u043b\u043e\u0437\u0438\u043d\u043a\u0443", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "\u0428\u0430\u0459\u0435\u043c\u2026", 
    "Settings": "\u041f\u043e\u0441\u0442\u0430\u0432\u043a\u0435", 
    "Sign In": "\u041f\u0440\u0438\u0458\u0430\u0432\u0438 \u0441\u0435", 
    "Sign in to answer questions from Firefox OS users.": "\u041f\u0440\u0438\u0458\u0430\u0432\u0438\u0442\u0435 \u0441\u0435 \u0434\u0430 \u0431\u0438\u0441\u0442\u0435 \u043e\u0434\u0433\u043e\u0432\u043e\u0440\u0438\u043b\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0430 Firefox OS \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u043a\u0430.", 
    "Sign in to answer questions from the Mozilla community.": "\u041f\u0440\u0438\u0458\u0430\u0432\u0438\u0442\u0435 \u0441\u0435 \u0434\u0430 \u043e\u0434\u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0435 \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0430 \u043e\u0434 Mozilla \u0437\u0430\u0458\u0435\u0434\u0438\u043d\u0438\u0446\u0435.", 
    "Sign in to reply": "\u041f\u0440\u0438\u0458\u0430\u0432\u0438\u0442\u0435 \u0441\u0435 \u0434\u0430 \u0431\u0438\u0441\u0442\u0435 \u043e\u0434\u0433\u043e\u0432\u043e\u0440\u0438\u043b\u0438", 
    "Solution \u2713": "\u0420\u0435\u0448\u0435\u045a\u0435 \u2713", 
    "Storage/SD card": "\u0421\u043a\u043b\u0430\u0434\u0438\u0448\u0442\u0435/SD \u043a\u0430\u0440\u0442\u0438\u0446\u0430", 
    "Support": "\u041f\u043e\u0434\u0440\u0448\u043a\u0430", 
    "System Updates": "\u041d\u0430\u0434\u043e\u0433\u0440\u0430\u0434\u045a\u0435", 
    "Thank you for your question!": "\u0425\u0432\u0430\u043b\u0430 \u0432\u0430\u043c \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0443!", 
    "There was a problem with Buddy Up, please try again.": "\u0414\u043e\u0448\u043b\u043e \u0458\u0435 \u0434\u043e \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441\u0430 Buddy Up, \u043f\u043e\u043a\u0443\u0448\u0430\u0458\u0442\u0435 \u043f\u043e\u043d\u043e\u0432\u043e \u043a\u0430\u0441\u043d\u0438\u0458\u0435.", 
    "This field is required.": "\u041e\u0432\u043e \u043f\u043e\u0459\u0435 \u0458\u0435 \u043f\u043e\u0442\u0440\u0435\u0431\u043d\u043e.", 
    "This solved my question": "\u041e\u0432\u043e \u0458\u0435 \u0440\u0435\u0448\u0438\u043b\u043e \u043c\u043e\u0458 \u043f\u0440\u043e\u0431\u043b\u0435\u043c", 
    "This will close the question and let your buddy know you no longer need help.": "\u041e\u0432\u043e \u045b\u0435 \u0437\u0430\u0442\u0432\u043e\u0440\u0438\u0442\u0438 \u043f\u0438\u0442\u0430\u045a\u0435 \u0438 \u043e\u0431\u0430\u0432\u0435\u0441\u0442\u0438\u045b\u0435 \u043f\u0440\u0438\u0458\u0430\u0442\u0435\u0459\u0430 \u0434\u0430 \u0432\u0430\u043c \u0432\u0438\u0448\u0435 \u043d\u0438\u0458\u0435 \u043f\u043e\u0442\u0440\u0435\u0431\u043d\u0430 \u045a\u0435\u0433\u043e\u0432\u0430 \u043f\u043e\u043c\u043e\u045b.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\u041f\u0440\u0435\u0432\u0438\u0448\u0435 \u043f\u0438\u0442\u0430\u045a\u0430? \u041a\u043e\u0440\u0438\u0441\u0442\u0438\u0442\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u043a\u0435 \u0438\u0441\u043f\u043e\u0434 \u0434\u0430 \u0441\u043c\u0430\u045a\u0438\u0442\u0435 \"\u041e\u0434\u0433\u043e\u0432\u043e\u0440\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u045a\u0435\" \u043b\u0438\u0441\u0442\u0443.", 
    "Top Helpers this Week": "\u041d\u0430\u0458\u0431\u043e\u0459\u0438 \u043e\u0432\u043e\u043d\u0435\u0434\u0435\u0459\u043d\u0438 \u0430\u0441\u0438\u0441\u0442\u0435\u043d\u0442\u0438", 
    "Unable to generate username.": "\u041d\u0435 \u043c\u043e\u0433\u0443 \u0434\u0430 \u0433\u0435\u043d\u0435\u0440\u0438\u0448\u0435\u043c \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0447\u043a\u043e \u0438\u043c\u0435.", 
    "Unable to log in with provided credentials.": "\u041d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u0430 \u043f\u0440\u0438\u0458\u0430\u0432\u0430 \u0441\u0430 \u043d\u0430\u0432\u0435\u0434\u0435\u043d\u0438\u043c \u0430\u043a\u0440\u0435\u0434\u0438\u0442\u0438\u0432\u0438\u043c\u0430.", 
    "Unknown error: \"{error}\"": "\u041d\u0435\u043f\u043e\u0437\u043d\u0430\u0442\u0430 \u0433\u0440\u0435\u0448\u043a\u0430: \"{error}\"", 
    "Unsupported Language": "\u041d\u0435\u043f\u043e\u0434\u0440\u0436\u0430\u043d \u0458\u0435\u0437\u0438\u043a", 
    "User account is disabled.": "\u041d\u0430\u043b\u043e\u0433 \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u043a\u0430 \u0458\u0435 \u043e\u043d\u0435\u043c\u043e\u0433\u0443\u045b\u0435\u043d.", 
    "User not found.": "\u041a\u043e\u0440\u0438\u0441\u043d\u0438\u043a \u043d\u0438\u0458\u0435 \u043f\u0440\u043e\u043d\u0430\u0452\u0435\u043d.", 
    "Username": "\u041a\u043e\u0440\u0438\u0441\u043d\u0438\u0447\u043a\u043e \u0438\u043c\u0435", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "\u041a\u043e\u0440\u0438\u0441\u043d\u0438\u0447\u043a\u043e \u0438\u043c\u0435 \u043c\u043e\u0436\u0435 \u0434\u0430 \u0441\u0430\u0434\u0440\u0436\u0438 \u0441\u0430\u043c\u043e \u0441\u043b\u043e\u0432\u0430, \u0431\u0440\u043e\u0458\u0435\u0432\u0435, \".\" \u0438 \"-\".", 
    "We can help<br>Ask us anything!": "\u041c\u043e\u0436\u0435\u043c\u043e \u043f\u043e\u043c\u043e\u045b\u0438 <br>\u041f\u0438\u0442\u0430\u0458\u0442\u0435 \u043d\u0430\u0441 \u0431\u0438\u043b\u043e \u0448\u0442\u0430!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "\u0416\u0430\u043e \u043d\u0430\u043c \u0458\u0435, \u0430\u043b\u0438 BuddyUp \u043d\u0435 \u043c\u043e\u0436\u0435 \u0434\u0430 \u0431\u0443\u0434\u0435 \u0438\u043d\u0441\u0442\u0430\u043b\u0438\u0440\u0430\u043d \u043d\u0430 \u043e\u0432\u043e\u0458 Firefox OS \u0432\u0435\u0440\u0437\u0438\u0458\u0438. \u0417\u0430\u0442\u0432\u043e\u0440\u0438\u0442\u0435 \u043e\u0432\u0430\u0458 \u043f\u0440\u043e\u0437\u043e\u0440 \u0438 \u0432\u0440\u0430\u0442\u0438\u0442\u0435 \u0441\u0435 \u043d\u0430 \u043f\u043e\u0447\u0435\u0442\u043d\u0438 \u0435\u043a\u0440\u0430\u043d.", 
    "We've sent a welcome email to:": "\u041f\u043e\u0441\u043b\u0430\u043b\u0438 \u0441\u043c\u043e \u0435-\u043f\u043e\u0448\u0442\u0443 \u0437\u0430 \u0434\u043e\u0431\u0440\u043e\u0434\u043e\u0448\u043b\u0438\u0446\u0443 \u043d\u0430:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "\u041f\u043e\u0441\u043b\u0430\u043b\u0438 \u0441\u043c\u043e \u0432\u0430\u043c \u0435-\u043f\u043e\u0448\u0442\u0443. \u0421\u0430\u043c\u043e \u043f\u0440\u0430\u0442\u0438\u0442\u0435 \u0432\u0435\u0437\u0443 \u0438\u0441\u043f\u043e\u0434 \u0434\u0430 \u0440\u0435\u0441\u0435\u0442\u0443\u0458\u0435\u0442\u0435 \u043b\u043e\u0437\u0438\u043d\u043a\u0443.", 
    "Whoops!": "\u0423\u043f\u0441!", 
    "Write your message\u2026": "\u041d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u043f\u043e\u0440\u0443\u043a\u0443\u2026", 
    "Yay, you're almost done!": "\u0421\u043a\u043e\u0440\u043e \u043f\u0430 \u0433\u043e\u0442\u043e\u0432\u043e!", 
    "You are not online, please check your connection.": "\u041d\u0438\u0441\u0442\u0435 \u043d\u0430 \u0432\u0435\u0437\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0435\u043a\u0446\u0438\u0458\u0443.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "\u0414\u043e\u0431\u0438\u045b\u0435\u0442\u0435 \u043e\u0431\u0430\u0432\u0435\u0448\u0442\u0435\u045a\u0435 \u0447\u0438\u043c \u043f\u0440\u0438\u0458\u0430\u0442\u0435\u0459 \u0434\u043e\u0452\u0435 \u0434\u0430 \u0432\u0430\u0441 \u0441\u043f\u0430\u0441\u0438.", 
    "just now": "\u0443\u043f\u0440\u0430\u0432\u043e", 
    "x hours ago": "\u043f\u0440\u0435 x \u0441\u0430\u0442\u0430", 
    "{n} day ago": [
      "\u043f\u0440\u0435 {n} \u0434\u0430\u043d", 
      "\u043f\u0440\u0435 {n} \u0434\u0430\u043d\u0430", 
      "\u043f\u0440\u0435 {n} \u0434\u0430\u043d\u0430"
    ], 
    "{n} helpful vote": [
      "{n} \u043a\u043e\u0440\u0438\u0441\u0430\u043d \u0433\u043b\u0430\u0441", 
      "{n} \u043a\u043e\u0440\u0438\u0441\u043d\u0430 \u0433\u043b\u0430\u0441\u0430", 
      "{n} \u043a\u043e\u0440\u0438\u0441\u0438\u0445 \u0433\u043b\u0430\u0441\u043e\u0432\u0430"
    ], 
    "{n} hour ago": [
      "\u043f\u0440\u0435 {n} \u0441\u0430\u0442", 
      "\u043f\u0440\u0435 {n} \u0441\u0430\u0442\u0430", 
      "\u043f\u0440\u0435 {n} \u0441\u0430\u0442\u0430"
    ], 
    "{n} minute ago": [
      "\u043f\u0440\u0435 {n} \u043c\u0438\u043d\u0443\u0442", 
      "\u043f\u0440\u0435 {n} \u043c\u0438\u043d\u0443\u0442\u0430", 
      "\u043f\u0440\u0435 {n} \u043c\u0438\u043d\u0443\u0442\u0430"
    ], 
    "{n} question solved": [
      "{n} \u043f\u0438\u0442\u0430\u045a\u0435 \u0440\u0435\u0448\u0435\u043d\u043e", 
      "{n} \u043f\u0438\u0442\u0430\u045a\u0430 \u0440\u0435\u0448\u0435\u043d\u0430", 
      "{n} \u043f\u0438\u0442\u0430\u045a\u0430 \u0440\u0435\u0448\u0435\u043d\u0430"
    ], 
    "{user} chose your answer as a solution": "{user} \u0458\u0435 \u043e\u0434\u0430\u0431\u0440\u0430\u043e \u0432\u0430\u0448 \u043e\u0434\u0433\u043e\u0432\u043e\u0440 \u043a\u0430\u043e \u0440\u0435\u0448\u0435\u045a\u0435", 
    "{user} left a comment on your question": "{user} \u0458\u0435 \u043e\u0441\u0442\u0430\u0432\u0438\u043e \u043a\u043e\u043c\u0435\u043d\u0442\u0430\u0440 \u043d\u0430 \u0432\u0430\u0448\u0435\u043c \u043f\u0438\u0442\u0430\u045a\u0443"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j. F Y. H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%d.%m.%Y. %H:%M:%S", 
      "%d.%m.%Y. %H:%M:%S.%f", 
      "%d.%m.%Y. %H:%M", 
      "%d.%m.%Y.", 
      "%d.%m.%y. %H:%M:%S", 
      "%d.%m.%y. %H:%M:%S.%f", 
      "%d.%m.%y. %H:%M", 
      "%d.%m.%y.", 
      "%d. %m. %Y. %H:%M:%S", 
      "%d. %m. %Y. %H:%M:%S.%f", 
      "%d. %m. %Y. %H:%M", 
      "%d. %m. %Y.", 
      "%d. %m. %y. %H:%M:%S", 
      "%d. %m. %y. %H:%M:%S.%f", 
      "%d. %m. %y. %H:%M", 
      "%d. %m. %y.", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "j. F Y.", 
    "DATE_INPUT_FORMATS": [
      "%d.%m.%Y.", 
      "%d.%m.%y.", 
      "%d. %m. %Y.", 
      "%d. %m. %y.", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j. F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "j.m.Y. H:i", 
    "SHORT_DATE_FORMAT": "j.m.Y.", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y."
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

