

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> hj\u00e4lpsam r\u00f6st</div>", 
      "<div {countattr}>{n}</div><div {textattr}> hj\u00e4lpsamma r\u00f6ster</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> fr\u00e5ga l\u00f6st</div>", 
      "<div {countattr}>{n}</div><div {textattr}> fr\u00e5gor l\u00f6sta</div>"
    ], 
    "A user with that email address already exists.": "En anv\u00e4ndare med den e-postadressen finns redan.", 
    "A user with that username exists": "En anv\u00e4ndare med det anv\u00e4ndarnamnet finns redan", 
    "All My Questions": "Alla mina fr\u00e5gor", 
    "Already registered? Sign in": "Redan registrerad? Logga in", 
    "An account lets you answer questions, track contributions and receive alerts.": "Med ett konto kan du svara p\u00e5 fr\u00e5gor, sp\u00e5ra bidrag och f\u00e5 aviseringar.", 
    "Another helper has answered this question, please choose another.": "En annan hj\u00e4lpare har besvarat denna fr\u00e5ga, v\u00e4nligen v\u00e4lj ett annan.", 
    "Answer Questions": "Besvara fr\u00e5gor", 
    "Answer a Question": "Svara p\u00e5 en fr\u00e5ga", 
    "Answer questions": "Besvara fr\u00e5gor", 
    "Answered Questions": "Besvarade fr\u00e5gor", 
    "Ask a Question": "St\u00e4ll en fr\u00e5ga", 
    "Audio/Music/FMRadio": "Ljud/Musik/FMRadio", 
    "Be aware that you will lose your history when you sign in to your account.": "T\u00e4nk p\u00e5 att du kommer att f\u00f6rlora din historik n\u00e4r du loggar in p\u00e5 ditt konto.", 
    "Browser/Download": "Webbl\u00e4sare/Nedladdning", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp st\u00f6der inte f\u00f6r tillf\u00e4llet \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "Kamera/Galleri/Video", 
    "Can't change this field.": "Kan inte \u00e4ndra f\u00e4ltet.", 
    "Cancel": "Avbryt", 
    "Cancel Sign Up": "Avbryt inloggning", 
    "Cellular Data/WiFi/Bluetooth": "Mobildata/WiFi/Bluetooth", 
    "Choose a category": "V\u00e4lj en kategori", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "Klicka p\u00e5 l\u00e4nken i e-post f\u00f6r att visa att du har kommit till r\u00e4tt plats. Efter det, \u00e5terv\u00e4nd till BuddyUp och g\u00f6r andra anv\u00e4ndare glada!", 
    "Clock/Alarm": "Klocka/Alarm", 
    "Close": "St\u00e4ng", 
    "Confirm Account": "Bekr\u00e4fta konto", 
    "Continue": "Forts\u00e4tt", 
    "Create Account": "Skapa konto", 
    "Create account or sign in": "Skapa konto eller logga in", 
    "Device": "Enhet", 
    "Dialer/Contacts": "Ringa/Kontakter", 
    "Don't have an account? Register": "Har du inte ett konto? Registrera dig", 
    "Done": "Klar", 
    "Email Address": "E-postadress", 
    "Email/Calendar": "E-post/Kalender", 
    "Enter a valid email address.": "Ange en giltig e-postadress.", 
    "Failed": "Misslyckades", 
    "Forgot your password?": "Gl\u00f6mt ditt l\u00f6senord?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "Gl\u00f6mt ditt l\u00f6senord? Oroa dig inte. Ange ditt anv\u00e4ndarnamn nedan s\u00e5 skickar vi instruktioner om hur du g\u00f6r f\u00f6r att skapa ett nytt.", 
    "Get a Buddy to help you with your device": "F\u00e5 en Buddy att hj\u00e4lpa dig med din enhet", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "G\u00e5 till ny flik f\u00f6r att svara p\u00e5 n\u00e5gra fr\u00e5gor. Vi kommer att f\u00f6lja dem h\u00e4r.", 
    "Has your question been solved?": "Har din fr\u00e5ga l\u00f6sts?", 
    "Have Answers?": "Har du svar?", 
    "Have Questions?": "Har du fr\u00e5gor?", 
    "Help Article": "Hj\u00e4lpartikel", 
    "Help other users around the world": "Hj\u00e4lp andra anv\u00e4ndare runt om i v\u00e4rlden", 
    "Incompatible version": "Inkompatibel version", 
    "Keyboard": "Tangentbord", 
    "Language": "Spr\u00e5k", 
    "Last sync:": "Senaste synk:", 
    "Load more": "L\u00e4s in mer", 
    "Maps/GPS": "Kartor/GPS", 
    "Marketplace/Apps Install": "Marketplace/Installera appar", 
    "My Profile": "Min profil", 
    "My Question": "Min fr\u00e5ga", 
    "My Questions": "Mina fr\u00e5gor", 
    "My list": "Min lista", 
    "My preferences": "Mina inst\u00e4llningar", 
    "New": "Nya", 
    "No active questions": "Inga aktiva fr\u00e5gor", 
    "No matching user setting found.": "Ingen matchande anv\u00e4ndarinst\u00e4llning hittades.", 
    "No questions": "Inga fr\u00e5gor", 
    "OK": "Ok", 
    "Ok": "Ok", 
    "Operator": "Operat\u00f6r", 
    "Other": "Annat", 
    "Password": "L\u00f6senord", 
    "Performance": "Prestanda", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "St\u00e4ll dina fr\u00e5gor p\u00e5 engelska, eller g\u00e5 till <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> f\u00f6r mer hj\u00e4lp.", 
    "Previously Answered": "Tidigare besvarad", 
    "Quit": "Avsluta", 
    "Reset Password": "\u00c5terst\u00e4ll l\u00f6senord", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Skickar\u2026", 
    "Settings": "Inst\u00e4llningar", 
    "Sign In": "Logga in", 
    "Sign in to answer questions from Firefox OS users.": "Logga in f\u00f6r att svara p\u00e5 fr\u00e5gor fr\u00e5n Firefox OS anv\u00e4ndare.", 
    "Sign in to answer questions from the Mozilla community.": "Logga in f\u00f6r att svara p\u00e5 fr\u00e5gor fr\u00e5n Mozilla's gemenskap.", 
    "Sign in to reply": "Logga in f\u00f6r att svara", 
    "Solution \u2713": "L\u00f6sning \u2713", 
    "Storage/SD card": "Lagring/Minneskort", 
    "Support": "Hj\u00e4lp", 
    "System Updates": "Systemuppdateringar", 
    "Thank you for your question!": "Tack f\u00f6r din fr\u00e5ga!", 
    "There was a problem with Buddy Up, please try again.": "Det uppstod ett problem med Buddy Up. f\u00f6rs\u00f6k igen.", 
    "This field is required.": "F\u00e4ltet \u00e4r obligatoriskt.", 
    "This solved my question": "Detta l\u00f6ste min fr\u00e5ga", 
    "This will close the question and let your buddy know you no longer need help.": "Detta kommer att st\u00e4nga fr\u00e5gan och l\u00e5ta din buddy veta att du inte l\u00e4ngre beh\u00f6ver hj\u00e4lp.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "F\u00f6r m\u00e5nga fr\u00e5gor? Anv\u00e4nd inst\u00e4llningarna nedan f\u00f6r att begr\u00e4nsa listan \"Svara p\u00e5 en fr\u00e5ga\".", 
    "Top Helpers this Week": "B\u00e4sta hj\u00e4lpare denna vecka", 
    "Unable to generate username.": "Det gick inte att generera anv\u00e4ndarnamn.", 
    "Unable to log in with provided credentials.": "Det g\u00e5r inte att logga in med angivna inloggningsuppgifter.", 
    "Unknown error: \"{error}\"": "Ok\u00e4nt fel: \"{error}\"", 
    "Unsupported Language": "Spr\u00e5ket st\u00f6ds inte", 
    "User account is disabled.": "Anv\u00e4ndarkontot \u00e4r inaktiverat.", 
    "User not found.": "Anv\u00e4ndare hittades inte.", 
    "Username": "Anv\u00e4ndarnamn", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "Anv\u00e4ndarnamn kan endast vara bokst\u00e4ver, siffror, \".\" och \"-\".", 
    "We can help<br>Ask us anything!": "Vi kan hj\u00e4lpa<br>Fr\u00e5ga oss vad som helst!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "Vi beklagar, men BuddyUp kan inte installeras p\u00e5 din version av Firefox OS. St\u00e4ng detta f\u00f6nster f\u00f6r att \u00e5terg\u00e5 till startsk\u00e4rmen.", 
    "We've sent a welcome email to:": "Vi har skickat ett v\u00e4lkomstbrev till:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "Vi har skickat ett e-postmeddelande. F\u00f6lj bara l\u00e4nken i meddelandet f\u00f6r att \u00e5terst\u00e4lla ditt l\u00f6senord.", 
    "Whoops!": "Hoppsan!", 
    "Write your message\u2026": "Skriv ditt meddelande\u2026", 
    "Yay, you're almost done!": "Hurra, du \u00e4r n\u00e4stan klar!", 
    "You are not online, please check your connection.": "Du \u00e4r inte online, v\u00e4nligen kontrollera din anslutning.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "Du kommer att f\u00e5 ett meddelande s\u00e5 snart en Buddy kommer till unds\u00e4ttning.", 
    "just now": "nyss", 
    "x hours ago": "x timmar sedan", 
    "{n} day ago": [
      "{n} dag sedan", 
      "{n} dagar sedan"
    ], 
    "{n} helpful vote": [
      "{n} hj\u00e4lpsam r\u00f6st", 
      "{n} hj\u00e4lpsamma r\u00f6ster"
    ], 
    "{n} hour ago": [
      "{n} timme sedan", 
      "{n} timmar sedan"
    ], 
    "{n} minute ago": [
      "{n} minut sedan", 
      "{n} minuter sedan"
    ], 
    "{n} question solved": [
      "{n} fr\u00e5ga l\u00f6st", 
      "{n} fr\u00e5gor l\u00f6sta"
    ], 
    "{user} chose your answer as a solution": "{user} valde ditt svar som en l\u00f6sning", 
    "{user} left a comment on your question": "{user}  l\u00e4mnade en kommentar p\u00e5 din fr\u00e5ga"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j F Y H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "j F Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "Y-m-d H:i", 
    "SHORT_DATE_FORMAT": "Y-m-d", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "H:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

