

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n != 1);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> kura ya manufaa</div>", 
      "<div {countattr}>{n}</div><div {textattr}> kura za manufaa</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> swali limetatuliwa</div>", 
      "<div {countattr}>{n}</div><div {textattr}> maswali yametatuliwa</div>"
    ], 
    "All My Questions": "Maswali yangu yote", 
    "Already registered? Sign in": "Tayari umesajiliwa? Ingia", 
    "An account lets you answer questions, track contributions and receive alerts.": "Akaunti inakuwezesha kujibu maswali, kufuatilia michango na kupokea habari.", 
    "Answer Questions": "Jibu maswali", 
    "Answer a Question": "Jibu Swali", 
    "Answered Questions": "Maswali yaliyojibiwa", 
    "Audio/Music/FMRadio": "Audio/Muziki/Radio ya FM", 
    "Browser/Download": "Kisakuzi/Shusha", 
    "Camera/Gallery/Video": "Kamera/Nyumba ya sanaa/Video", 
    "Cancel": "Ghairi", 
    "Cancel Sign Up": "Ghairi kujiandiksha", 
    "Cellular Data/WiFi/Bluetooth": "Data ya simu za mkononi /WiFi/Bluetooth", 
    "Choose a category": "Chagua jamii", 
    "Clock/Alarm": "Saa / kengele", 
    "Close": "Funga", 
    "Confirm Account": "Thibitisha Akaunti", 
    "Continue": "Endelea", 
    "Create account or sign in": "Unda akaunti au uingie", 
    "Dialer/Contacts": "Dialer/Majina", 
    "Don't have an account? Register": "Huna akaunti? Jisajili", 
    "Email/Calendar": "Barua pepe / kalenda", 
    "Failed": "Imeshindwa", 
    "Forgot your password?": "Umesahau neno-siri lako?", 
    "Get a Buddy to help you with your device": "Kupata Buddy kukusaidia na kifaa yako", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "Nenda kwenye tabo ili kujibu baadhi ya maswali. Tutaweza kuweka wimbo wao hapa.", 
    "Have Answers?": "Una majibu?", 
    "Help Article": "Ibara ya msaada", 
    "Incompatible version": "Toleo haziendani", 
    "Keyboard": "Kinanda", 
    "Language": "Lugha", 
    "Last sync:": "Upatanishi wa mwisho:", 
    "Load more": "Pakia zaidi", 
    "Maps/GPS": "Ramani/GPS", 
    "Marketplace/Apps Install": "Soko /Kusakinisha Apps", 
    "My Profile": "Profaili yangu", 
    "My Question": "Swali langu", 
    "My Questions": "Maswali yangu", 
    "My list": "Orodha yangu", 
    "My preferences": "Mapendeleo yangu", 
    "New": "Mpya", 
    "No active questions": "Hakuna maswali wazi", 
    "OK": "OK", 
    "Ok": "Ok", 
    "Other": "Nyingine", 
    "Performance": "Utendaji", 
    "Quit": "Kujiondoa", 
    "Reset Password": "Weka upya neno-siri lako", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "Kutuma\u2026", 
    "Settings": "Mazingira", 
    "Sign In": "Ingia", 
    "Sign in to answer questions from the Mozilla community.": "Ingia ndani ili kujibu maswali kutoka kwa jumuiya ya Mozilla.", 
    "Solution \u2713": "Suluhisho", 
    "Storage/SD card": "Uhifadhi /Kadi ya SD", 
    "Support": "Msaada", 
    "System Updates": "Mabadiliko ya mfumo", 
    "Thank you for your question!": "Asante kwa swali lako!", 
    "There was a problem with Buddy Up, please try again.": "Kulikuwa na hitilafu na Buddy Up, tafadhali jaribu tena.", 
    "This solved my question": "Hii imetatua swali langu", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "Maswali mengi mno? Tumia mazingira hapa chini kufupisha \"Jibu Swali\" orodha.", 
    "Top Helpers this Week": "Wasaidizi wa juu wiki hii", 
    "User not found.": "Mtumiaji hapatikani.", 
    "We've sent a welcome email to:": "Tumetuma barua pepe ya kukakaribisha kwa:", 
    "Whoops!": "Lahaula!", 
    "Yay, you're almost done!": "Yay, uko karibu kumaliza!", 
    "You are not online, please check your connection.": "Hauko mtandaoni, tafadhali angalia uhusiano wako.", 
    "x hours ago": "masaa x iliyopita", 
    "{n} helpful vote": [
      "{n} kura ya manufaa", 
      "{n} kura za manufaa"
    ], 
    "{n} question solved": [
      "{n} swali limetatuliwa", 
      "{n} maswali yametatuliwa"
    ], 
    "{user} chose your answer as a solution": "{user} alichagua jibu lako kama suluhisho", 
    "{user} left a comment on your question": "{user} aliacha maoni kwenye swali lako"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "N j, Y, P", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "N j, Y", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y", 
      "%b %d %Y", 
      "%b %d, %Y", 
      "%d %b %Y", 
      "%d %b, %Y", 
      "%B %d %Y", 
      "%B %d, %Y", 
      "%d %B %Y", 
      "%d %B, %Y"
    ], 
    "DECIMAL_SEPARATOR": ".", 
    "FIRST_DAY_OF_WEEK": "0", 
    "MONTH_DAY_FORMAT": "F j", 
    "NUMBER_GROUPING": "0", 
    "SHORT_DATETIME_FORMAT": "m/d/Y P", 
    "SHORT_DATE_FORMAT": "m/d/Y", 
    "THOUSAND_SEPARATOR": ",", 
    "TIME_FORMAT": "P", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

