

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=0;
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}<div {textattr}> yararl\u0131 oy</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> sorun \u00e7\u00f6z\u00fcld\u00fc</div>"
    ], 
    "Audio/Music/FMRadio": "Ses/M\u00fczik/FMRadyo", 
    "Browser/Download": "Taray\u0131c\u0131/\u0130ndirme", 
    "Camera/Gallery/Video": "Kamera/Galeri/Video", 
    "Cellular Data/WiFi/Bluetooth": "H\u00fccresel Veri/WiFi/Bluetooth", 
    "Choose a category": "Kategori se\u00e7in", 
    "Clock/Alarm": "Saat/Alarm", 
    "Create account or sign in": "Hesap a\u00e7\u0131n veya giri\u015f yap\u0131n", 
    "Dialer/Contacts": "Arama/Ki\u015filer", 
    "Email/Calendar": "E-posta/Takvim", 
    "Failed": "Ba\u015far\u0131s\u0131z", 
    "Keyboard": "Klavye", 
    "Language": "Dil", 
    "Maps/GPS": "Harita/GPS", 
    "Marketplace/Apps Install": "Marketplace/Uygulama Y\u00fckleme", 
    "My preferences": "Tercihlerim", 
    "No active questions": "Aktif soru yok", 
    "OK": "Tamam", 
    "Other": "Di\u011fer", 
    "Performance": "Performans", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "G\u00f6nderiliyor\u2026", 
    "Sign in to answer questions from the Mozilla community.": "Mozilla toplulu\u011fundan gelen sorular\u0131 cevaplamak i\u00e7in giri\u015f yap\u0131n.", 
    "Solution \u2713": "\u00c7\u00f6z\u00fcm \u2713", 
    "Storage/SD card": "Depolama/SD kart", 
    "System Updates": "Sistem G\u00fcncellemeleri", 
    "There was a problem with Buddy Up, please try again.": "Buddy Up ile ilgili bir sorun var. L\u00fctfen yeniden deneyin.", 
    "This solved my question": "Bu yan\u0131t sorunumu \u00e7\u00f6zd\u00fc", 
    "User not found.": "Kullan\u0131c\u0131 bulunamad\u0131.", 
    "Whoops!": "Hay bin kunduz!", 
    "{n} helpful vote": [
      "{n} yararl\u0131 oy"
    ], 
    "{n} question solved": [
      "{n} sorun \u00e7\u00f6z\u00fcld\u00fc"
    ]
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "d F Y H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%d/%m/%Y %H:%M:%S", 
      "%d/%m/%Y %H:%M:%S.%f", 
      "%d/%m/%Y %H:%M", 
      "%d/%m/%Y", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "d F Y", 
    "DATE_INPUT_FORMATS": [
      "%d/%m/%Y", 
      "%d/%m/%y", 
      "%y-%m-%d", 
      "%Y-%m-%d"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "d F", 
    "NUMBER_GROUPING": "3", 
    "SHORT_DATETIME_FORMAT": "d M Y H:i:s", 
    "SHORT_DATE_FORMAT": "d M Y", 
    "THOUSAND_SEPARATOR": ".", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

