

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0439 \u0433\u043e\u043b\u043e\u0441</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043a\u043e\u0440\u0438\u0441\u043d\u0456 \u0433\u043e\u043b\u043e\u0441\u0438</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0445 \u0433\u043e\u043b\u043e\u0441\u0456\u0432</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u0435</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u0456</div>", 
      "<div {countattr}>{n}</div><div {textattr}> \u043f\u0438\u0442\u0430\u043d\u044c \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u043e</div>"
    ], 
    "A user with that email address already exists.": "\u041a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447 \u0437 \u0442\u0430\u043a\u043e\u044e \u0435\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u044e \u0430\u0434\u0440\u0435\u0441\u043e\u044e \u0432\u0436\u0435 \u0456\u0441\u043d\u0443\u0454.", 
    "A user with that username exists": "\u0412\u0436\u0435 \u0454 \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447 \u0437 \u0442\u0430\u043a\u0438\u043c \u0456\u043c\u0435\u043d\u0435\u043c", 
    "All My Questions": "\u0412\u0441\u0456 \u043c\u043e\u0457 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "Already registered? Sign in": "\u0412\u0436\u0435 \u0437\u0430\u0440\u0435\u0454\u0441\u0442\u0440\u043e\u0432\u0430\u043d\u0456? \u0423\u0432\u0456\u0439\u0434\u0456\u0442\u044c", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u041e\u0431\u043b\u0456\u043a\u043e\u0432\u0438\u0439 \u0437\u0430\u043f\u0438\u0441 \u0434\u043e\u0437\u0432\u043e\u043b\u044f\u0454 \u0432\u0430\u043c \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u0438 \u043f\u0438\u0442\u0430\u043d\u043d\u044f, \u0432\u0456\u0434\u0441\u0442\u0435\u0436\u0443\u0432\u0430\u0442\u0438 \u0441\u0432\u043e\u044e \u0440\u043e\u0431\u043e\u0442\u0443 \u0442\u0430 \u043e\u0442\u0440\u0438\u043c\u0443\u0432\u0430\u0442\u0438 \u0441\u043f\u043e\u0432\u0456\u0449\u0435\u043d\u043d\u044f.", 
    "Another helper has answered this question, please choose another.": "\u0406\u043d\u0448\u0438\u0439 \u043f\u043e\u043c\u0456\u0447\u043d\u0438\u043a \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0432 \u043d\u0430 \u0446\u0435 \u043f\u0438\u0442\u0430\u043d\u043d\u044f, \u0432\u0438\u0431\u0435\u0440\u0456\u0442\u044c \u0431\u0443\u0434\u044c \u043b\u0430\u0441\u043a\u0430 \u0456\u043d\u0448\u0435.", 
    "Answer Questions": "\u0412\u0456\u0434\u043f\u043e\u0432\u0456\u0441\u0442\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "Answer a Question": "\u0412\u0456\u0434\u043f\u043e\u0432\u0456\u0441\u0442\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "Answer questions": "\u0412\u0456\u0434\u043f\u043e\u0432\u0456\u0441\u0442\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "Answered Questions": "\u041f\u0438\u0442\u0430\u043d\u043d\u044f \u0437 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u044f\u043c\u0438", 
    "Ask a Question": "\u0417\u0430\u0434\u0430\u0439\u0442\u0435 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "Audio/Music/FMRadio": "\u0410\u0443\u0434\u0456\u043e/\u041c\u0443\u0437\u0438\u043a\u0430/FM \u0440\u0430\u0434\u0456\u043e", 
    "Be aware that you will lose your history when you sign in to your account.": "\u041c\u0430\u0439\u0442\u0435 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456, \u0449\u043e \u0432\u0438 \u0432\u0442\u0440\u0430\u0442\u0438\u0442\u0435 \u0441\u0432\u043e\u044e \u0456\u0441\u0442\u043e\u0440\u0456\u044e \u043f\u0456\u0441\u043b\u044f \u0432\u0445\u043e\u0434\u0443 \u0432 \u0441\u0432\u0456\u0439 \u043e\u0431\u043b\u0456\u043a\u043e\u0432\u0438\u0439 \u0437\u0430\u043f\u0438\u0441.", 
    "Browser/Download": "\u0411\u0440\u0430\u0443\u0437\u0435\u0440/\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp \u0437\u0430\u0440\u0430\u0437 \u043d\u0435 \u043f\u0456\u0434\u0442\u0440\u0438\u043c\u0443\u0454 \"<span id=\"language\"></span>\".", 
    "Camera/Gallery/Video": "\u041a\u0430\u043c\u0435\u0440\u0430/\u0413\u0430\u043b\u0435\u0440\u0435\u044f/\u0412\u0456\u0434\u0435\u043e", 
    "Can't change this field.": "\u0426\u0435 \u043f\u043e\u043b\u0435 \u043d\u0435 \u043c\u043e\u0436\u043d\u0430 \u0437\u043c\u0456\u043d\u0438\u0442\u0438.", 
    "Cancel": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438", 
    "Cancel Sign Up": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0440\u0435\u0454\u0441\u0442\u0440\u0430\u0446\u0456\u044e", 
    "Cellular Data/WiFi/Bluetooth": "\u041c\u043e\u0431\u0456\u043b\u044c\u043d\u0456 \u0434\u0430\u043d\u0456/WiFi/Bluetooth", 
    "Choose a category": "\u041e\u0431\u0435\u0440\u0456\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0456\u044e", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "\u041d\u0430\u0442\u0438\u0441\u043d\u0456\u0442\u044c \u043f\u043e\u0441\u0438\u043b\u0430\u043d\u043d\u044f \u0432 \u0441\u0432\u043e\u0454\u043c\u0443 \u043b\u0438\u0441\u0442\u0456, \u0449\u043e\u0431 \u0434\u0430\u0442\u0438 \u043d\u0430\u043c \u043f\u0456\u0434\u0442\u0432\u0435\u0440\u0434\u0436\u0435\u043d\u043d\u044f. \u041f\u0456\u0441\u043b\u044f \u0446\u044c\u043e\u0433\u043e, \u043f\u043e\u0432\u0435\u0440\u043d\u0456\u0442\u044c\u0441\u044f \u043d\u0430 BuddyUp \u0456 \u0437\u0440\u043e\u0431\u0456\u0442\u044c \u0456\u043d\u0448\u0438\u0445 \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0456\u0432 \u0437\u0430\u0434\u043e\u0432\u043e\u043b\u0435\u043d\u0438\u043c\u0438!", 
    "Clock/Alarm": "\u0413\u043e\u0434\u0438\u043d\u043d\u0438\u043a/\u0411\u0443\u0434\u0438\u043b\u044c\u043d\u0438\u043a", 
    "Close": "\u0417\u0430\u043a\u0440\u0438\u0442\u0438", 
    "Confirm Account": "\u041f\u0456\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0438 \u043e\u0431\u043b\u0456\u043a\u043e\u0432\u0438\u0439 \u0437\u0430\u043f\u0438\u0441", 
    "Continue": "\u041f\u0440\u043e\u0434\u043e\u0432\u0436\u0438\u0442\u0438", 
    "Create Account": "\u0421\u0442\u0432\u043e\u0440\u0438\u0442\u0438 \u043e\u0431\u043b\u0456\u043a\u043e\u0432\u0438\u0439 \u0437\u0430\u043f\u0438\u0441", 
    "Create account or sign in": "\u0421\u0442\u0432\u043e\u0440\u0456\u0442\u044c \u043e\u0431\u043b\u0456\u043a\u043e\u0432\u0438\u0439 \u0437\u0430\u043f\u0438\u0441 \u0447\u0438 \u0443\u0432\u0456\u0439\u0434\u0456\u0442\u044c", 
    "Device": "\u041f\u0440\u0438\u0441\u0442\u0440\u0456\u0439", 
    "Dialer/Contacts": "\u0412\u0438\u043a\u043b\u0438\u043a/\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u0438", 
    "Don't have an account? Register": "\u041d\u0435\u043c\u0430\u0454 \u043e\u0431\u043b\u0456\u043a\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0443? \u0417\u0430\u0440\u0435\u0454\u0441\u0442\u0440\u0443\u0439\u0442\u0435\u0441\u044c", 
    "Done": "\u0413\u043e\u0442\u043e\u0432\u043e", 
    "Email Address": "\u0410\u0434\u0440\u0435\u0441\u0430 \u0435\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0457 \u043f\u043e\u0448\u0442\u0438", 
    "Email/Calendar": "\u0415\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430 \u043f\u043e\u0448\u0442\u0430/\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440", 
    "Failed": "\u0417\u0431\u0456\u0439", 
    "Forgot your password?": "\u0417\u0430\u0431\u0443\u043b\u0438 \u0441\u0432\u0456\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "\u0417\u0430\u0431\u0443\u043b\u0438 \u0441\u0432\u0456\u0439 \u043f\u0430\u0440\u043e\u043b\u044c? \u041d\u0435 \u0445\u0432\u0438\u043b\u044e\u0439\u0442\u0435\u0441\u044f. \u0412\u0432\u0435\u0434\u0456\u0442\u044c \u0441\u0432\u043e\u0454 \u0456\u043c'\u044f \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0430 \u0432\u043d\u0438\u0437\u0443 \u0456 \u043c\u0438 \u043d\u0430\u0434\u0456\u0448\u043b\u0435\u043c\u043e \u0432\u0430\u043c \u0456\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457 \u0437 \u0432\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0430\u0440\u043e\u043b\u044f.", 
    "Get a Buddy to help you with your device": "\u0417\u043d\u0430\u0439\u0434\u0456\u0442\u044c \u043f\u0440\u0438\u044f\u0442\u0435\u043b\u044f, \u044f\u043a\u0438\u0439 \u0434\u043e\u043f\u043e\u043c\u043e\u0436\u0435 \u0432\u0430\u043c \u0437 \u0432\u0430\u0448\u0438\u043c \u043f\u0440\u0438\u0441\u0442\u0440\u043e\u0454\u043c", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\u041f\u0435\u0440\u0435\u0439\u0434\u0456\u0442\u044c \u043d\u0430 \u043d\u043e\u0432\u0443 \u0432\u043a\u043b\u0430\u0434\u043a\u0443, \u0449\u043e\u0431 \u0437\u0430\u0434\u0430\u0442\u0438 \u043f\u0438\u0442\u0430\u043d\u043d\u044f. \u041c\u0438 \u0431\u0443\u0434\u0435\u043c\u043e \u0432\u0456\u0434\u0441\u0442\u0435\u0436\u0443\u0432\u0430\u0442\u0438 \u0457\u0445 \u0442\u0443\u0442.", 
    "Has your question been solved?": "\u0412\u0430\u0448\u0435 \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0431\u0443\u043b\u043e \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u0435?", 
    "Have Answers?": "\u041c\u0430\u0454\u0442\u0435 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0456?", 
    "Have Questions?": "\u041c\u0430\u0454\u0442\u0435 \u043f\u0438\u0442\u0430\u043d\u043d\u044f?", 
    "Help Article": "\u0421\u0442\u0430\u0442\u0442\u044f \u0434\u043e\u0432\u0456\u0434\u043a\u0438", 
    "Help other users around the world": "\u0414\u043e\u043f\u043e\u043c\u043e\u0436\u0456\u0442\u044c \u0456\u043d\u0448\u0438\u043c \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0430\u043c \u043f\u043e \u0432\u0441\u044c\u043e\u043c\u0443 \u0441\u0432\u0456\u0442\u0443", 
    "Incompatible version": "\u041d\u0435\u0441\u0443\u043c\u0456\u0441\u043d\u0430 \u0432\u0435\u0440\u0441\u0456\u044f", 
    "Keyboard": "\u041a\u043b\u0430\u0432\u0456\u0430\u0442\u0443\u0440\u0430", 
    "Language": "\u041c\u043e\u0432\u0430", 
    "Last sync:": "\u0412\u043e\u0441\u0442\u0430\u043d\u043d\u0454 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0456\u0437\u043e\u0432\u0430\u043d\u043e:", 
    "Load more": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0438\u0442\u0438 \u0449\u0435", 
    "Maps/GPS": "\u041a\u0430\u0440\u0442\u0438/GPS", 
    "Marketplace/Apps Install": "Marketplace/\u0412\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c", 
    "My Profile": "\u041c\u0456\u0439 \u043f\u0440\u043e\u0444\u0456\u043b\u044c", 
    "My Question": "\u041c\u043e\u0454 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "My Questions": "\u041c\u043e\u0457 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "My list": "\u041c\u0456\u0439 \u0441\u043f\u0438\u0441\u043e\u043a", 
    "My preferences": "\u041c\u043e\u0457 \u0432\u043f\u043e\u0434\u043e\u0431\u0430\u043d\u043d\u044f", 
    "New": "\u041d\u043e\u0432\u0435", 
    "No active questions": "\u041d\u0435\u043c\u0430\u0454 \u0430\u043a\u0442\u0438\u0432\u043d\u0438\u0445 \u043f\u0438\u0442\u0430\u043d\u044c", 
    "No matching user setting found.": "\u041d\u0435 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0437\u0431\u0456\u0433\u0456\u0432 \u043d\u0430\u043b\u0430\u0448\u0442\u0443\u0432\u0430\u043d\u044c \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0430.", 
    "No questions": "\u041d\u0435\u043c\u0430\u0454 \u043f\u0438\u0442\u0430\u043d\u044c", 
    "OK": "\u041e\u041a", 
    "Ok": "Ok", 
    "Operator": "\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440", 
    "Other": "\u0406\u043d\u0448\u0435", 
    "Password": "\u041f\u0430\u0440\u043e\u043b\u044c", 
    "Performance": "\u0428\u0432\u0438\u0434\u043a\u043e\u0434\u0456\u044f", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "\u0411\u0443\u0434\u044c \u043b\u0430\u0441\u043a\u0430, \u0437\u0430\u0434\u0430\u0439\u0442\u0435 \u0441\u0432\u043e\u0457 \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0430\u043d\u0433\u043b\u0456\u0439\u0441\u044c\u043a\u043e\u044e, \u0430\u0431\u043e \u043f\u0435\u0440\u0435\u0439\u0434\u0456\u0442\u044c \u043d\u0430 <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> \u0434\u043b\u044f \u043e\u0442\u0440\u0438\u043c\u0430\u043d\u043d\u044f \u0434\u043e\u043f\u043e\u043c\u043e\u0433\u0438.", 
    "Previously Answered": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u0456 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0456", 
    "Quit": "\u0412\u0438\u0439\u0442\u0438", 
    "Reset Password": "\u0421\u043a\u0438\u043d\u0443\u0442\u0438 \u043f\u0430\u0440\u043e\u043b\u044c", 
    "SMS/MMS": "SMS/MMS", 
    "Sending\u2026": "\u041d\u0430\u0434\u0441\u0438\u043b\u0430\u043d\u043d\u044f\u2026", 
    "Settings": "\u041d\u0430\u043b\u0430\u0448\u0442\u0443\u0432\u0430\u043d\u043d\u044f", 
    "Sign In": "\u0423\u0432\u0456\u0439\u0442\u0438", 
    "Sign in to answer questions from Firefox OS users.": "\u0423\u0432\u0456\u0439\u0434\u0456\u0442\u044c, \u0449\u043e\u0431 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0430\u0442\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0432\u0456\u0434 \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0456\u0432 Firefox OS.", 
    "Sign in to answer questions from the Mozilla community.": "\u0423\u0432\u0456\u0439\u0434\u0456\u0442\u044c, \u0449\u043e\u0431 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0430\u0442\u0438 \u043d\u0430 \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0432\u0456\u0434 \u0441\u043f\u0456\u043b\u044c\u043d\u043e\u0442\u0438 Mozilla.", 
    "Sign in to reply": "\u0423\u0432\u0456\u0439\u0434\u0456\u0442\u044c, \u0449\u043e\u0431 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0441\u0442\u0438", 
    "Solution \u2713": "\u0412\u0438\u0440\u0456\u0448\u0435\u043d\u043d\u044f \u2713", 
    "Storage/SD card": "\u0421\u0445\u043e\u0432\u0438\u0449\u0435/SD-\u043a\u0430\u0440\u0442\u0430", 
    "Support": "\u041f\u0456\u0434\u0442\u0440\u0438\u043c\u043a\u0430", 
    "System Updates": "\u041e\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0438", 
    "Thank you for your question!": "\u0414\u044f\u043a\u0443\u0454\u043c\u043e \u0437\u0430 \u0432\u0430\u0448\u0435 \u043f\u0438\u0442\u0430\u043d\u043d\u044f!", 
    "There was a problem with Buddy Up, please try again.": "\u0421\u0442\u0430\u043b\u0430\u0441\u044f \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0437 Buddy Up, \u0441\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u043d\u043e\u0432\u0443.", 
    "This field is required.": "\u0426\u0435 \u043f\u043e\u043b\u0435 \u043e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0435.", 
    "This solved my question": "\u0426\u0435 \u0432\u0438\u0440\u0456\u0448\u0438\u043b\u043e \u043c\u043e\u0454 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", 
    "This will close the question and let your buddy know you no longer need help.": "\u0426\u0435 \u043f\u0440\u0438\u0437\u0432\u0435\u0434\u0435 \u0434\u043e \u0437\u0430\u043a\u0440\u0438\u0442\u0442\u044f \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0439 \u0434\u0430\u0441\u0442\u044c \u0437\u043d\u0430\u0442\u0438 \u0432\u0430\u0448\u043e\u043c\u0443 \u043f\u043e\u043c\u0456\u0447\u043d\u0438\u043a\u0443, \u0449\u043e \u0432\u0430\u043c \u0431\u0456\u043b\u044c\u0448\u0435 \u043d\u0435 \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u0430 \u0434\u043e\u043f\u043e\u043c\u043e\u0433\u0430.", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\u0417\u0430\u0431\u0430\u0433\u0430\u0442\u043e \u043f\u0438\u0442\u0430\u043d\u044c? \u0421\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u0439\u0442\u0435\u0441\u044c \u043d\u0430\u043b\u0430\u0448\u0442\u0443\u0432\u0430\u043d\u043d\u044f\u043c \u0432\u043d\u0438\u0437\u0443 \u0434\u043b\u044f \u0437\u0432\u0443\u0436\u0435\u043d\u043d\u044f \u0441\u043f\u0438\u0441\u043a\u0443 \"\u0412\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0435\u0439 \u043d\u0430 \u043f\u0438\u0442\u0430\u043d\u043d\u044f\".", 
    "Top Helpers this Week": "\u041d\u0430\u0439\u043a\u0440\u0430\u0449\u0456 \u043f\u043e\u043c\u0456\u0447\u043d\u0438\u043a\u0438 \u0446\u044c\u043e\u0433\u043e \u0442\u0438\u0436\u043d\u044f", 
    "Unable to generate username.": "\u041d\u0435 \u0432\u0434\u0430\u043b\u043e\u0441\u044f \u0433\u0435\u043d\u0435\u0440\u0443\u0432\u0430\u0442\u0438 \u0456\u043c'\u044f \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0430.", 
    "Unknown error: \"{error}\"": "\u041d\u0435\u0432\u0456\u0434\u043e\u043c\u0430 \u043f\u043e\u043c\u0438\u043b\u043a\u0430: \"{error}\"", 
    "Unsupported Language": "\u041d\u0435\u043f\u0456\u0434\u0442\u0440\u0438\u043c\u0443\u0432\u0430\u043d\u0430 \u043c\u043e\u0432\u0430", 
    "User not found.": "\u041a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447 \u043d\u0435 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u0438\u0439.", 
    "Username": "\u0406\u043c\u2019\u044f \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0430", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "\u0406\u043c'\u044f \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447\u0430 \u043c\u043e\u0436\u0435 \u0441\u043a\u043b\u0430\u0434\u0430\u0442\u0438\u0441\u044c \u043b\u0438\u0448\u0435 \u0437 \u043b\u0456\u0442\u0435\u0440, \u0446\u0438\u0444\u0440, \".\" \u0442\u0430 \"-\".", 
    "We can help<br>Ask us anything!": "\u041c\u0438 \u043c\u043e\u0436\u0435\u043c\u043e \u0434\u043e\u043f\u043e\u043c\u043e\u0433\u0442\u0438<br>\u0417\u0430\u043f\u0438\u0442\u0430\u0439\u0442\u0435 \u043d\u0430\u0441 \u043f\u0440\u043e \u0449\u043e \u0437\u0430\u0432\u0433\u043e\u0434\u043d\u043e!", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "\u041d\u0430\u043c \u0448\u043a\u043e\u0434\u0430, \u0430\u043b\u0435 BuddyUp \u043d\u0435\u043c\u043e\u0436\u043b\u0438\u0432\u043e \u0432\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0438 \u043d\u0430 \u0432\u0430\u0448\u0443 \u0432\u0435\u0440\u0441\u0456\u044e Firefox OS. \u0411\u0443\u0434\u044c \u043b\u0430\u0441\u043a\u0430, \u0437\u0430\u043a\u0440\u0438\u0439\u0442\u0435 \u0446\u0435 \u0432\u0456\u043a\u043d\u043e, \u0449\u043e\u0431 \u043f\u043e\u0432\u0435\u0440\u043d\u0443\u0442\u0438\u0441\u044f \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0456\u0439 \u0435\u043a\u0440\u0430\u043d.", 
    "We've sent a welcome email to:": "\u041c\u0438 \u043d\u0430\u0434\u0456\u0441\u043b\u0430\u043b\u0438 \u043b\u0438\u0441\u0442 \u0456\u0437 \u0437\u0430\u043f\u0440\u043e\u0448\u0435\u043d\u043d\u044f\u043c \u043d\u0430:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "\u041c\u0438 \u043d\u0430\u0434\u0456\u0441\u043b\u0430\u043b\u0438 \u0432\u0430\u043c \u0435\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0438\u0439 \u043b\u0438\u0441\u0442. \u0414\u043b\u044f \u0441\u043a\u0438\u0434\u0430\u043d\u043d\u044f \u0441\u0432\u043e\u0433\u043e \u043f\u0430\u0440\u043e\u043b\u044e, \u043f\u0440\u043e\u0441\u0442\u043e \u043f\u0435\u0440\u0435\u0439\u0434\u0456\u0442\u044c \u0437\u0430 \u043f\u043e\u0441\u0438\u043b\u0430\u043d\u043d\u044f\u043c \u0432 \u043b\u0438\u0441\u0442\u0456.", 
    "Whoops!": "\u041e\u0439!", 
    "Write your message\u2026": "\u041d\u0430\u043f\u0438\u0448\u0456\u0442\u044c \u0441\u0432\u043e\u0454 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f\u2026", 
    "Yay, you're almost done!": "\u0421\u0443\u043f\u0435\u0440, \u0432\u0438 \u043c\u0430\u0439\u0436\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0438!", 
    "You are not online, please check your connection.": "\u0412\u0438 \u0437\u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0435\u0441\u044c \u043d\u0435 \u0432 \u043c\u0435\u0440\u0435\u0436\u0456, \u043f\u0435\u0440\u0435\u0432\u0456\u0440\u0442\u0435 \u0441\u0432\u043e\u0454 \u0437'\u0454\u0434\u043d\u0430\u043d\u043d\u044f.", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "\u0412\u0438 \u043e\u0442\u0440\u0438\u043c\u0430\u0454\u0442\u0435 \u0441\u043f\u043e\u0432\u0456\u0449\u0435\u043d\u043d\u044f \u043e\u0434\u0440\u0430\u0437\u0443, \u044f\u043a \u0442\u0456\u043b\u044c\u043a\u0438 Buddy \u0437\u0430\u043f\u0440\u043e\u043f\u043e\u043d\u0443\u0454 \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u043d\u044f.", 
    "just now": "\u0449\u043e\u0439\u043d\u043e", 
    "x hours ago": "x \u0433\u043e\u0434\u0438\u043d \u0442\u043e\u043c\u0443", 
    "{n} day ago": [
      "{n} \u0434\u0435\u043d\u044c \u0442\u043e\u043c\u0443", 
      "{n} \u0434\u043d\u0456 \u0442\u043e\u043c\u0443", 
      "{n} \u0434\u043d\u0456\u0432 \u0442\u043e\u043c\u0443"
    ], 
    "{n} helpful vote": [
      "{n} \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0439 \u0433\u043e\u043b\u043e\u0441", 
      "{n} \u043a\u043e\u0440\u0438\u0441\u043d\u0456 \u0433\u043e\u043b\u043e\u0441\u0438", 
      "{n} \u043a\u043e\u0440\u0438\u0441\u043d\u0438\u0445 \u0433\u043e\u043b\u043e\u0441\u0456\u0432"
    ], 
    "{n} hour ago": [
      "{n} \u0433\u043e\u0434\u0438\u043d\u0443 \u0442\u043e\u043c\u0443", 
      "{n} \u0433\u043e\u0434\u0438\u043d\u0438 \u0442\u043e\u043c\u0443", 
      "{n} \u0433\u043e\u0434\u0438\u043d \u0442\u043e\u043c\u0443"
    ], 
    "{n} minute ago": [
      "{n} \u0445\u0432\u0438\u043b\u0438\u043d\u0443 \u0442\u043e\u043c\u0443", 
      "{n} \u0445\u0432\u0438\u043b\u0438\u043d\u0438 \u0442\u043e\u043c\u0443", 
      "{n} \u0445\u0432\u0438\u043b\u0438\u043d \u0442\u043e\u043c\u0443"
    ], 
    "{n} question solved": [
      "{n} \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u0435", 
      "{n} \u043f\u0438\u0442\u0430\u043d\u043d\u044f \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u0456", 
      "{n} \u043f\u0438\u0442\u0430\u043d\u044c \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u043e"
    ], 
    "{user} chose your answer as a solution": "{user} \u043e\u0431\u0440\u0430\u0432 \u0432\u0430\u0448\u0443 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u044c, \u044f\u043a \u0432\u0438\u0440\u0456\u0448\u0435\u043d\u043d\u044f", 
    "{user} left a comment on your question": "{user} \u0437\u0430\u043b\u0438\u0448\u0438\u0432 \u043a\u043e\u043c\u0435\u043d\u0442\u0430\u0440 \u043d\u0430 \u0432\u0430\u0448\u0435 \u043f\u0438\u0442\u0430\u043d\u043d\u044f"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "j E Y \u0440. H:i:s", 
    "DATETIME_INPUT_FORMATS": [
      "%Y-%m-%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M", 
      "%Y-%m-%d", 
      "%m/%d/%Y %H:%M:%S", 
      "%m/%d/%Y %H:%M:%S.%f", 
      "%m/%d/%Y %H:%M", 
      "%m/%d/%Y", 
      "%m/%d/%y %H:%M:%S", 
      "%m/%d/%y %H:%M:%S.%f", 
      "%m/%d/%y %H:%M", 
      "%m/%d/%y"
    ], 
    "DATE_FORMAT": "j E Y \u0440.", 
    "DATE_INPUT_FORMATS": [
      "%Y-%m-%d", 
      "%m/%d/%Y", 
      "%m/%d/%y", 
      "%b %d %Y", 
      "%b %d, %Y", 
      "%d %b %Y", 
      "%d %b, %Y", 
      "%B %d %Y", 
      "%B %d, %Y", 
      "%d %B %Y", 
      "%d %B, %Y"
    ], 
    "DECIMAL_SEPARATOR": ",", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "j F", 
    "NUMBER_GROUPING": "0", 
    "SHORT_DATETIME_FORMAT": "m/d/Y P", 
    "SHORT_DATE_FORMAT": "j M Y", 
    "THOUSAND_SEPARATOR": "\u00a0", 
    "TIME_FORMAT": "H:i:s", 
    "TIME_INPUT_FORMATS": [
      "%H:%M:%S", 
      "%H:%M:%S.%f", 
      "%H:%M"
    ], 
    "YEAR_MONTH_FORMAT": "F Y"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

