

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=0;
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u6709\u5e2e\u52a9\u6295\u7968</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {countattr}>{n}</div><div {textattr}> \u4e2a\u95ee\u9898\u5df2\u89e3\u51b3</div>"
    ], 
    "A user with that email address already exists.": "\u4f7f\u7528\u8be5\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u7684\u7528\u6237\u5df2\u5b58\u5728\u3002", 
    "A user with that username exists": "\u4f7f\u7528\u8be5\u7528\u6237\u540d\u7684\u7528\u6237\u5df2\u5b58\u5728", 
    "All My Questions": "\u6211\u7684\u6240\u6709\u95ee\u9898", 
    "Already registered? Sign in": "\u5df2\u7ecf\u6ce8\u518c\uff1f\u767b\u5f55\u5427", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u4e00\u4e2a\u4f9b\u60a8\u56de\u7b54\u95ee\u9898\u3001\u8bb0\u5f55\u8d21\u732e\u65c5\u7a0b\u4ee5\u53ca\u63a5\u6536\u901a\u77e5\u7684\u8d26\u53f7\u3002", 
    "Another helper has answered this question, please choose another.": "\u53e6\u4e00\u540d\u52a9\u624b\u5df2\u7ecf\u56de\u7b54\u4e86\u6b64\u95ee\u9898\uff0c\u8bf7\u9009\u62e9\u522b\u7684\u3002", 
    "Answer Questions": "\u56de\u7b54\u63d0\u95ee", 
    "Answer a Question": "\u56de\u7b54\u4e00\u4e2a\u63d0\u95ee", 
    "Answer questions": "\u56de\u7b54\u95ee\u9898", 
    "Answered Questions": "\u5df2\u56de\u7b54\u7684\u95ee\u9898", 
    "Ask a Question": "\u53d1\u8d77\u63d0\u95ee", 
    "Audio/Music/FMRadio": "\u97f3\u9891/\u97f3\u4e50/\u8c03\u9891\u6536\u97f3\u673a", 
    "Be aware that you will lose your history when you sign in to your account.": "\u8bf7\u6ce8\u610f\uff0c\u60a8\u5c06\u5728\u767b\u5f55\u5230\u60a8\u7684\u8d26\u53f7\u65f6\u4e22\u5931\u60a8\u7684\u5386\u53f2\u8bb0\u5f55\u3002", 
    "Browser/Download": "\u6d4f\u89c8\u5668/\u4e0b\u8f7d", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp \u76ee\u524d\u4e0d\u652f\u6301\u201c<span id=\"language\"></span>\u201d\u3002", 
    "Camera/Gallery/Video": "\u76f8\u673a/\u56fe\u5e93/\u89c6\u9891", 
    "Can't change this field.": "\u65e0\u6cd5\u66f4\u6539\u6b64\u9879\u3002", 
    "Cancel": "\u53d6\u6d88", 
    "Cancel Sign Up": "\u53d6\u6d88\u6ce8\u518c", 
    "Cellular Data/WiFi/Bluetooth": "\u8702\u7a9d\u6570\u636e/WiFi/\u84dd\u7259", 
    "Choose a category": "\u9009\u62e9\u4e00\u4e2a\u5206\u7c7b", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "\u8bf7\u70b9\u51fb\u90ae\u4ef6\u4e2d\u7684\u94fe\u63a5\uff0c\u4ee5\u4fbf\u6211\u4eec\u786e\u8ba4\u5730\u5740\u6709\u6548\u3002\u7136\u540e\uff0c\u56de\u5230 BuddyUp \u5e76\u878d\u5165\u5230\u7528\u6237\u7fa4\u4e2d\u5427\uff01", 
    "Clock/Alarm": "\u65f6\u949f/\u95f9\u949f", 
    "Close": "\u5173\u95ed", 
    "Confirm Account": "\u786e\u8ba4\u8d26\u53f7", 
    "Continue": "\u7ee7\u7eed", 
    "Create Account": "\u521b\u5efa\u8d26\u53f7", 
    "Create account or sign in": "\u521b\u5efa\u8d26\u53f7\u6216\u767b\u5f55", 
    "Device": "\u8bbe\u5907", 
    "Dialer/Contacts": "\u62e8\u53f7\u76d8/\u8054\u7cfb\u4eba", 
    "Don't have an account? Register": "\u8fd8\u6ca1\u6709\u8d26\u53f7\uff1f\u6ce8\u518c\u5427", 
    "Done": "\u5b8c\u6210", 
    "Email Address": "\u7535\u5b50\u90ae\u4ef6\u5730\u5740", 
    "Email/Calendar": "\u7535\u5b50\u90ae\u4ef6/\u65e5\u5386", 
    "Enter a valid email address.": "\u8bf7\u8f93\u5165\u4e00\u4e2a\u6709\u6548\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u3002", 
    "Failed": "\u5931\u8d25", 
    "Forgot your password?": "\u5fd8\u8bb0\u5bc6\u7801\uff1f", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "\u5fd8\u8bb0\u4e86\u60a8\u7684\u5bc6\u7801\uff1f\u522b\u62c5\u5fc3\u3002\u5728\u4e0b\u9762\u8f93\u5165\u60a8\u7684\u7528\u6237\u540d\uff0c\u6211\u4eec\u5c06\u7ed9\u60a8\u53d1\u9001\u8bbe\u7f6e\u65b0\u5bc6\u7801\u7684\u64cd\u4f5c\u65b9\u6cd5\u3002", 
    "Get a Buddy to help you with your device": "\u627e\u4e2a\u597d\u4f19\u4f34\uff0c\u5e2e\u4f60\u89e3\u51b3\u8bbe\u5907\u95ee\u9898", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\u5230\u201c\u65b0\u7684\u201d\u9009\u9879\u5361\u56de\u7b54\u4e00\u4e9b\u95ee\u9898\u3002\u7136\u540e\u6211\u4eec\u4f1a\u5728\u8fd9\u91cc\u5173\u6ce8\u5b83\u4eec\u3002", 
    "Has your question been solved?": "\u60a8\u7684\u95ee\u9898\u5df2\u89e3\u51b3\uff1f", 
    "Have Answers?": "\u6709\u7b54\u6848\uff1f", 
    "Have Questions?": "\u6709\u95ee\u9898\uff1f", 
    "Help Article": "\u5e2e\u52a9\u6587\u7ae0", 
    "Help other users around the world": "\u5e2e\u52a9\u4e16\u754c\u5404\u5730\u7684\u5176\u4ed6\u7528\u6237", 
    "Incompatible version": "\u4e0d\u517c\u5bb9\u7684\u7248\u672c", 
    "Keyboard": "\u952e\u76d8", 
    "Language": "\u8bed\u8a00", 
    "Last sync:": "\u4e0a\u6b21\u540c\u6b65\uff1a", 
    "Load more": "\u52a0\u8f7d\u66f4\u591a", 
    "Maps/GPS": "\u5730\u56fe/GPS", 
    "Marketplace/Apps Install": "\u5e94\u7528\u5e02\u573a/\u5b89\u88c5\u5e94\u7528", 
    "My Profile": "\u6211\u7684\u4e2a\u4eba\u8d44\u6599", 
    "My Question": "\u6211\u7684\u95ee\u9898", 
    "My Questions": "\u6211\u7684\u95ee\u9898", 
    "My list": "\u6211\u7684\u5217\u8868", 
    "My preferences": "\u6211\u7684\u8bbe\u7f6e", 
    "New": "\u65b0\u7684", 
    "No active questions": "\u6ca1\u6709\u6d3b\u8dc3\u7684\u95ee\u9898", 
    "No matching user setting found.": "\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u7528\u6237\u8bbe\u7f6e\u3002", 
    "No questions": "\u6ca1\u6709\u95ee\u9898", 
    "OK": "\u786e\u5b9a", 
    "Ok": "\u786e\u5b9a", 
    "Operator": "\u64cd\u4f5c\u8005", 
    "Other": "\u5176\u4ed6", 
    "Password": "\u5bc6\u7801", 
    "Performance": "\u6027\u80fd", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "\u8bf7\u4ee5\u82f1\u8bed\u63d0\u51fa\u60a8\u7684\u95ee\u9898\uff0c\u6216\u8005\u8bbf\u95ee <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> \u83b7\u53d6\u66f4\u591a\u5e2e\u52a9\u3002", 
    "Previously Answered": "\u4ee5\u524d\u7684\u56de\u7b54", 
    "Quit": "\u79bb\u5f00", 
    "Reset Password": "\u91cd\u7f6e\u5bc6\u7801", 
    "SMS/MMS": "\u77ed\u4fe1/\u5f69\u4fe1", 
    "Sending\u2026": "\u6b63\u5728\u53d1\u9001\u2026", 
    "Settings": "\u8bbe\u7f6e", 
    "Sign In": "\u767b\u5f55", 
    "Sign in to answer questions from Firefox OS users.": "\u767b\u5f55\u4ee5\u56de\u7b54 Firefox \u7528\u6237\u7684\u63d0\u95ee\u3002", 
    "Sign in to answer questions from the Mozilla community.": "\u767b\u5f55\u4ee5\u56de\u7b54 Mozilla \u793e\u533a\u7684\u95ee\u9898\u3002", 
    "Sign in to reply": "\u767b\u5f55\u4ee5\u56de\u590d", 
    "Solution \u2713": "\u89e3\u51b3 \u2713", 
    "Storage/SD card": "\u5b58\u50a8/SD \u5361", 
    "Support": "\u652f\u6301", 
    "System Updates": "\u7cfb\u7edf\u66f4\u65b0", 
    "Thank you for your question!": "\u611f\u8c22\u60a8\u7684\u63d0\u95ee\uff01", 
    "There was a problem with Buddy Up, please try again.": "Buddy Up \u51fa\u73b0\u95ee\u9898\uff0c\u8bf7\u91cd\u8bd5\u3002", 
    "This field is required.": "\u6b64\u9879\u5fc5\u586b\u3002", 
    "This solved my question": "\u8fd9\u89e3\u51b3\u4e86\u6211\u7684\u95ee\u9898", 
    "This will close the question and let your buddy know you no longer need help.": "\u8fd9\u5c06\u5173\u95ed\u6b64\u95ee\u9898\uff0c\u5e76\u4e14\u8ba9\u4f19\u4f34\u77e5\u9053\u60a8\u4e0d\u9700\u8981\u5e2e\u52a9\u4e86\u3002", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\u95ee\u9898\u592a\u591a\uff1f\u4f7f\u7528\u4e0b\u9762\u7684\u8bbe\u7f6e\u7f29\u51cf\u201c\u56de\u7b54\u95ee\u9898\u201d\u5217\u8868\u3002", 
    "Top Helpers this Week": "\u672c\u5468\u9876\u5c16\u52a9\u624b", 
    "Unable to generate username.": "\u65e0\u6cd5\u751f\u6210\u7528\u6237\u540d\u3002", 
    "Unable to log in with provided credentials.": "\u65e0\u6cd5\u4f7f\u7528\u63d0\u4f9b\u7684\u51ed\u636e\u767b\u5f55\u3002", 
    "Unknown error: \"{error}\"": "\u672a\u77e5\u9519\u8bef\uff1a\u201c{error}\u201d", 
    "Unsupported Language": "\u4e0d\u652f\u6301\u7684\u8bed\u8a00", 
    "User account is disabled.": "\u7528\u6237\u8d26\u53f7\u5df2\u7981\u7528\u3002", 
    "User not found.": "\u627e\u4e0d\u5230\u7528\u6237\u3002", 
    "Username": "\u7528\u6237\u540d", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "\u7528\u6237\u540d\u53ea\u80fd\u4ee5\u5b57\u6bcd\u3001\u6570\u5b57\u3001\".\" \u548c \"-\" \u6784\u6210\u3002", 
    "We can help<br>Ask us anything!": "\u6211\u4eec\u53ef\u4ee5\u5e2e\u5fd9<br>\u968f\u4fbf\u95ee\u5427\uff01", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "\u5f88\u62b1\u6b49\uff0c\u4f46 BuddyUp \u4e0d\u80fd\u5728\u60a8\u7684 Firefox OS \u7248\u672c\u4e0a\u5b89\u88c5\u3002\u8bf7\u5173\u95ed\u6b64\u7a97\u53e3\u4ee5\u8fd4\u56de\u60a8\u7684\u4e3b\u5c4f\u5e55\u3002", 
    "We've sent a welcome email to:": "\u6211\u4eec\u5df2\u7ecf\u53d1\u9001\u4e00\u5c01\u6b22\u8fce\u90ae\u4ef6\u81f3\uff1a", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "\u6211\u4eec\u5df2\u5411\u60a8\u53d1\u9001\u4e00\u5c01\u7535\u5b50\u90ae\u4ef6\u3002\u53ea\u9700\u4f7f\u7528\u90ae\u4ef6\u4e2d\u94fe\u63a5\uff0c\u60a8\u5373\u53ef\u91cd\u7f6e\u60a8\u7684\u5bc6\u7801\u3002", 
    "Whoops!": "\u5594\u5662\uff01", 
    "Write your message\u2026": "\u5199\u4e0b\u60a8\u7684\u4fe1\u606f\u2026", 
    "Yay, you're almost done!": "\u5f88\u68d2\uff0c\u9a6c\u4e0a\u5c31\u5b8c\u6210\u4e86\uff01", 
    "You are not online, please check your connection.": "\u60a8\u672a\u8054\u673a\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc\u8fde\u63a5\u3002", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "\u5728\u6709\u4f19\u4f34\u524d\u6765\u5e2e\u5fd9\u65f6\uff0c\u60a8\u4f1a\u6536\u5230\u4e00\u6761\u901a\u77e5\u3002", 
    "just now": "\u521a\u521a", 
    "x hours ago": "x \u5c0f\u65f6\u524d", 
    "{n} day ago": [
      "{n} \u5929\u524d"
    ], 
    "{n} helpful vote": [
      "{n} \u4e2a\u6709\u5e2e\u52a9\u6295\u7968"
    ], 
    "{n} hour ago": [
      "{n} \u5c0f\u65f6\u524d"
    ], 
    "{n} minute ago": [
      "{n} \u5206\u949f\u524d"
    ], 
    "{n} question solved": [
      "{n} \u4e2a\u95ee\u9898\u5df2\u89e3\u51b3"
    ], 
    "{user} chose your answer as a solution": "{user} \u9009\u62e9\u4e86\u60a8\u7684\u56de\u7b54\u4f5c\u4e3a\u89e3\u51b3\u65b9\u6848", 
    "{user} left a comment on your question": "{user} \u5728\u60a8\u7684\u95ee\u9898\u4e0a\u7559\u4e0b\u4e86\u4e00\u6761\u8bc4\u8bba"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "Y\u5e74n\u6708j\u65e5 H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%Y/%m/%d %H:%M", 
      "%Y-%m-%d %H:%M", 
      "%Y\u5e74%n\u6708%j\u65e5 %H:%M", 
      "%Y/%m/%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y\u5e74%n\u6708%j\u65e5 %H:%M:%S", 
      "%Y/%m/%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y\u5e74%n\u6708%j\u65e5 %H:%n:%S.%f", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "Y\u5e74n\u6708j\u65e5", 
    "DATE_INPUT_FORMATS": [
      "%Y/%m/%d", 
      "%Y-%m-%d", 
      "%Y\u5e74%n\u6708%j\u65e5"
    ], 
    "DECIMAL_SEPARATOR": ".", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "m\u6708j\u65e5", 
    "NUMBER_GROUPING": "4", 
    "SHORT_DATETIME_FORMAT": "Y\u5e74n\u6708j\u65e5 H:i", 
    "SHORT_DATE_FORMAT": "Y\u5e74n\u6708j\u65e5", 
    "THOUSAND_SEPARATOR": "", 
    "TIME_FORMAT": "H:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M", 
      "%H:%M:%S", 
      "%H:%M:%S.%f"
    ], 
    "YEAR_MONTH_FORMAT": "Y\u5e74n\u6708"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

