

(function (globals) {

  var django = globals.django || (globals.django = {});

  
  django.pluralidx = function (n) {
    var v=0;
    if (typeof(v) == 'boolean') {
      return v ? 1 : 0;
    } else {
      return v;
    }
  };
  

  
  /* gettext library */

  django.catalog = {
    "<div {countattr}>{n}</div><div {textattr}> helpful vote</div>": [
      "<div {textattr}>\u6536\u5230</div> <div {countattr}>{n}</div> <div {textattr}>\u5f35\u6709\u5e6b\u52a9\u7684\u6295\u7968</div>"
    ], 
    "<div {countattr}>{n}</div><div {textattr}> question solved</div>": [
      "<div {textattr}>\u5df2\u89e3\u6c7a</div> <div {countattr}>{n}</div> <div {textattr}>\u500b\u554f\u984c</div>"
    ], 
    "A user with that email address already exists.": "\u5df2\u7d93\u6709\u4f7f\u7528\u96fb\u5b50\u90f5\u4ef6\u5730\u5740\u7684\u4f7f\u7528\u8005\u5b58\u5728\u3002", 
    "A user with that username exists": "\u5df2\u7d93\u6709\u4f7f\u7528\u8a72\u540d\u7a31\u7684\u4f7f\u7528\u8005\u5b58\u5728\u3002", 
    "All My Questions": "\u6211\u7684\u6240\u6709\u554f\u984c", 
    "Already registered? Sign in": "\u5df2\u7d93\u8a3b\u518a\u4e86\u55ce\uff1f\u8acb\u767b\u5165", 
    "An account lets you answer questions, track contributions and receive alerts.": "\u8a3b\u518a\u5e33\u865f\u53ef\u8b93\u60a8\u56de\u7b54\u554f\u984c\u3001\u8ffd\u8e64\u8ca2\u737b\u7d00\u9304\u4e26\u63a5\u6536\u8b66\u793a\u3002", 
    "Another helper has answered this question, please choose another.": "\u53e6\u4e00\u4f4d\u5e6b\u624b\u56de\u7b54\u4e86\u9019\u500b\u554f\u984c\uff0c\u8acb\u9078\u53e6\u4e00\u500b\u3002", 
    "Answer Questions": "\u56de\u7b54\u554f\u984c", 
    "Answer a Question": "\u56de\u7b54\u554f\u984c", 
    "Answer questions": "\u56de\u7b54\u554f\u984c", 
    "Answered Questions": "\u5df2\u56de\u7b54\u7684\u554f\u984c", 
    "Ask a Question": "\u554f\u500b\u554f\u984c", 
    "Audio/Music/FMRadio": "\u97f3\u6548 / \u97f3\u6a02\u5eab / \u6536\u97f3\u6a5f", 
    "Be aware that you will lose your history when you sign in to your account.": "\u8acb\u6ce8\u610f\uff0c\u767b\u5165\u5e33\u865f\u5f8c\u6703\u6e05\u9664\u60a8\u7684\u6b77\u53f2\u7d00\u9304\u3002", 
    "Browser/Download": "\u700f\u89bd\u5668 / \u6a94\u6848\u4e0b\u8f09", 
    "BuddyUp currently doesn't support \"<span id=\"language\"></span>\".": "BuddyUp \u76ee\u524d\u9084\u4e0d\u652f\u63f4\u300c<span id=\"language\"></span>\u300d\u3002", 
    "Camera/Gallery/Video": "\u76f8\u6a5f / \u5716\u7247\u5eab / \u5f71\u7247\u5eab", 
    "Can't change this field.": "\u7121\u6cd5\u4fee\u6539\u6b64\u6b04\u4f4d\u3002", 
    "Cancel": "\u53d6\u6d88", 
    "Cancel Sign Up": "\u53d6\u6d88\u8a3b\u518a", 
    "Cellular Data/WiFi/Bluetooth": "\u6578\u64da\u7db2\u8def / Wi-Fi / \u85cd\u7259", 
    "Choose a category": "\u9078\u64c7\u5206\u985e", 
    "Click on the link in your email to let us know that it made it to the right place. After that, return to BuddyUp and make other users happy!": "\u9ede\u64ca\u4fe1\u4e2d\u7684\u93c8\u7d50\uff0c\u8b93\u6211\u5011\u77e5\u9053\u9019\u5c01\u4fe1\u6c92\u5bc4\u4e1f\u3002\u5728\u90a3\u4e4b\u5f8c\u56de\u5230 BuddyUp\uff0c\u4e5f\u8b93\u5176\u4ed6\u4eba\u4e00\u8d77\u958b\u5fc3\u5427\uff01", 
    "Clock/Alarm": "\u6642\u9418 / \u9b27\u9234", 
    "Close": "\u95dc\u9589", 
    "Confirm Account": "\u78ba\u8a8d\u5e33\u865f", 
    "Continue": "\u7e7c\u7e8c", 
    "Create Account": "\u8a3b\u518a\u5e33\u865f", 
    "Create account or sign in": "\u8a3b\u518a\u5e33\u865f\u6216\u767b\u5165", 
    "Device": "\u88dd\u7f6e", 
    "Dialer/Contacts": "\u64a5\u865f\u7a0b\u5f0f / \u806f\u7d61\u4eba", 
    "Don't have an account? Register": "\u6c92\u6709\u5e33\u865f\u55ce\uff1f\u8acb\u8a3b\u518a", 
    "Done": "\u5b8c\u6210", 
    "Email Address": "\u96fb\u5b50\u90f5\u4ef6\u5730\u5740", 
    "Email/Calendar": "\u96fb\u5b50\u90f5\u4ef6 / \u884c\u4e8b\u66c6", 
    "Failed": "\u5931\u6557", 
    "Forgot your password?": "\u5fd8\u8a18\u5bc6\u78bc\u4e86\u55ce\uff1f", 
    "Forgot your password? Don't worry. Enter your username below and we'll send you instructions for setting a new one.": "\u5fd8\u8a18\u5bc6\u78bc\u4e86\u55ce\uff1f\u5225\u64d4\u5fc3\u3002\u8acb\u5728\u4e0b\u65b9\u8f38\u5165\u5e33\u865f\uff0c\u6211\u5011\u6703\u5bc4\u91cd\u8a2d\u5bc6\u78bc\u7684\u6559\u5b78\u7d66\u60a8\u3002", 
    "Get a Buddy to help you with your device": "\u627e\u500b\u597d\u5925\u4f34\u5e6b\u60a8\u89e3\u6c7a\u88dd\u7f6e\u7684\u554f\u984c", 
    "Go to the New tab to answer some questions. We'll keep track of them here.": "\u524d\u5f80\u65b0\u554f\u984c\u5206\u9801\u56de\u7b54\u554f\u984c\uff0c\u6211\u5011\u6703\u5728\u9019\u908a\u8a18\u9304\u3002", 
    "Has your question been solved?": "\u60a8\u7684\u554f\u984c\u89e3\u6c7a\u4e86\u55ce\uff1f", 
    "Have Answers?": "\u6709\u7b54\u6848\u55ce\uff1f", 
    "Have Questions?": "\u6709\u554f\u984c\u55ce\uff1f", 
    "Help Article": "\u8aaa\u660e\u6587\u4ef6", 
    "Help other users around the world": "\u5e6b\u52a9\u4e16\u754c\u4e0a\u7684\u5176\u4ed6\u4f7f\u7528\u8005", 
    "Incompatible version": "\u4e0d\u76f8\u5bb9\u7684\u7248\u672c", 
    "Keyboard": "\u9375\u76e4", 
    "Language": "\u8a9e\u8a00", 
    "Last sync:": "\u6700\u8fd1\u540c\u6b65:", 
    "Load more": "\u8f09\u5165\u66f4\u591a", 
    "Maps/GPS": "\u5730\u5716 / GPS", 
    "Marketplace/Apps Install": "Marketplace / \u5b89\u88dd\u61c9\u7528\u7a0b\u5f0f", 
    "My Profile": "\u6211\u7684\u500b\u4eba\u8cc7\u6599", 
    "My Question": "\u6211\u7684\u554f\u984c", 
    "My Questions": "\u6211\u7684\u554f\u984c", 
    "My list": "\u6211\u7684\u6e05\u55ae", 
    "My preferences": "\u6211\u7684\u504f\u597d\u8a2d\u5b9a", 
    "New": "\u65b0\u554f\u984c", 
    "No active questions": "\u6c92\u6709\u554f\u984c\u4e86", 
    "No matching user setting found.": "\u627e\u4e0d\u5230\u7b26\u5408\u7684\u4f7f\u7528\u8005\u9078\u9805\u3002", 
    "No questions": "\u6c92\u6709\u554f\u984c", 
    "OK": "\u78ba\u5b9a", 
    "Ok": "\u78ba\u5b9a", 
    "Operator": "\u96fb\u4fe1\u696d\u8005", 
    "Other": "\u5176\u4ed6", 
    "Password": "\u5bc6\u78bc", 
    "Performance": "\u6548\u80fd", 
    "Please ask your questions in English, or go to <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> for more help.": "\u8acb\u7528\u82f1\u6587\u56de\u7b54\u60a8\u7684\u554f\u984c\uff0c\u6216\u5230  <a href=\"http://support.mozilla.org\">http://support.mozilla.org</a> \u53d6\u5f97\u66f4\u591a\u5e6b\u52a9\u3002", 
    "Previously Answered": "\u5148\u524d\u56de\u7b54\u7684", 
    "Quit": "\u96e2\u958b", 
    "Reset Password": "\u91cd\u8a2d\u5bc6\u78bc", 
    "SMS/MMS": "\u7c21\u8a0a / \u591a\u5a92\u9ad4\u8a0a\u606f", 
    "Sending\u2026": "\u50b3\u9001\u4e2d\u2026", 
    "Settings": "\u9078\u9805", 
    "Sign In": "\u767b\u5165", 
    "Sign in to answer questions from Firefox OS users.": "\u8acb\u767b\u5165\u4ee5\u56de\u7b54 Firefox OS \u4f7f\u7528\u8005\u7684\u554f\u984c\u3002", 
    "Sign in to answer questions from the Mozilla community.": "\u8acb\u767b\u5165\u4ee5\u56de\u7b54\u4f86\u81ea Mozilla \u793e\u7fa4\u7684\u554f\u984c\u3002", 
    "Sign in to reply": "\u767b\u5165\u4ee5\u56de\u61c9", 
    "Solution \u2713": "\u2713 \u89e3\u6c7a\u65b9\u5f0f", 
    "Storage/SD card": "\u5132\u5b58\u7a7a\u9593 / SD \u5361", 
    "Support": "\u6280\u8853\u652f\u63f4", 
    "System Updates": "\u7cfb\u7d71\u66f4\u65b0", 
    "Thank you for your question!": "\u611f\u8b1d\u60a8\u63d0\u51fa\u554f\u984c\uff01", 
    "There was a problem with Buddy Up, please try again.": "Buddy Up \u6709\u9ede\u554f\u984c\uff0c\u8acb\u518d\u8a66\u4e00\u6b21\u3002", 
    "This field is required.": "\u6b64\u6b04\u4f4d\u5fc5\u586b\u3002", 
    "This solved my question": "\u9019\u500b\u65b9\u5f0f\u89e3\u6c7a\u4e86\u6211\u7684\u554f\u984c", 
    "This will close the question and let your buddy know you no longer need help.": "\u5c07\u6703\u95dc\u9589\u554f\u984c\uff0c\u8b93\u60a8\u7684\u5925\u4f34\u77e5\u9053\u60a8\u4e0d\u9700\u8981\u5e6b\u5fd9\u4e86\u3002", 
    "Too many questions? Use the settings below to narrow down the \"Answer a Question\" list.": "\u592a\u591a\u554f\u984c\u4e86\u55ce\uff1f\u8acb\u7528\u4e0b\u65b9\u7684\u9078\u9805\u7be9\u9078\u300c\u56de\u7b54\u554f\u984c\u300d\u6e05\u55ae\u3002", 
    "Top Helpers this Week": "\u672c\u5468\u7684\u6700\u4f73\u5e6b\u624b", 
    "Unable to generate username.": "\u7121\u6cd5\u7522\u751f\u4f7f\u7528\u8005\u540d\u7a31\u3002", 
    "Unknown error: \"{error}\"": "\u672a\u77e5\u932f\u8aa4:\u300c{error}\u300d", 
    "Unsupported Language": "\u4e0d\u652f\u63f4\u7684\u8a9e\u8a00", 
    "User not found.": "\u627e\u4e0d\u5230\u4f7f\u7528\u8005\u3002", 
    "Username": "\u4f7f\u7528\u8005\u540d\u7a31", 
    "Usernames may only be letters, numbers, \".\" and \"-\".": "\u4f7f\u7528\u8005\u540d\u7a31\u50c5\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6578\u5b57\u3001. \u8207 - \u7b49\u7b26\u865f\u3002", 
    "We can help<br>Ask us anything!": "\u6211\u5011\u53ef\u4ee5\u5e6b\u5fd9<br>\u5feb\u4f86\u554f\uff01", 
    "We're sorry, but BuddyUp can't be installed on your version of Firefox OS. Please close this window to return to your home screen.": "\u5f88\u62b1\u6b49\uff0cBuddyUp \u7121\u6cd5\u5b89\u88dd\u81f3\u60a8\u76ee\u524d\u7248\u672c\u7684 Firefox OS\u3002\u8acb\u95dc\u9589\u6b64\u8996\u7a97\uff0c\u56de\u5230\u4e3b\u756b\u9762\u3002", 
    "We've sent a welcome email to:": "\u6211\u5011\u5df2\u5bc4\u51fa\u6b61\u8fce\u4fe1\u5230:", 
    "We've sent you an email. Just follow the link in the email to reset your password.": "\u6211\u5011\u5df2\u5bc4\u4fe1\u7d66\u60a8\uff0c\u8acb\u8ddf\u8457\u4fe1\u4e2d\u7684\u93c8\u7d50\u4f86\u91cd\u8a2d\u5bc6\u78bc\u3002", 
    "Whoops!": "\u5594\u5594\uff01", 
    "Write your message\u2026": "\u64b0\u5beb\u60a8\u7684\u8a0a\u606f\u2026", 
    "Yay, you're almost done!": "\u8036\uff0c\u60a8\u5feb\u5b8c\u6210\u4e86\uff01", 
    "You are not online, please check your connection.": "\u60a8\u4e0d\u5728\u7dda\u4e0a\uff0c\u8acb\u6aa2\u67e5\u9023\u7dda\u3002", 
    "You'll get a notification as soon as a Buddy jumps in to the rescue.": "\u7576\u6709\u5925\u4f34\u8df3\u9032\u4f86\u5e6b\u5fd9\u7684\u6642\u5019\u60a8\u5c31\u6703\u6536\u5230\u901a\u77e5\u3002", 
    "just now": "\u525b\u525b", 
    "x hours ago": "x \u5c0f\u6642\u524d", 
    "{n} day ago": [
      "{n} \u5929\u524d"
    ], 
    "{n} helpful vote": [
      "\u6536\u5230 {n} \u5f35\u6709\u5e6b\u52a9\u7684\u6295\u7968"
    ], 
    "{n} hour ago": [
      "{n} \u5c0f\u6642\u524d"
    ], 
    "{n} minute ago": [
      "{n} \u5206\u9418\u524d"
    ], 
    "{n} question solved": [
      "\u5df2\u89e3\u6c7a {n} \u500b\u554f\u984c"
    ], 
    "{user} chose your answer as a solution": "{user} \u5c07\u60a8\u7684\u7b54\u6848\u9078\u70ba\u89e3\u6c7a\u65b9\u5f0f", 
    "{user} left a comment on your question": "{user} \u5c0d\u60a8\u7684\u554f\u984c\u7559\u8a00"
  };

  django.gettext = function (msgid) {
    var value = django.catalog[msgid];
    if (typeof(value) == 'undefined') {
      return msgid;
    } else {
      return (typeof(value) == 'string') ? value : value[0];
    }
  };

  django.ngettext = function (singular, plural, count) {
    var value = django.catalog[singular];
    if (typeof(value) == 'undefined') {
      return (count == 1) ? singular : plural;
    } else {
      return value[django.pluralidx(count)];
    }
  };

  django.gettext_noop = function (msgid) { return msgid; };

  django.pgettext = function (context, msgid) {
    var value = django.gettext(context + '\x04' + msgid);
    if (value.indexOf('\x04') != -1) {
      value = msgid;
    }
    return value;
  };

  django.npgettext = function (context, singular, plural, count) {
    var value = django.ngettext(context + '\x04' + singular, context + '\x04' + plural, count);
    if (value.indexOf('\x04') != -1) {
      value = django.ngettext(singular, plural, count);
    }
    return value;
  };
  

  django.interpolate = function (fmt, obj, named) {
    if (named) {
      return fmt.replace(/%\(\w+\)s/g, function(match){return String(obj[match.slice(2,-2)])});
    } else {
      return fmt.replace(/%s/g, function(match){return String(obj.shift())});
    }
  };


  /* formatting library */

  django.formats = {
    "DATETIME_FORMAT": "Y\u5e74n\u6708j\u65e5 H:i", 
    "DATETIME_INPUT_FORMATS": [
      "%Y/%m/%d %H:%M", 
      "%Y-%m-%d %H:%M", 
      "%Y\u5e74%n\u6708%j\u65e5 %H:%M", 
      "%Y/%m/%d %H:%M:%S", 
      "%Y-%m-%d %H:%M:%S", 
      "%Y\u5e74%n\u6708%j\u65e5 %H:%M:%S", 
      "%Y/%m/%d %H:%M:%S.%f", 
      "%Y-%m-%d %H:%M:%S.%f", 
      "%Y\u5e74%n\u6708%j\u65e5 %H:%n:%S.%f", 
      "%Y-%m-%d"
    ], 
    "DATE_FORMAT": "Y\u5e74n\u6708j\u65e5", 
    "DATE_INPUT_FORMATS": [
      "%Y/%m/%d", 
      "%Y-%m-%d", 
      "%Y\u5e74%n\u6708%j\u65e5"
    ], 
    "DECIMAL_SEPARATOR": ".", 
    "FIRST_DAY_OF_WEEK": "1", 
    "MONTH_DAY_FORMAT": "m\u6708j\u65e5", 
    "NUMBER_GROUPING": "4", 
    "SHORT_DATETIME_FORMAT": "Y\u5e74n\u6708j\u65e5 H:i", 
    "SHORT_DATE_FORMAT": "Y\u5e74n\u6708j\u65e5", 
    "THOUSAND_SEPARATOR": "", 
    "TIME_FORMAT": "H:i", 
    "TIME_INPUT_FORMATS": [
      "%H:%M", 
      "%H:%M:%S", 
      "%H:%M:%S.%f"
    ], 
    "YEAR_MONTH_FORMAT": "Y\u5e74n\u6708"
  };

  django.get_format = function (format_type) {
    var value = django.formats[format_type];
    if (typeof(value) == 'undefined') {
      return format_type;
    } else {
      return value;
    }
  };

  /* add to global namespace */
  globals.pluralidx = django.pluralidx;
  globals.gettext = django.gettext;
  globals.ngettext = django.ngettext;
  globals.gettext_noop = django.gettext_noop;
  globals.pgettext = django.pgettext;
  globals.npgettext = django.npgettext;
  globals.interpolate = django.interpolate;
  globals.get_format = django.get_format;

}(this));

