﻿ig.module(
	'game.entities.boss-iPad'
)
.requires(
	'impact.entity',
	'impact.timer'
)
.defines(function(){

EntityBossIPad = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 50, y:46},
	offset: {x:4, y:4},
	maxVel: {x: 128, y: 128},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/boss-iPad.png', 58, 56 ),	
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 3000,
	flip: false,
	count: 50,
	dx:0,
	dy:0,
	isKill:false,
	
	timer: new ig.Timer(),
	
	//i add-khi
	directionIsLeft: false,	//if true,move right to left,else left to right
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim('leftshot',0.1,[0]);
		this.addAnim( 'rightshot', 0.1, [1] );
		this.addAnim( 'none', 0.1, [2] );
		this.addAnim( 'die', 0.1, [3] );
//		this.addAnim( 'none', 0.1, [3] );
		
	},
	draw: function() {
		this.parent();
		
		if(this.health<=0) {
			var font=new ig.Font('media/font-iPad.png');
			font.draw('WELL DONE!', 350,216,ig.Font.ALIGN.CENTER);
			font.draw('BUGGY MASTER.', 350,304,ig.Font.ALIGN.CENTER);
			
		}
	},
	update: function() {	
		// move left or right
		// shoot
		
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		// move!
		
		if(this.pos.x<60) {
			this.pos.x=60;
			this.directionIsLeft=false;
		}else if(this.pos.x>560) {
			this.pos.x=560;
			this.directionIsLeft=true;
		}
		
		if(this.directionIsLeft)
			this.pos.x-=6;
		else
			this.pos.x+=6;
		
		if(Math.abs(this.dy)<881&&this.health>0) {	
			this.count--;
		if(this.count==0){
			this.count=10;
			this.currentAnim = this.anims.rightshot;		
			this.currentAnim.flip.x = this.flip;
			ig.game.spawnEntity( EntityHitIPad, this.pos.x, this.pos.y+52, {flip:this.flip} );
			ig.game.spawnEntity( EntityEnemyBullet2IPad, this.pos.x+6, this.pos.y+58, {flip:this.flip} );
	//		ig.game.spawnEntity( EntityBulletIPad, this.pos.x+48, this.pos.y, {flip:this.flip} );
		//	ig.game.spawnEntity( EntityBulletIPad, this.pos.x+48, this.pos.y-28, {flip:this.flip} );		
		}else if(this.count==2){
			this.currentAnim = this.anims.leftshot;		
			this.currentAnim.flip.x = this.flip;
			ig.game.spawnEntity( EntityHitIPad, this.pos.x+40, this.pos.y+52, {flip:this.flip} );
			ig.game.spawnEntity( EntityEnemyBullet2IPad, this.pos.x+52, this.pos.y+58, {flip:this.flip} );		
		}
		}
//		this.currentAnim = this.anims.idle;		
	//	this.currentAnim.flip.x = this.flip;
		if(this.health<=0) {
			this.currentAnim = this.anims.none;		
			this.currentAnim.flip.x = this.flip;
		}
		this.parent();

	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
	//	this.kill();
	},
	
	kill: function() {
	//	alert("Target zone, Level completed.");
		
			
		if(this.isKill == false) {			
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-20, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+20, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+40, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y+40, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+40, this.last.y+40, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-40, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-40, this.last.y-40, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y-40, {flip:this.flip} );
			this.isKill = true;
			ig.game.score+=10000;
			
			this.timer.set(1);
		} else {
			if(this.timer.delta() > 0) 	
			{	this.parent();
				ig.game.winLevel7=true;					
			}
			
		}
	}
});
});