﻿ig.module(
	'game.entities.bosshelicopter'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityBosshelicopter = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 48, y:44},
	offset: {x:2,y:2},
	maxVel: {x: 32, y: 32},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/helicopter.png', 52, 52 ),	
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 4000,
	flip: false,
	count: 60,
	dx:0,
	dy:0,
	first: true,
	timer: new ig.Timer(),
	isKill: false,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim('shooting',0.01,[0,1]);
		this.addAnim( 'die', 0.1, [2] );
		this.addAnim( 'none', 0.1, [2] );
	},
	
	update: function() {				
		// move left or right
		// shoot
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		
		if(this.first) {
			;
		}else{	
			if(this.count>35)
				this.pos.x-=5;
			else
				this.pos.x+=5;
		}
		if(Math.abs(this.dy)<400 &&this.health>0) {	
			this.count--;
			if( this.count==55 &&Math.abs(this.dy)<400) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==50&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==45&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==40&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==35&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==30&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==25&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==20&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==15 &&Math.abs(this.dy)<400) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==10&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if( this.count==5&&Math.abs(this.dy)<400 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityHit, this.pos.x+41, this.pos.y+20,{flip:this.flip} );
				
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+26, this.pos.y+50, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+10, this.pos.y+20, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBullet, this.pos.x+41, this.pos.y+20, {flip:this.flip} );
			}else if(this.count==0) {
				this.count=70
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
			}else {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
			}
			this.first=false;
		}
		this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
		if(this.health<=0) {
			this.currentAnim = this.anims.none;		
			this.currentAnim.flip.x = this.flip;
		}
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 300, this );
	//	this.kill();
	},
	draw: function() {
		this.parent();		
		if(this.health<=0) {
			var font=new ig.Font('media/font.png');
			font.draw('BOSS', 100,100,ig.Font.ALIGN.CENTER);
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-40, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+40, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-40, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y-10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-30, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y-30, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-30, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y-30, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+30, this.last.y-20, {flip:this.flip} );
		}
	},
	
	kill: function() {
		
		if(this.isKill == false) {	
			
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y-10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-10, this.last.y-10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+20, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y-20, {flip:this.flip} );
			
			
			this.isKill = true;
			ig.game.score+=3000;
			this.parent();
			ig.game.spawnEntity( EntityBoss, this.last.x, this.last.y, {flip:this.flip} );		
		} else {
			
			if(this.timer.delta() > 0) 
			{	//ig.game.winLevel7=true;
								
			}			
		}
	}
});
});