﻿ig.module(
	'game.entities.bossjeep-iPad'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityBossjeepIPad = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to this.move the collision box a bit (offset)
	size: {x: 32, y:66},
	offset:{x:4,y:4},
	maxVel: {x: 64, y: 64},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/img17a0-iPad.png', 48, 78 ),	
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 3500,
	flip: false,
	count: 50,
	dx:0,
	dy:0,
	timer: new ig.Timer(),
	isKill: false,
	move: true,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'shooting', 0.1, [0] );
		this.addAnim( 'none', 0.1, [1] );
		this.addAnim( 'die', 0.1, [2] );
	},	
	draw: function() {
		this.parent();		
		if(this.health<=0) {
			var font=new ig.Font('media/font-iPad.png');
			font.draw('LEVEL 4 COMPLETED', 350,210,ig.Font.ALIGN.CENTER);
			
			
		}
	},
	
	update: function() {				
		// this.move left or right
		// shoot
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		// this.move!
		

		if(Math.abs(this.dy)<881) {
			if(this.move){
						this.vel.y =-1000;
						this.vel.x =2000;
					}
			else {
				this.vel.y=1020;
				this.vel.x =-2000;
			}
			this.count--;
			if( this.count > 0 && this.count < 51 && this.count % 5 == 0 && Math.abs(this.dy)<1024) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHitIPad, this.pos.x+16, this.pos.y+60, {flip:this.flip} );
				ig.game.spawnEntity( EntityJeepBulletIPad, this.pos.x+16, this.pos.y+60, {flip:this.flip} );
				if (this.count % 10 == 0)
					this.move=!this.move;
			}else if(this.count==0) {
				this.count=65;
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				
			}else {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
			}
		}
		this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				
			
		if(this.health<=0) {
			this.currentAnim = this.anims.none;		
			this.currentAnim.flip.x = this.flip;
		}
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
	//	this.kill();
	},
	
	kill: function() {
		if(this.isKill == false) {			
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-20, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+20, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+40, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y+40, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x+40, this.last.y+40, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-40, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x-40, this.last.y-40, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y-40, {flip:this.flip} );
			this.isKill = true;
			ig.game.score+=2000;
			
			this.timer.set(2);
		} else {
			
			if(this.timer.delta() > 0) 
			{	ig.game.winLevel4=true;
				this.parent();				
			}			
		}
	}
});


EntityJeepBulletIPad = ig.Entity.extend({
	size: {x: 20, y: 18},
//	offset: {x: 2, y: 2},
	maxVel: {x: 0, y: 200},	
	
	// The fraction of force with which this entity bounces back in collisions
//	bounciness: 0.6, 	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.NEVER,		
	animSheet: new ig.AnimationSheet( 'media/gfx/img8a0-iPad.png', 20, 18 ),
	dx:0,
	dy:0,
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.vel.x -= 20;
		this.vel.y += 400;
		this.addAnim( 'shot', 0.1, [0] );
		
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
	},
		
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
				this.kill();
		}
		this.parent( res );
	},
	
	// This function is called when this entity overlaps anonther entity of the
	// checkAgainst group. I.e. for this entity, all entities in the B group.
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			ig.game.spawnEntity( EntityHitIPad, this.last.x, this.last.y, {flip:this.flip} );
			this.kill();
			return;
		}	
		ig.game.spawnEntity( EntityHitIPad, this.last.x, this.last.y, {flip:this.flip} );
		other.receiveDamage( 100, this );
		this.kill();
	},
	update: function() {
		if(this.dy>0&&Math.abs(this.dy)<900) {
			if(this.dx<0) {
				this.pos.y+=Math.random()*20;
				this.pos.x-=Math.random()*20;
			}else {
				this.pos.y+=Math.random()*20;
				this.pos.x+=Math.random()*20;
			}
		}
		this.parent();
	}
});
});