﻿ig.module(
	'game.entities.bosstank'
)
.requires(
	'impact.entity',
	'impact.timer'
)
.defines(function(){

EntityBosstank = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 55, y:40},
	offset:{x:2,y:4},
	maxVel: {x: 32, y: 32},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/boss_tank.png', 61, 46 ),	
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 3200,
	flip: false,
	count: 50,
	dx:0,
	dy:0,
	isKill:false,
	
	timer: new ig.Timer(),
	
	//i add-khi
	directionIsLeft: false,	//if true,move right to left,else left to right
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim('idle',0.1,[0]);
		this.addAnim( 'shooting', 0.1, [1] );
		this.addAnim( 'die', 0.1, [2] );
		this.addAnim( 'none', 0.1, [3] );
		
	},
	draw: function() {
		this.parent();
		if(this.health==1000)
		{
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y-20, {flip:this.flip} );
		}
		if(this.health<=0) {
			var font=new ig.Font('media/font.png');
			font.draw('LEVEL 2 COMPLETED', 100,100);
			
		}
	},
	update: function() {	
		// move left or right
		// shoot
		
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		// move!
		
		if(this.pos.x<0) {
			this.pos.x=0;
			this.directionIsLeft=false;
		}else if(this.pos.x>320-61) {
			this.pos.x=320-61;
			this.directionIsLeft=true;
		}
		
		if(this.directionIsLeft)
			this.pos.x-=4;
		else
			this.pos.x+=4;
		
		if(Math.abs(this.dy)<480 &&this.health>1000) {	
			this.count--;
			if( this.count==50 &&Math.abs(this.dy)<350) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==45&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==40&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==35&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==30&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==25&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==20 &&Math.abs(this.dy)<350) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==15&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==10&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if( this.count==5&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x+27, this.pos.y+44, {flip:this.flip} );
			}else if(this.count==0) {
				this.count=65;
				this.currentAnim = this.anims.idle;		
				this.currentAnim.flip.x = this.flip;
			}else {
				this.currentAnim = this.anims.idle;		
				this.currentAnim.flip.x = this.flip;
			}
		}
//		this.currentAnim = this.anims.idle;		
	//	this.currentAnim.flip.x = this.flip;
		if(this.health<1000&&this.health>0) {
			this.currentAnim = this.anims.die;		
			this.currentAnim.flip.x = this.flip;
			this.vel.x=0;
			this.pos.x=this.last.x;
		}if(this.health<=0) {
			this.currentAnim = this.anims.none;		
			this.currentAnim.flip.x = this.flip;
		}
		this.parent();

	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
	//	this.kill();
	},
	
	kill: function() {
	//	alert("Target zone, Level completed.");
		
			
		if(this.isKill == false) {			
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y-10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-10, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-10, this.last.y-10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+10, this.last.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x+20, this.last.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x-20, this.last.y-20, {flip:this.flip} );
			ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y-20, {flip:this.flip} );
			this.isKill = true;
			ig.game.score+=1000;
			this.timer.set(2);
		} else {
			
			if(this.timer.delta() > 0) 
			{	ig.game.winLevel2=true;
				this.parent();				
			}
			
		}
	}
});
});