﻿// JavaScript Document
ig.module(
	'game.entities.burst'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityBurst = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 19, y:34},
	maxVel: {x: 0, y: 0},
	type: ig.Entity.TYPE.NONE, // Player friendly group
	checkAgainst: ig.Entity.TYPE.NONE,
	collides: ig.Entity.COLLIDES.NEVER,	
	animSheet: new ig.AnimationSheet( 'media/gfx/burst.png', 19, 34 ),		
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 0,
	flip: false,
	count: 5,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'burst', 0.1, [0,1,2,3] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
				this.kill();
		}
		this.parent( res );
	},	
	
	update: function() {	
		// shoot
	//	this.count--;
		this.currentAnim = this.anims.burst;		
		this.currentAnim.flip.x = this.flip;
		// move!
		this.parent();
		if(--this.count<0)
			this.kill();
	},
	kill: function() {
		this.parent();
	}
});
});