﻿// JavaScript Document
ig.module(
	'game.entities.enemy-iPad'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityEnemyIPad = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 28, y:32},
	offset: {x:4,y:4},
	maxVel: {x: 60, y: 60},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/enemy-iPad.png', 36, 40 ),	
	health: 100,
	flip: false,
	count: 40,
	dx:0,
	dy:0,
	shot: false,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'walking', 0.1, [0,1] );
		this.addAnim( 'shooting', 0.1, [2] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
			this.dx=ig.game.player_position.x-this.pos.x;
			this.dy=ig.game.player_position.y-this.pos.y;
		}
		this.parent( res );
	},	
	
	update: function() {
		// shoot
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		if(Math.abs(this.dy)<920) {
		this.count--;
		if( this.count==0 ) {
			this.count=60;
			this.currentAnim = this.anims.shooting;		
			this.currentAnim.flip.x = this.flip;
			ig.game.spawnEntity( EntityHitIPad, this.pos.x-6, this.pos.y+20, {flip:this.flip} );
			ig.game.spawnEntity( EntityEnemyBulletIPad, this.pos.x, this.pos.y+10, {flip:this.flip} );
		}	}	
		this.currentAnim = this.anims.walking;		
		this.currentAnim.flip.x = this.flip;
		// move!
		
		
		this.shot=!this.shot;
		
		if(this.dy>0&&Math.abs(this.dy)<920&&this.shot) {
			if(this.dx<0) {
				this.vel.y+=2;
				this.vel.x-=2;
			}else {
				this.vel.y+=2;
				this.vel.x+=2;
			}
		}
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
		this.kill();
	},
	kill: function() {
		ig.game.spawnEntity( EntityKillenemyIPad, this.last.x, this.last.y, {flip:this.flip} );
	//	ig.game.spawnEntity( EntityBurstIPad, this.pos.x, this.pos.y, {flip:this.flip} );
		ig.game.score+=300;
		this.parent();
	}
});



EntityEnemyBulletIPad = ig.Entity.extend({
	size: {x: 10, y: 10},
//	offset: {x: 4, y: 4},
	maxVel: {x: 0, y: 200},	
	
	// The fraction of force with which this entity bounces back in collisions
//	bounciness: 0.6, 	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.NEVER,		
	animSheet: new ig.AnimationSheet( 'media/gfx/img8a0-iPad.png', 20, 18 ),
	dx:0,
	dy:0,
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.vel.x -= 20;
		this.vel.y += 400;
		this.addAnim( 'shot', 0.1, [0] );
		
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
	},
		
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
				this.kill();
		}
		this.parent( res );
	},
	
	// This function is called when this entity overlaps anonther entity of the
	// checkAgainst group. I.e. for this entity, all entities in the B group.
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			ig.game.spawnEntity( EntityHitIPad, this.last.x, this.last.y, {flip:this.flip} );
			this.kill();
			return;
		}	
		ig.game.spawnEntity( EntityHitIPad, this.last.x, this.last.y, {flip:this.flip} );
		other.receiveDamage( 100, this );
		this.kill();
	},
	update: function() {
		if(this.dy>0&&Math.abs(this.dy)<920) {
			if(this.dx<0) {
				this.pos.y+=4;
				this.pos.x-=4;
			}else {
				this.pos.y+=4;
				this.pos.x+=4;
			}
		}
		this.parent();
	}
});

});