﻿// JavaScript Document
ig.module(
	'game.entities.enemy'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityEnemy = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 14, y:16},
	offset: {x:2,y:2},
	maxVel: {x: 30, y: 30},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/enemy.png', 18, 20 ),	
	health: 100,
	flip: false,
	count: 40,
	dx:0,
	dy:0,
	shot: false,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'walking', 0.1, [0,1] );
		this.addAnim( 'shooting', 0.1, [2] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
			this.dx=ig.game.player_position.x-this.pos.x;
			this.dy=ig.game.player_position.y-this.pos.y;
		}
		this.parent( res );
	},	
	
	update: function() {
		// shoot
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		if(Math.abs(this.dy)<350) {
		this.count--;
		if( this.count==0 ) {
			this.count=60;
			this.currentAnim = this.anims.shooting;		
			this.currentAnim.flip.x = this.flip;
			ig.game.spawnEntity( EntityHit, this.pos.x-3, this.pos.y+10, {flip:this.flip} );
			ig.game.spawnEntity( EntityEnemyBullet, this.pos.x, this.pos.y+5, {flip:this.flip} );
		}	}	
		this.currentAnim = this.anims.walking;		
		this.currentAnim.flip.x = this.flip;
		// move!
		
		
		this.shot=!this.shot;
		
		if(this.dy>0&&Math.abs(this.dy)<350&&this.shot) {
			if(this.dx<0) {
				this.vel.y++;
				this.vel.x--;
			}else {
				this.vel.y++;
				this.vel.x++;
			}
		}
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
		this.kill();
	},
	kill: function() {
		ig.game.spawnEntity( EntityKillenemy, this.last.x, this.last.y, {flip:this.flip} );
	//	ig.game.spawnEntity( EntityBurst, this.pos.x, this.pos.y, {flip:this.flip} );
		ig.game.score+=300;
		this.parent();
	}
});



EntityEnemyBullet = ig.Entity.extend({
	size: {x: 5, y: 5},
//	offset: {x: 2, y: 2},
	maxVel: {x: 0, y: 100},	
	
	// The fraction of force with which this entity bounces back in collisions
//	bounciness: 0.6, 	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.NEVER,		
	animSheet: new ig.AnimationSheet( 'media/gfx/img8a0.png', 10, 9 ),
	dx:0,
	dy:0,
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.vel.x -= 10;
		this.vel.y += 200;
		this.addAnim( 'shot', 0.1, [0] );
		
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
	},
		
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
				this.kill();
		}
		this.parent( res );
	},
	
	// This function is called when this entity overlaps anonther entity of the
	// checkAgainst group. I.e. for this entity, all entities in the B group.
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			ig.game.spawnEntity( EntityHit, this.last.x, this.last.y, {flip:this.flip} );
			this.kill();
			return;
		}	
		ig.game.spawnEntity( EntityHit, this.last.x, this.last.y, {flip:this.flip} );
		other.receiveDamage( 100, this );
		this.kill();
	},
	update: function() {
		if(this.dy>0&&Math.abs(this.dy)<350) {
			if(this.dx<0) {
				this.pos.y+=2;
				this.pos.x-=2;
			}else {
				this.pos.y+=2;
				this.pos.x+=2;
			}
		}
		this.parent();
	}
});

});