﻿// JavaScript Document
ig.module(
	'game.entities.enemy2-iPad'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityEnemy2IPad = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 28, y:32},
	offset: {x:4,y:4},
	maxVel: {x: 64, y: 64},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/enemy_2-iPad.png', 36, 40 ),		
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 300,
	flip: false,
	count: 45,
	dx:0,
	dy:0,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'shooting', 0.1, [1,1,1] );
		this.addAnim( 'walking', 0.1, [0,1] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
			this.dx=ig.game.player_position.x-this.pos.x;
			this.dy=ig.game.player_position.y-this.pos.y;
		}
		
		this.parent( res );
	},	
	
	update: function() {
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		
		// shoot
		
		
		if(Math.abs(this.dy)<920) {
			if(this.count<40)
				this.vel.y+=10;
			else 
				this.vel.y-=10;
			this.count--;
			if( this.count > 0 && this.count <=25 && this.count %5 == 0 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHitIPad, this.pos.x-2, this.pos.y+22, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2IPad, this.pos.x, this.pos.y+22, {flip:this.flip} );
			}else if(this.count==0) {
				this.count=70
			}else {
				this.currentAnim = this.anims.walking;		
				this.currentAnim.flip.x = this.flip;
			}
		}
		this.currentAnim = this.anims.walking;		
				this.currentAnim.flip.x = this.flip;
		// move!
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
		this.kill();
	},
	kill: function() {
		ig.game.spawnEntity( EntityKillenemyIPad, this.last.x, this.last.y, {flip:this.flip} );
		ig.game.score+=300;
		this.parent();
	}
});

EntityEnemyBullet2IPad = ig.Entity.extend({
	size: {x: 10, y: 16},
//	offset: {x: 4, y: 4},
	maxVel: {x: 0, y: 200},	
	// The fraction of force with which this entity bounces back in collisions
//	bounciness: 0.6, 	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.NEVER,		
	animSheet: new ig.AnimationSheet( 'media/gfx/img12a0-iPad.png', 20, 26 ),	
	dx:0,
	dy:0,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.vel.x -= 20;
		this.vel.y += 600;
		this.addAnim( 'shot', 0.1, [0] );
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
	},
		
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
		ig.game.spawnEntity( EntityHitIPad, this.last.x, this.last.y, {flip:this.flip} );
				this.kill();
		}
		this.parent( res );
	},

	
	// This function is called when this entity overlaps anonther entity of the
	// checkAgainst group. I.e. for this entity, all entities in the B group.
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			ig.game.spawnEntity( EntityHitIPad, this.last.x, this.last.y, {flip:this.flip} );
			this.kill();
			return;
		}		
		ig.game.spawnEntity( EntityHitIPad, this.last.x, this.last.y, {flip:this.flip} );
		other.receiveDamage( 100, this );
		this.kill();
	}	,
	update: function() {
		this.pos.y+=4;
		// if(this.dy>0&&Math.abs(this.dy)<350) {
			// if(this.dx<0) {
				// this.pos.y++;
				// this.pos.x--;
			// }else {
				// this.pos.y++;
				// this.pos.x++;
			// }
		// }
		this.parent();
	}
});

});