﻿// JavaScript Document
ig.module(
	'game.entities.enemy3-iPad'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityEnemy3IPad = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 56, y:44},
	offset:{x:4,y:4},
	maxVel: {x: 64, y: 64},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.PASSIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/enemy_3-iPad.png', 64, 52 ),		
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 500,
	flip: false,
	count: 45,
	dx:0,
	dy:0,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'idle', 0.1, [0] );
		this.addAnim( 'shooting', 0.1, [1] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
			this.kill();
		}
		
		this.parent( res );
	},	
	
	update: function() {
		// shoot
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		if(Math.abs(this.dy)<920) {
			this.count--;
			
			if( this.count==20 &&Math.abs(this.dy)<350) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityEnemyBulletIPad, this.pos.x+18, this.pos.y+28, {flip:this.flip} );
			}else if( this.count==15 &&Math.abs(this.dy)<350) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityEnemyBulletIPad, this.pos.x+18, this.pos.y+28, {flip:this.flip} );
			}else if( this.count==10 &&Math.abs(this.dy)<350) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityEnemyBulletIPad, this.pos.x+18, this.pos.y+28, {flip:this.flip} );
			}else if( this.count==5&&Math.abs(this.dy)<350 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityEnemyBulletIPad, this.pos.x+18, this.pos.y+28, {flip:this.flip} );
			}else if(this.count==0) {
				this.count=70
			}else {
				this.currentAnim = this.anims.idle;		
				this.currentAnim.flip.x = this.flip;
			}
		}
		this.currentAnim = this.anims.idle;		
				this.currentAnim.flip.x = this.flip;
		// move!
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
		this.kill();
	},
	kill: function() {
		ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y, {flip:this.flip} );
		ig.game.spawnEntity( EntityBurstIPad, this.last.x+40, this.last.y, {flip:this.flip} );
		ig.game.score+=300;
		this.parent();
	}
});
});