﻿// JavaScript Document
ig.module(
	'game.entities.enemy4'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityEnemy4 = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 14, y:16},
	offset: {x:2,y:2},
	maxVel: {x: 32, y: 32},
	type: ig.Entity.TYPE.B, // Player friendly group
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.ACTIVE,	
	animSheet: new ig.AnimationSheet( 'media/gfx/enemy_2.png', 18, 20 ),		
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 300,
	flip: false,
	count: 45,
	dx:0,
	dy:0,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'shooting', 0.1, [1,1,1] );
		this.addAnim( 'walking', 0.1, [0,1] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
			this.dx=ig.game.player_position.x-this.pos.x;
			this.dy=ig.game.player_position.y-this.pos.y;
		}
		
		this.parent( res );
	},	
	
	update: function() {
		this.dx=ig.game.player_position.x-this.pos.x;
		this.dy=ig.game.player_position.y-this.pos.y;
		if(Math.abs(this.dy)<350) {
		this.count--;
			if( this.count==25 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x-1, this.pos.y+11, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x, this.pos.y+11, {flip:this.flip} );
			}
			else if( this.count==20 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x-1, this.pos.y+11, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x, this.pos.y+11, {flip:this.flip} );
			}else if( this.count==15 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x-1, this.pos.y+11, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x, this.pos.y+11, {flip:this.flip} );
			}else if( this.count==10 ) {
				this.currentAnim = this.anims.shooting;		
				this.currentAnim.flip.x = this.flip;
				ig.game.spawnEntity( EntityHit, this.pos.x-1, this.pos.y+11, {flip:this.flip} );
				ig.game.spawnEntity( EntityEnemyBullet2, this.pos.x, this.pos.y+11, {flip:this.flip} );
			}else if(this.count==0) {
				this.count=70
			}else {
				this.currentAnim = this.anims.walking;		
				this.currentAnim.flip.x = this.flip;
			}
		}	
		this.currentAnim = this.anims.walking;		
		this.currentAnim.flip.x = this.flip;
		// move!
		
		
		this.shot=!this.shot;
		
		if(this.dy>0&&Math.abs(this.dy)<350&&this.shot) {
			if(this.dx<0) {
				this.vel.y++;
				this.vel.x--;
			}else {
				this.vel.y++;
				this.vel.x++;
			}
		}
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
		this.kill();
	},
	kill: function() {
		ig.game.spawnEntity( EntityKillenemy, this.last.x, this.last.y, {flip:this.flip} );
		ig.game.score+=300;
		this.parent();
	}
});
});