﻿// JavaScript Document
ig.module(
	'game.entities.killenemy'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityKillenemy = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 19, y:24},
	maxVel: {x: 0, y: 0},
	type: ig.Entity.TYPE.NONE, // Player friendly group
	checkAgainst: ig.Entity.TYPE.NONE,
	collides: ig.Entity.COLLIDES.NEVER,	
	animSheet: new ig.AnimationSheet( 'media/gfx/enemy_die.png', 19, 24 ),		
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 0,
	flip: false,
	count: 3,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'kill', 0.1, [0,1] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
				this.kill();
		}
		this.parent( res );
	},	
	
	update: function() {	
		// shoot
	//	this.count--;
		this.currentAnim = this.anims.kill;		
		this.currentAnim.flip.x = this.flip;
		// move!
		this.parent();
		if(--this.count<0)
			this.kill();
	},
	kill: function() {
		this.parent();
	}
});
});