﻿ig.module(
	'game.entities.mine-iPad'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityMineIPad = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 22, y:10},
	offset:{x:2,y:2},
	maxVel: {x: 0, y: 0},
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.NEVER,	
	animSheet: new ig.AnimationSheet( 'media/gfx/mine-iPad.png', 30, 18 ),	
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 100,
	flip: false,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'mine', 0.1, [0,1] );
	//	this.addAnim( 'die', 0.1, [2] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
				this.kill();
		}
		this.parent( res );
	},	
	
	update: function() {				
		// move left or right
		this.currentAnim = this.anims.mine;		
		this.currentAnim.flip.x = this.flip;
		// move!
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
		this.kill();
	},
	
	kill: function() {
		ig.game.spawnEntity( EntityBurstIPad, this.last.x, this.last.y, {flip:this.flip} );
		this.parent();
	}
});
});