// JavaScript Document
ig.module(
	'game.entities.player'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityPlayer = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 25, y:23},
	offset: {x:2, y:2},
	//maxVel: {x: 64, y: 64},
	maxVel: {x:200,y:250},
	type: ig.Entity.TYPE.A, // Player friendly group
	checkAgainst: ig.Entity.TYPE.B,
	collides: ig.Entity.COLLIDES.NEVER,	
	animSheet: new ig.AnimationSheet( 'media/gfx/player.png', 29, 28 ),	
	notKill: false,
	notKillCount: 20,
	clicked_x:0,
	clicked_y:0,
	clicked: false,
	dx:0,
	dy:0,
	clicked_pos: {x: 0, y:0},
	origPos:{x:0,y:0},
	direction:0,

	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player

	health: 300,
	isKill: false,
	flip: false,
	count: 10,

	levelCompleted:false,
	timer: new ig.Timer(),
	isTargetZone:false,
	targetcount: 50,
	
	flag: false,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'leftshot', 0.1, [0] );
		this.addAnim( 'rightshot', 0.1, [1] );
		this.addAnim('notKill',0.01,[0,2,1,2]);
		this.addAnim('none',0.01,[2]);
		this.notKill=true;
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
			
			this.kill();
		}
		this.parent( res );
	},	
	draw:function() {
		this.parent();
		if(this.isTargetZone&&(ig.game.curLevel==1||ig.game.curLevel==3||ig.game.curLevel==5||ig.game.curLevel==6)) {
			var font=new ig.Font('media/font.png');
			font.draw('LEVEL '+ig.game.curLevel+' COMPLETED', 100,100);
			this.isTargetZone=false;
		}
	},
	
	update: function() {
		this.parent();
		//no boss level

		if(ig.game.screen.y<=0&&(--this.targetcount<=0))	{
			this.levelComplete=true;
			this.isTargetZone=true;
			if(this.flag==false){
				this.timer.set(3);
				this.flag=true;
			}else{
				if(this.timer.delta()>0)
				switch(ig.game.curLevel) {
					case 1:					
						ig.game.winLevel1=true;
						break;
					case 3:
						ig.game.winLevel3=true;
						break;
					case 5:
						ig.game.winLevel5=true;
						break;
					case 6:
						ig.game.winLevel6=true;
						break;
					default:
						break;
				}
				this.levelComplete=false;
//				this.isTargetZone=false;
			}	
		}
		
	
		ig.game.player_health=this.health;
		this.notKillCount--;
		if(this.notKillCount<=0)
			this.notKill=false;
		else{
			this.currentAnim = this.anims.none;
			this.currentAnim = this.anims.notKill;
			this.pos.y-=3;
		}
		// move left or right
		this.vel.y = 0;
		if( ig.input.state('left') ) {
			this.vel.x = -50;
			this.flip = true;
		}else if( ig.input.state('right') ) {
			this.vel.x = 50;
			this.flip = true;
		}else if( ig.input.state('up') ) {
			this.vel.y = -50;
		//	this.distFromStartpoint+=5;
			this.flip = true;
		}else if( ig.input.state('down') ) {
			this.vel.y = 50;
		//	this.distFromStartpoint-=5;
			this.flip = true;
		}else if( ig.input.state('mouse') ) {
			this.clicked_x = ig.input.mouse.x;
			this.clicked_y = ig.input.mouse.y;
			if( this.origPos.x == 0 && this.origPos.y == 0 ){
					this.origPos.x = 115;
					this.origPos.y = 420;
			}
			if( this.origPos.y - this.clicked_y > 0 ){
					this.direction = 0;
			}else{
					this.direction = 1;
			}
			this.origPos.x = this.clicked_x;
			this.origPos.y = this.clicked_y;
			
			this.clicked=true;
			var realx=this.clicked_x;
			var realy=ig.game.screen.y+this.clicked_y;//
			
			this.dx=realx-this.pos.x;
			this.dy=realy-this.pos.y;
		}else {
			this.flip = true;
		}
		
		if(this.pos.x < 0) {
			this.pos.x=0;
		} else if(this.pos.x > 320-28) {
			this.pos.x=320-28;
		}		
		// shoot
		this.count--;
		if(this.count==0){
			this.count=4;
			this.currentAnim = this.anims.rightshot;		
			this.currentAnim.flip.x = this.flip;
			ig.game.spawnEntity( EntityHit, this.pos.x-4, this.pos.y-10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBullet, this.pos.x, this.pos.y, {flip:this.flip} );
	//		ig.game.spawnEntity( EntityBullet, this.pos.x+24, this.pos.y, {flip:this.flip} );
		//	ig.game.spawnEntity( EntityBullet, this.pos.x+24, this.pos.y-14, {flip:this.flip} );		
		}else if(this.count==2){
			this.currentAnim = this.anims.leftshot;		
			this.currentAnim.flip.x = this.flip;
			ig.game.spawnEntity( EntityHit, this.pos.x+19, this.pos.y-10, {flip:this.flip} );
			ig.game.spawnEntity( EntityBullet, this.pos.x+24 ,this.pos.y-24, {flip:this.flip} );		
		}
		
		if(this.clicked) {
			this.dx = this.clicked_x - (this.pos.x + this.size.x/2);
			if(  this.direction == 0 ){
				this.dy = (ig.game.screen.y+this.clicked_y) - (this.pos.y + this.size.y + 30);
			}else{
				this.dy = (ig.game.screen.y+this.clicked_y) - (this.pos.y + this.size.y + 30);
			}
			
			this.dy = this.dy < 0 ? this.dy - 10: this.dy;
			if ( Math.abs(this.dx) < (this.size.x/2 ) && Math.abs(this.dy) <  (this.size.x/2 )) {
				
				this.vel.y = 0;	
				this.vel.x = 0;
				this.clicked=false;
				return;
			}

			var step=8;
			var step_x,step_y;
			if(Math.abs(this.dx)<Math.abs(this.dy)) {
				step_y=step;
				step_x=step*Math.abs(this.dx)/Math.abs(this.dy);
			}else {
				step_x=step;
				step_y=step*Math.abs(this.dy)/Math.abs(this.dx);
			}
		
			if(this.dx<0) {
					this.vel.x=-step_x*20;
			}else {
					this.vel.x=+step_x*20;
			}
			if(this.dy<0) {
					this.vel.y =- step_y * 20;
			}else {
					this.vel.y = step_y * 20;
			}
			this.flip=true;
			
			
			//this.vel.y -= ig.system.tick;
		}else {
			this.vel.x=0;
			//this.vel.y=-20;
		}
		
		if (ig.game.screen.y > 0)
		{
				this.vel.y -= 35;
		}
		// move!
		
	},

	kill: function() {
		if(this.notKill) return;
		ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y, {flip:this.flip} );
		ig.game.spawnEntity( EntityBurst, this.last.x-13, this.last.y, {flip:this.flip} );
		ig.game.spawnEntity( EntityBurst, this.last.x+20, this.last.y, {flip:this.flip} );
		ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y+15, {flip:this.flip} );
		ig.game.spawnEntity( EntityBurst, this.last.x+17, this.last.y-16, {flip:this.flip} );

		this.isKill=true;
	//	if(ig.game.life>0) {
			
			ig.game.kill_position.x=this.last.x;
			ig.game.kill_position.y=this.last.y;
	//	}
		this.parent();		
	}
});

// The grenades a player can throw are NOT in a separate file, because
// we don't need to be able to place them in Weltmeister. They are just used
// here in the code.

// Only entities that should be usable in Weltmeister need to be in their own
// file.
EntityBullet = ig.Entity.extend({
	size: {x: 5, y: 5},
	health: 100,
	maxVel: {x: 0, y: 400},	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.B, // Check Against B - our evil enemy group
	collides: ig.Entity.COLLIDES.PASSIVE,		
	animSheet: new ig.AnimationSheet( 'media/gfx/bullet.png', 5, 11 ),	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.vel.y -= 400;
		this.addAnim( 'shot', 0.1, [0] );
	},
		
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
			ig.game.spawnEntity( EntityHit, this.pos.x, this.pos.y, {flip:this.flip} );
			this.kill();
		}
		this.parent( res );
	},
	
	update: function() {
		this.dist+=1;
		if(this.dist>18) {
			this.kill();
		}
		this.accel.y=10;
		this.parent();
	},
	
	// This function is called when this entity overlaps anonther entity of the
	// checkAgainst group. I.e. for this entity, all entities in the B group.
	check: function( other ) {
		ig.game.spawnEntity( EntityHit, this.pos.x, this.pos.y, {flip:this.flip} );
		other.receiveDamage( 100, this );
		this.kill();
	}	
});
});