﻿ig.module(
	'game.entities.tntbox'
)
.requires(
	'impact.entity'
)
.defines(function(){

EntityTntbox = ig.Entity.extend({
	
	// The players (collision) size is a bit smaller than the animation
	// frames, so we have to move the collision box a bit (offset)
	size: {x: 14, y:26},
	offset:{x:2,y:2},
	maxVel: {x: 0, y: 0},
	type: ig.Entity.TYPE.BOTH,
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.FIXED,	
	animSheet: new ig.AnimationSheet( 'media/gfx/tntbox.png', 20, 30 ),	
	// These are our own properties. They are not defined in the base
	// ig.Entity class. We just use them internally for the Player
	health: 300,
	flip: false,
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );		
		// Add the animations
		this.addAnim( 'stand', 0.1, [0] );
	//	this.addAnim( 'burst', 0.1, [1,2,3,4] );
	},
	
	handleMovementTrace: function( res ) {		
		if( res.collision.x || res.collision.y ) {
				this.kill();
		}
		this.parent( res );
	},	
	
	update: function() {
		this.currentAnim = this.anims.stand;		
		this.currentAnim.flip.x = this.flip;
		// move!
		this.parent();
	},
	check: function( other ) {
		if(other.type==ig.Entity.TYPE.BOTH){
			return;
		}	
		other.receiveDamage( 100, this );
		this.kill();
	},
	
	kill: function() {
		ig.game.spawnEntity( EntityBurst, this.last.x, this.last.y, {flip:this.flip} );
		ig.game.score+=300;
		this.parent();
	}
});
});