ig.module( 
	'game.main' 
)
.requires(
	'impact.game',
	'impact.font',
	'impact.timer',
	'game.entities.boss',
		'game.entities.enemy',
		'game.entities.enemy2',
		'game.entities.enemy3',
		'game.entities.enemy4',
		'game.entities.bosstank',
		'game.entities.bossjeep',
		'game.entities.bosshelicopter',
		'game.entities.box',
		'game.entities.tntbox',
		'game.entities.drum',
		'game.entities.star',
		'game.entities.mine',
		'game.entities.burst',
		'game.entities.hit',
		'game.entities.killenemy',
		'game.entities.player',
		'game.levels.level1',
		'game.levels.level2',
		'game.levels.level3',
		'game.levels.level4',
		'game.levels.level5',
		'game.levels.level6',
		'game.levels.level7'
)
.defines(function(){

MyGame = ig.Game.extend({
	
	img_type: '',
	img_offset: 0,
	
	// Load a font	
	font: new ig.Font( 'media/font.png' ),
	
	animEnergy: new ig.AnimationSheet('media/gfx/energy_sheet.png',23,7),
	gameState: 'splash',	
	curLevel:1,
	life: 2,
	player_position: {x:0,y:0},
	kill_position: {x:0,y:0},
	first_pass: true,
	player_health: 300,
	levelCompleted: true,
//	killposition: {x:0, y:0},
//	levelCompleted: false,
//	isTargetZone: false,	
//	first_pass: true,
	isGameOver: false,
//	isWin: false,
	score: 0,
	arrHighScore: [],
	
	winLevel1: false,
	winLevel2: false,
	winLevel3: false,
	winLevel4: false,
	winLevel5: false,
	winLevel6: false,
	winLevel7: false,
	win: false,
	
	
	inner_height:480,
//	player: false,
//	player_life: 3,
//	player_position: {x: 0, y:0},
	//Some constants
	START_BTN_POSITION: {x:66, y:170},
	HELP_BTN_POSITION: {x:66, y:220},
	ABOUT_BTN_POSITION: {x:66, y:270},
	HIGHSCORE_BTN_POSITION: {x:66, y:270},
	MOREGAMES_BTN_POSITION: {x:66, y:320},
	PLAYAGAIN_BTN_POSITION: {x:66, y:220},
	ENTERSCORE_BTN_POSITION: {x:66, y:350},
	
	BTN_SIZE: {x:188, y:45},
	timer: new ig.Timer(),
	first:true,
	splashTimer: new ig.Timer(),
	
	//initialize game
	init: function() {
		// Initialize your game here; bind keys etc.
		ig.input.bind( ig.KEY.LEFT_ARROW, 'left' );
		ig.input.bind( ig.KEY.RIGHT_ARROW, 'right' );
		ig.input.bind( ig.KEY.UP_ARROW, 'up' );
		ig.input.bind( ig.KEY.DOWN_ARROW, 'down' );
		ig.input.bind( ig.KEY.X, 'shoot' );
		ig.input.bind( ig.KEY.MOUSE1, 'mouse' );
		ig.input.initMouse();
		this.splashTimer.set(1);
		this.player_health=300;
	//	this.selectLevel();			
	},
	
	game_start: function() {
		this.score=0;
				
		this.curLevel=1,
		this.life = 2,
		this.player_position.x = 0;
		this.player_position.y = 0;
		this.kill_position.x = 0;
		this.kill_position.y = 0;
	
		this.first_pass= true;
		this.player_health =  300;
		this.levelCompleted = true;
		this.isTargetZone= false;
	
		this.isGameOver = false;
		this.isWin = false;
		
		this.winLevel1 = false;
		this.winLevel2 = false;
		this.winLevel3 = false;
		this.winLevel4 = false;
		this.winLevel5 = false;
		this.winLevel6 = false;
		this.winLevel7 = false;
		this.win = false;
		
		this.inner_height = 480;
		
		this.init();
		this.selectLevel();
		this.gameState = "game";		
	},
	
	//update here
	update: function() {
		this.parent();
	//	if(!this.first)
	//	this.playGame();
		
	},
	
	//draw objects
	draw: function() {
		this.parent();
		//Check game state
		switch(this.gameState) {
			case 'splash':
				this.splash();
				break;
				
			case 'mainMenu':
				this.drawMenu();
				break;
				
			case 'game':
				//this.playGame();
				var imgBar = new ig.Image('media/gfx/scoreenergylives.png');
				var basey = Math.abs((480 - ig.ua.viewport.height)/2);
				
				this.font.draw('LEVEL : '+this.curLevel, 250,ig.ua.viewport.height+basey-25);
				basey = basey > 20 ? 0 : 20;
				imgBar.draw(2, basey);
				this.font.draw(' SCORE  '+this.score,5,basey + 6);
				this.font.draw('LIVES  '+this.life, 242,basey + 6);
				
				this.font.draw('ENERGY ', 137,basey + 6);
				switch(this.player_health) {
					case 300:
						var anim = new ig.Animation( this.animEnergy, 0.1, [0] );
						anim.update();
						// Draw current frame
						anim.draw( 200,basey + 7);
						break;
					case 200:
						var anim = new ig.Animation( this.animEnergy, 0.1, [1] );
						anim.update();
						// Draw current frame
						anim.draw( 200,basey + 7);
						break;
					case 100:
						var anim = new ig.Animation( this.animEnergy, 0.1, [2] );
						anim.update();
						// Draw current frame
						anim.draw( 200,basey + 7);
						break;
					default:
						break;
				}
				if(this.life<0) {
					this.gameState='gameover';
					this.isGameOver=true;
				}
				break;
				
			case 'help':
				this.showHelp();
				break;
			
			case 'inputname':
				this.showInputName();
				break;
			case 'gameover':
				this.showGameover();
				break;
			case 'win':
				this.showWin();
				break;
			

			case 'about':
				this.showAbout();
				break;
				
			//case 'highscore':
			//	this.showHighscore();
			//	break;
				
			//case 'moregames':
			//	document.location.href='http://www.celanderus.com/appstore';
			//	this.gameState='mainMenu';
			//	break;
				
			default:
				break;
		}
		this.keyCheck();
		
	},
	showWin: function() {
		var imgBkg = new ig.Image('media/gfx/helphsbackground' + img_type + '.jpg');
		imgBkg.draw(0,0);
		this.font.draw('CONGRATULATIONS!',50,150);
		this.font.draw('BUGGY MASTER',50,180);

		this.font.draw('BACK',13,400);
		
	},
	onClickCanvas:function() {
		this.parent();
		
		onClickCanvas();
	},
	//showInputName: function() {
	//	var imgBkg = new ig.Image('media/gfx/helphsbackground' + img_type + '.jpg');
	//	imgBkg.draw(0,0);
	//	this.font.draw( 'ENTER YOUR NAME', 55, 30 );
	//	var str = ig.$( '#highscore' ).value.toUpperCase();
	//	var length = str.length;
	//	this.font.draw( str, 160 - length * 7, 200 );
	//},
	showGameover: function() {
		var imgBkg = new ig.Image('media/gfx/helphsbackground' + img_type + '.jpg');
		var imgGameover=new ig.Image('media/gameover.png');
		var imgPlayAgain = new ig.Image('media/gfx/PlayAgainButtons.png');
		//var imgEnterScore = new ig.Image('media/gfx/EnterScoreButtons.png');
		var img
		imgBkg.draw(0,0);
		imgGameover.draw(50+img_offset,150);
		imgPlayAgain.draw(this.PLAYAGAIN_BTN_POSITION.x + img_offset, this.PLAYAGAIN_BTN_POSITION.y);
		//imgEnterScore.draw(this.ENTERSCORE_BTN_POSITION.x + img_offset, this.ENTERSCORE_BTN_POSITION.y);
		
	},
	
	//show splash screen.
	splash: function() {
		if(this.splashTimer.delta()<0){
			var imgSplash = new ig.Image('media/SplashTweensoft-logo320x480' + img_type +'.jpg');
			//draw splash screen
			imgSplash.draw(0,0);
		} else {
			var imgBkg=new ig.Image('media/gfx/cover' + img_type + '.jpg');
			imgBkg.draw(0,0);
		}
		
	},
	
	//Draw main menu screen
	drawMenu: function() {
		var imgBkg = new ig.Image('media/gfx/menuback' + img_type + '.jpg');
		var imgBtnStart = new ig.Image('media/gfx/StartButtons.png');
		var imgBtnHelp = new ig.Image('media/gfx/HelpButtons.png');
		var imgBtnAbout = new ig.Image('media/gfx/aboutbuttons.png');
		//var imgBtnHighScore = new ig.Image('media/gfx/HighscoreButtons.png');
		//var imgBtnMoreGames = new ig.Image('media/gfx/MoreGamesButtons.png');
		
		//draw backgrounds
		imgBkg.draw(0,0);
		//draw buttons
		imgBtnStart.draw(this.START_BTN_POSITION.x + img_offset,this.START_BTN_POSITION.y);
		imgBtnHelp.draw(this.HELP_BTN_POSITION.x + img_offset,this.HELP_BTN_POSITION.y);
		imgBtnAbout.draw(this.ABOUT_BTN_POSITION.x + img_offset,this.ABOUT_BTN_POSITION.y);
		//imgBtnHighScore.draw(this.HIGHSCORE_BTN_POSITION.x + img_offset,this.HIGHSCORE_BTN_POSITION.y);
		//imgBtnMoreGames.draw(this.MOREGAMES_BTN_POSITION.x + img_offset,this.MOREGAMES_BTN_POSITION.y);
	},
	
	levelComplete: function() {
		if(this.winLevel1) {
			this.winLevel1=false;
			this.levelCompleted=true;
			this.curLevel+=1;

			//test
			this.gameState='win'
			return;
		}if(this.winLevel2) {
			this.winLevel2=false;
			this.levelCompleted=true;
			this.curLevel+=1;
			return;
		}if(this.winLevel3) {
			this.winLevel3=false;
			this.levelCompleted=true;
			this.curLevel+=1;
			return;
		}if(this.winLevel4) {
			this.winLevel4=false;
			this.levelCompleted=true;
			this.curLevel+=1;
			return;
		}if(this.winLevel5) {
			this.winLevel5=false;
			this.levelCompleted=true;
			this.curLevel+=1;
			return;
		}if(this.winLevel6) {
			this.winLevel6=false;
			this.levelCompleted=true;
			this.curLevel+=1;
			return;
		}if(this.winLevel7) {
			this.winLevel7=false;
			this.levelCompleted=true;
			this.isWin=true;
			this.curLevel =1;
			this.gameState='win';
			return;
		}
		this.levelCompleted=false;
	},
	
	//Select current level
	selectLevel: function() {
		
		switch(this.curLevel) {
			case 1:
				this.font.draw('LEVEL 1',100,0);
				this.loadLevel(LevelLevel1);
				this.screen.y=2080;
				break;
				
			case 2:
				this.font.draw('LEVEL 2',0,0);
				this.loadLevel(LevelLevel2);
				this.screen.y=2080;
				break;
				
			case 3:
				
				this.font.draw('LEVEL 3',0,0);
				this.loadLevel(LevelLevel3);
				this.screen.y=2080;
				break;
				
			case 4:
				this.font.draw('LEVEL 4',0,0);
				this.loadLevel(LevelLevel4);
				this.screen.y=2080;
				break;
				
			case 5:
				this.font.draw('LEVEL 5',0,0);
				this.loadLevel(LevelLevel5);
				this.screen.y=2080;
				break;
				
			case 6:
				this.font.draw('LEVEL 6',0,0);
				this.loadLevel(LevelLevel6);
				this.screen.y=2080;
				break;
				
			case 7:
				this.font.draw('FINAL LEVEL',0,0);
				this.loadLevel(LevelLevel7);
				this.screen.y=3808;
				break;
				
			default:
				break;
		}
	},
	
	//Play game
	playGame: function() {
		if(!this.first)
		this.levelComplete();
		this.first=false;
		if(this.levelCompleted){
	//	if(this.curLevel!=1)
			this.selectLevel();
			this.levelCompleted=false;
		}
		
		var player = this.getEntitiesByType( EntityPlayer )[0];
		//alert (EntityEnemy.count);
		if( this.first_pass&&player ) {
			this.screen.y = player.pos.y - ig.system.height + 28;
			this.first_pass=false;
		}
		if(player) {
			this.first_pass=false;
			if(this.screen.y>0)
				this.screen.y-=2;
			if(player.pos.y<=this.screen.y)
				player.pos.y=this.screen.y;
			if(player.pos.y>this.screen.y+ig.system.height-player.size.y)
				player.pos.y=this.screen.y+ig.system.height-player.size.y;
				
			this.player_position=player.pos;
		}
		else {
			if(this.life>0) {
				this.life--;
				var player=ig.game.spawnEntity( EntityPlayer, this.kill_position.x, this.kill_position.y, null );
				
			}else {
				this.life=2;
				this.curLevel = 1;
				this.screen.y=2080;
				var player=ig.game.spawnEntity( EntityPlayer, 102, 2510, null );
				this.gameState='gameover';				
				this.isGameOver=true;
			}
		}

	},
	
	//keyboard check
	keyCheck: function() {
		switch(this.gameState) {
			case 'splash':
				this.keyCheckSplash();
				break;
			case 'win':
				this.keyCheckWin();
				
				break;
				
			case 'inputname':
				this.keyCheckInputName();
				break;
			case 'gameover':
				this.keyCheckGameOver();
				break;
			case 'mainMenu':
				this.keyCheckMainMenu();
				break;
			
			case 'game':
				this.playGame();
				break;
				
			case 'help':
				this.keyCheckSplash();
				break;
				
			case 'about':
				this.keyCheckSplash();
				break;
				
			//case 'highscore':
				//var that = this;
				//this.gameState = 'none';
				//var req = $.ajax({
				//	url:( "game.php" + '?nocache=' + Math.random() ), 
				//	data: {a: 'l'},
				//	dataType: 'json',
				//	async:false,
				//	success:function(scores) {
				//		that.arrHighScore = scores;
				//		that.gameState = 'highscore';
				//		
				//	}
				//});
				//this.keyCheckSplash();
				//break;
				
			//case 'moregames':
			//	this.keyCheckSplash();
			//	break;
				
			default:
				break;
		}
	},
	
	keyCheckInputName: function() {
		if( ig.input.pressed( 'mouse' ) || ig.input.pressed( 'enter' ) ) {
			
			var name = ig.$( '#highscore' ).value.toUpperCase();
			if( name == '' ) {
				return;
			}
			var that = this;
			this.gameState = 'highscore';
				
			var req = $.ajax({
				url:( "game.php" + '?nocache=' + Math.random() ), 
				data: {a: 's', n:name, s: this.score},
				dataType: 'json',
				async:false,
				success:function(scores) {
					window.scrollTo(0,1); // JJH
					that.arrHighScore = scores;
					document.getElementById('highscore').blur();
					that.gameState = 'highscore';
					
					$('#highscore').css('z-index', 0);
					$('#canvas').css('z-index', 6);
					$('#canvas').focus();
					
				}
			});
					
		}
	},
	keyCheckWin: function() {
		if( ig.input.pressed( 'mouse' ) ) {
			//ig.$( '#highscore' ).value = '';
			//	$('#highscore').css('z-index', 10);
			//	$('#canvas').css('z-index', 0);
			//	ig.$("#highscore").focus();
			//	this.gameState = 'inputname';
			this.gameState='mainMenu';
		}
	},
	keyCheckGameOver: function() {
		if( ig.input.pressed( 'mouse' ) ) {
			var x = ig.input.mouse.x;
			var y = ig.input.mouse.y;
			
			if( x>=this.PLAYAGAIN_BTN_POSITION.x + img_offset && x<=this.PLAYAGAIN_BTN_POSITION.x + img_offset+this.BTN_SIZE.x &&
				 y>=this.PLAYAGAIN_BTN_POSITION.y && y<=this.PLAYAGAIN_BTN_POSITION.y+this.BTN_SIZE.y) {
					var self = this;
					adManager.showAd(function() {
						self.game_start();
					});
			} 
			//if( x>=this.ENTERSCORE_BTN_POSITION.x + img_offset && x<=this.ENTERSCORE_BTN_POSITION.x + img_offset+this.BTN_SIZE.x &&
			//	 y>=this.ENTERSCORE_BTN_POSITION.y && y<=this.ENTERSCORE_BTN_POSITION.y+this.BTN_SIZE.y) {
			//	ig.$( '#highscore' ).value = '';
			//	$('#highscore').css('z-index', 10);
			//	$('#canvas').css('z-index', 0);
			//	ig.$("#highscore").focus();
			//	this.gameState = 'inputname';
			//} 			
		}
	},
	
	//key check about splash screen
	keyCheckSplash: function() {
		if( ig.input.pressed( 'mouse' ) || ig.input.pressed( 'enter' ) ) {
			this.gameState = 'mainMenu';
		}
	},
	
	//key check main menu
	keyCheckMainMenu: function() {
		if( ig.input.pressed( 'mouse' ) ) {
			var x = ig.input.mouse.x;
			var y = ig.input.mouse.y;
			
			if( x>=this.START_BTN_POSITION.x + img_offset && x<=this.START_BTN_POSITION.x + img_offset+this.BTN_SIZE.x &&
				 y>=this.START_BTN_POSITION.y && y<=this.START_BTN_POSITION.y+this.BTN_SIZE.y) {
					var self = this;
					adManager.showAd(function() {
						self.game_start();
					});				
			} 
			else if( x>=this.HELP_BTN_POSITION.x + img_offset && x<=this.HELP_BTN_POSITION.x + img_offset+this.BTN_SIZE.x &&
				 y>=this.HELP_BTN_POSITION.y && y<=this.HELP_BTN_POSITION.y+this.BTN_SIZE.y) {
				
				this.gameState = 'help';
			} 
			else if( x>=this.ABOUT_BTN_POSITION.x + img_offset && x<=this.ABOUT_BTN_POSITION.x + img_offset+this.BTN_SIZE.x &&
				 y>=this.ABOUT_BTN_POSITION.y && y<=this.ABOUT_BTN_POSITION.y+this.BTN_SIZE.y) {
				
				this.gameState = 'about';
			} 
			//else if( x>=this.HIGHSCORE_BTN_POSITION.x + img_offset && x<=this.HIGHSCORE_BTN_POSITION.x + img_offset+this.BTN_SIZE.x &&
			//	 y>=this.HIGHSCORE_BTN_POSITION.y && y<=this.HIGHSCORE_BTN_POSITION.y+this.BTN_SIZE.y) {
			//	
			//	this.gameState = 'highscore';
			//} 
			//else if( x>=this.MOREGAMES_BTN_POSITION.x + img_offset && x<=this.MOREGAMES_BTN_POSITION.x + img_offset+this.BTN_SIZE.x &&
			//	 y>=this.MOREGAMES_BTN_POSITION.y && y<=this.MOREGAMES_BTN_POSITION.y+this.BTN_SIZE.y) {
			//	
			//	this.gameState = 'moregames';
			//} 
			else {
				this.gameState = 'mainMenu';
			}
		}
	},
	
	//Show help
	showHelp: function() {
		//some message output
		var imgBkg = new ig.Image('media/gfx/helphsbackground' + img_type + '.jpg');
		imgBkg.draw(0,0);
		
		this.font.draw('BUGGY FIGHTER (C) 2011.',160,120,ig.Font.ALIGN.CENTER);
		this.font.draw('USE TOUCH TO CONTROL YOUR BUGGY.',160,140,ig.Font.ALIGN.CENTER);
		this.font.draw('COLLECT STARS TO INCREASE YOUR SCORES!',160,160,ig.Font.ALIGN.CENTER);

		this.font.draw('BACK',13,400);
	},
	
	//Show About message
	showAbout: function() {
		//some message output
		var imgBkg = new ig.Image('media/gfx/helphsbackground' + img_type + '.jpg');
		imgBkg.draw(0,0);
		
		this.font.draw('BUGGY FIGHTER (C) 2011.',160,120,ig.Font.ALIGN.CENTER);
		this.font.draw('COPYRIGHT TWEENSOFT INC.',160,150,ig.Font.ALIGN.CENTER);
		this.font.draw('WWW.TWEENSOFT.COM',160,180,ig.Font.ALIGN.CENTER);
		//this.font.draw('BUGGY FIGHTER GAME.',160,140,ig.Font.ALIGN.CENTER);

		this.font.draw('BACK',13,400);
	},
	
	//Show highscore
	showHighscore: function() {
		var imgBkg = new ig.Image('media/gfx/helphsbackground' + img_type + '.jpg');
		imgBkg.draw(0,0);
		this.font.draw( 'HIGHSCORE', 160, 40,ig.Font.ALIGN.CENTER );
		this.font.draw('BACK',13,400);
		for( i = 0; i < 10; i++ ) {
			this.font.draw( i + 1 + '.', 40, 30 * i + 80 );
			
			if( this.arrHighScore[i] != undefined ) { 
				this.font.draw( this.arrHighScore[i].name, 80, 30 * i + 80 ); 
				this.font.draw( this.arrHighScore[i].score, 200, 30 * i + 80 ); 
			} else {
				this.font.draw( '.....', 80, 30 * i + 70 );
			}
		}
	}
});
	
adManager.init();
	
if(ig.ua.iPad) {
	ig.main( '#canvas', MyGame, 10, 320, 480, 2 );
	img_type = ""; //img_type = "_ipad";
	img_offset = 0; // img_offset = 15;
}else{
	window.scrollTo(0,1);
	ig.main( '#canvas', MyGame, 10, 320, 480, 1 );
	img_type = "";
	img_offset = 0;
}
});
