			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var diameterFtVar = null;
			var diameterInVar = null;
			var diameterFracVar = null;
			var thickInVar = null;
			var thickFracVar = null;
			var denseVar = null;
			var wasteVar = null;
			var qtyVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					diameterFtVar = $('#diameterft');
					diameterInVar = $('#diameterin');
					diameterFracVar = $('#diameterfrac');
					thickInVar = $('#thickin');
					thickFracVar = $('#thickfrac');
					denseVar = $('#dense');
					wasteVar = $('#waste');
					qtyVar = $('#qty');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					diameterFtVar.Watermark("Feet");
					diameterInVar.Watermark("Inches");
					thickInVar.Watermark("Inches");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(diameterFtVar.val()) && diameterFtVar.val() != 'Feet') || (isNaN(diameterInVar.val()) && diameterInVar.val() != 'Inches')) {
						$('#diameterLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(diameterFtVar.val() == "Feet") {
						diameterFtVar.val(0);
					}
					if(diameterInVar.val() == "Inches") {
						diameterInVar.val(0);
					}
					if(thickInVar.val() == "Inches") {
						thickInVar.val(0);
					}
					if(isNaN(wasteVar.val())) {
						wasteVar.val(0);
					}
					if(isNaN(qtyVar.val())){
						qtyVar.val(0);
					}

					var diameter = (((diameterFtVar.val() * 1) + (((diameterInVar.val() * 1) + ($('#diameterfrac option:selected').val() * 1)) / 12)));
					var thick = ((thickInVar.val() * 1) + ($('#thickfrac option:selected').val() * 1)) / 12;
					var density = ($('#dense option:selected').val() * 1);
					var waste = wasteVar.val();
					var qty = qtyVar.val();

					var volume = (Math.PI * ((diameter/2)*(diameter/2))) * thick;
					var volumeWaste = 0;
					if(waste != 0){
						volumeWaste = volume * (1 + (waste/100));
					}else{
						volumeWaste = volume;
					}
					var allVolume = 0;
					if(qty != 0){
						allVolume = volumeWaste * qty;
					}else{
						allVolume = volumeWaste;
					}
					
					var singleWeight = volumeWaste * (density/27);
					var singleWeightTon = singleWeight / 2000;
					var allWeight = allVolume * (density/27);
					var allWeightTon = allWeight / 2000;					


					var a = "";
					a += "<li>Single Volume - <span class='answer'>" + formatCurrency(volumeWaste) + " ft3</span></li>";
					a += "<li>Single Volume - <span class='answer'>" + formatCurrency(volumeWaste/27) + " yd3</span></li>";
					a += "<li>Single Weight - <span class='answer'>" + formatCurrency(singleWeight) + " lbs</span></li>";
					a += "<li>Single Weight - <span class='answer'>" + formatCurrency(singleWeightTon) + " tons</span></li>";
					a += "<li>All Volume - <span class='answer'>" + formatCurrency(allVolume) + " ft3</span></li>";
					a += "<li>All Volume - <span class='answer'>" + formatCurrency(allVolume	/27) + " yd3</span></li>";
					a += "<li>All Weight - <span class='answer'>" + formatCurrency(allWeight) + " lbs</span></li>";
					a += "<li>All Weight - <span class='answer'>" + formatCurrency(allWeightTon) + " tons</span></li>";
					
					
					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					 $('#diameterLabel').removeClass(MISSING);
					 $('#thickLabel').removeClass(MISSING);
					 $('#denseLabel').removeClass(MISSING);
					 $('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}
