			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var wplVar = null;
			var nolVar = null;
			var voltsVar = null;
			var loadsVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;
			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					wplVar = $('#wpl');
					nolVar = $('#nol');
					voltsVar = $('#volts');
					loadsVar = $('#loads');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');
					hideContentDialog();
					loadsVar.val(0);
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content

					removeError();

					if(wplVar == null || wplVar.val() == EMPTY || isNaN(wplVar.val())) {
						err = true;
						$('#wplLabel').addClass(MISSING);
					}
					if(nolVar == null || nolVar.val() == EMPTY || isNaN(nolVar.val())) {
						err = true;
						$('#nolLabel').addClass(MISSING);
					}
					if(voltsVar == null || voltsVar.val() == EMPTY || isNaN(voltsVar.val())) {
						err = true;
						$('#voltsLabel').addClass(MISSING);
					}
					if(loadsVar == null || loadsVar.val() == EMPTY || isNaN(loadsVar.val())) {
						err = true;
						$('#loadsLabel').addClass(MISSING);
					}

					// If validation fails, show Dialog content
					if(err == true) {
						hideMain();
						showContentDialog();
					} else {
						var wfl = wplVar.val() * nolVar.val();
						var totalWatts = ((wfl * 1) + (loadsVar.val() * 1));
						var ampsRequired = formatCurrency((totalWatts * 1) / (voltsVar.val() * 1));

						var answer = "<li>Watts for Lights = <span class='answer'>" + wfl + "W</span></li>";
						answer += "<li>Watts Other Loads = <span class='answer'>" + loadsVar.val() + "W</span></li>";
						answer += "<li>Watts Total Load = <span class='answer'>" + totalWatts + "W</span></li>";
						answer += "<li>Volts for Circuit = <span class='answer'>" + voltsVar.val() + "V</span></li>";
						answer += "<li>Amps Required = <span class='answer'>" + ampsRequired + "A</span></li>";

						$('#answerUL').html(answer);

						if(calculated) {
							$('#answerUL').listview("refresh");
						} else {
							$('#answerUL').listview();
						}
						calculated = true;
					}
					return false;
				});
				function removeError() {
					$('#wplLabel').removeClass(MISSING);
					$('#nolLabel').removeClass(MISSING);
					$('#voltsLabel').removeClass(MISSING);
					$('#loadsLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}