			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var ampsVar = null;
			var wattsVar = null;
			var voltsVar = null;
			var whatVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;
			// Constants
			var MISSING = "missing";
			var REQUIRED = "required";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					ampsVar = $('#amps');
					wattsVar = $('#watts');
					voltsVar = $('#volts');
					whatVar = $('#what');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');
					hideContentDialog();
					addStyles();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});
				
				$('#what').change(function() {
					removeStyles();
					addStyles();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content

					removeStyles();

					if($('#what option:selected').val() == 'amps') {
						if(wattsVar == null || wattsVar.val() == EMPTY || isNaN(wattsVar.val())) {
							err = true;
							$('#wattsLabel').addClass(MISSING);
						}
						if(voltsVar == null || voltsVar.val() == EMPTY || isNaN(voltsVar.val())) {
							err = true;
							$('#voltsLabel').addClass(MISSING);
						}
						if(err == false) {
							$('#answerUL').html("<li>Amps = <span class='answer'>" + formatCurrency((wattsVar.val() * 1) / (voltsVar.val() * 1)) + "</span></li>");
						}
					}
					if($('#what option:selected').val() == 'watts') {
						if(isNaN(ampsVar == null || ampsVar.val() == EMPTY || ampsVar.val())) {
							err = true;
							$('#ampsLabel').addClass(MISSING);
						}
						if(voltsVar == null || voltsVar.val() == EMPTY || isNaN(voltsVar.val())) {
							err = true;
							$('#voltsLabel').addClass(MISSING);
						}
						if(err == false) {
							$('#answerUL').html("<li>Watts = <span class='answer'>" + formatCurrency((ampsVar.val() * 1) * (voltsVar.val() * 1)) + "</span></li>");
						}
					}
					if($('#what option:selected').val() == 'volts') {
						if(ampsVar == null || ampsVar.val() == EMPTY || isNaN(ampsVar.val())) {
							err = true;
							$('#ampsLabel').addClass(MISSING);
						}
						if(wattsVar == null || wattsVar.val() == EMPTY || isNaN(wattsVar.val())) {
							err = true;
							$('#wattsLabel').addClass(MISSING);
						}
						if(err == false) {
							$('#answerUL').html("<li>Volts = <span class='answer'>" + formatCurrency((wattsVar.val() * 1) / (ampsVar.val() * 1)) + "</span></li>");
						}
					}

					// If validation fails, show Dialog content
					if(err == true) {
						hideMain();
						showContentDialog();
					}
					
					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					
					return false;
				});
				function removeStyles() {
					$('#ampsLabel').removeClass(MISSING);
					$('#wattsLabel').removeClass(MISSING);
					$('#voltsLabel').removeClass(MISSING);
					$('#ampsLabel').removeClass(REQUIRED);
					$('#wattsLabel').removeClass(REQUIRED);
					$('#voltsLabel').removeClass(REQUIRED);
				}

				function addStyles() {
					if($('#what option:selected').val() == 'amps') {
						$('#wattsLabel').addClass(REQUIRED);
						$('#voltsLabel').addClass(REQUIRED);
					}
					if($('#what option:selected').val() == 'watts') {
						$('#ampsLabel').addClass(REQUIRED);
						$('#voltsLabel').addClass(REQUIRED);
					}
					if($('#what option:selected').val() == 'volts') {
						$('#ampsLabel').addClass(REQUIRED);
						$('#wattsLabel').addClass(REQUIRED);
					}
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}