			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var lengthVar = null;
			var lengthInchVar = null;
			var lengthFracVar = null;
			var widthInchVar = null;
			var widththFracVar = null;
			var spaceInchVar = null;
			var spaceFracVar = null;
			var qtyVar = null;
			var costVar = null;
			var whatVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					lengthVar = $('#length');
					lengthInchVar = $('#lengthinch');
					lengthFracVar = $('#lengthfrac');
					widthInchVar = $('#widthinch');
					widthFracVar = $('#widthfrac');
					spaceInchVar = $('#spaceinch');
					spaceFracVar = $('#spacefrac');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					lengthVar.Watermark("Feet");
					lengthInchVar.Watermark("Inches");
					widthInchVar.Watermark("Inches");
					spaceInchVar.Watermark("Inches");
					hideContentDialog();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content

					removeError();

					// Perform form validation
					if(lengthVar == null || lengthVar.val() == EMPTY || lengthVar.val() == 'Feet') {
						lengthVar.val(0);
					} else {
						if(isNaN(lengthVar.val())) {
							$('#lengthLabel').addClass(MISSING);
							err = true;
						}
					}

					if((lengthInchVar == null) || (lengthInchVar.val() == EMPTY) || lengthInchVar.val() == 'Inches') {
						lengthInchVar.val(0);
					} else {
						if(isNaN(lengthInchVar.val())) {
							$('#lengthLabel').addClass(MISSING);
							err = true;
						}
					}

					if((widthInchVar == null) || (widthInchVar.val() == EMPTY) || widthInchVar.val() == 'Inches') {
						widthInchVar.val(0);
					} else {
						if(isNaN(widthInchVar.val())) {
							$('#widthLabel').addClass(MISSING);
							err = true;
						}
					}

					if((spaceInchVar == null) || (spaceInchVar.val() == EMPTY) || spaceInchVar.val() == 'Inches') {
						spaceInchVar.val(0);
					} else {
						if(isNaN(spaceInchVar.val())) {
							$('#spaceLabel').addClass(MISSING);
							err = true;
						}
					}

					var length = lengthVar.val() * 12;
					if(!isNaN(lengthInchVar.val())) {
						length += (((lengthInchVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)));
					}

					var width = 0;
					if(!isNaN(widthInchVar.val())) {
						width += (((widthInchVar.val() * 1) + ($('#widthfrac option:selected').val() * 1)));
					}

					var space = 0;
					if(!isNaN(spaceInchVar.val())) {
						space += (((spaceInchVar.val() * 1) + ($('#spacefrac option:selected').val() * 1)));
					}
					if(length == 0 || width == 0 || space == 0) {
						err = true;
					}
					if(err == true) {
						hideMain();
						showContentDialog();
						return false;
					}

					var qtyB = Math.ceil(length / (width + space));
					var qtyS = (qtyB * 1) + 1;
					var realSpace = (((length * 1) + ((width * 1))) / (qtyS * 1));
					var inbetween = (realSpace * 1) - width;

					var blockA = "<li>";
					//var blockB = "<div class=\"ui-block-b\">";
					var span = "<span class=\"answer\">";


					//var a = "<ul>";
					var a = "";
					a += blockA + "Qty of Balusters - " + span + qtyB + "</span></li>";
					a += blockA + "Qty of Spaces - " + span + qtyS + "</span></li>";
					a += blockA + "Baluster spacing (center-to-center) - " + span + convertDecimalInchToFraction(realSpace) + "</span></li>";
					a += blockA + "Baluster spacing (edge-to-edge) - " + span + convertDecimalInchToFraction(inbetween) + "</span></li>";

					var j = 0;
					var start = ((realSpace * 1) - (width * 1));
					var stop = (length * 1) - (width / 2);
					for(var i = start; i < stop; i = i + realSpace) {
						j++;
						a += blockA + "Baluster " + j + " - " + span + convertDecimalInchToFraction(i) + "</span></li>";
					}
					//a += "</ul>"

					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#lengthLabel').removeClass(MISSING);
					$('#widthLabel').removeClass(MISSING);
					$('#spaceLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}