			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var heightFtVar = null;
			var heightInVar = null;
			var heightFracVar = null;
			var lengthFtVar = null;
			var lengthInVar = null;
			var lengthFracVar = null;
			var blockHeightInVar = null;
			var blockHeightFracVar = null;
			var blockLengthInVar = null;
			var blockLengthFracVar = null;
			var wasteVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					heightFtVar = $('#heightft');
					heightInVar = $('#heightin');
					heightFracVar = $('#heightfrac');
					lengthFtVar = $('#lengthft');
					lengthInVar = $('#lengthin');
					lengthFracVar = $('#lengthfrac');
					blockHeightInVar = $('#blockHeightin');
					blockHeightFracVar = $('#blockHeightfrac');
					blockLengthInVar = $('#blockLengthin');
					blockLengthFracVar = $('#blockLengthfrac');
					wasteVar = $('#waste');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					heightFtVar.Watermark("Feet");
					heightInVar.Watermark("Inches");
					lengthFtVar.Watermark("Feet");
					lengthInVar.Watermark("Inches");
					blockHeightInVar.Watermark("Inches");
					blockLengthInVar.Watermark("Inches");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(heightFtVar.val()) && heightFtVar.val() != 'Feet') || (isNaN(heightInVar.val()) && heightInVar.val() != 'Inches')) {
						$('#heightLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(heightFtVar.val() == "Feet") {
						heightFtVar.val(0);
					}
					if(heightInVar.val() == "Inches") {
						heightInVar.val(0);
					}
					if((isNaN(lengthFtVar.val()) && lengthFtVar.val() != 'Feet') || (isNaN(lengthInVar.val()) && lengthInVar.val() != 'Inches')) {
						$('#lengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(lengthFtVar.val() == "Feet") {
						lengthFtVar.val(0);
					}
					if(lengthInVar.val() == "Inches") {
						lengthInVar.val(0);
					}

					if((isNaN(blockHeightInVar.val()) && blockHeightInVar.val() != 'Inches')) {
						$('#blockHeightLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(blockHeightInVar.val() == "Inches") {
						blockHeightInVar.val(0);
					}
					if((isNaN(blockLengthInVar.val()) && blockLengthInVar.val() != 'Inches')) {
						$('#blockLengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(blockLengthInVar.val() == "Inches") {
						blockLengthInVar.val(0);
					}
					if(isNaN(wasteVar.val())) {
						wasteVar.val(0);
					}

					var height = (((heightFtVar.val() * 1) + (((heightInVar.val() * 1) + ($('#heightfrac option:selected').val() * 1)) / 12)));
					var length = (((lengthFtVar.val() * 1) + (((lengthInVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12)));
					var blockHeight = (((((blockHeightInVar.val() * 1) + ($('#blockHeightfrac option:selected').val() * 1)) / 12)));
					var blockLength = (((((blockLengthInVar.val() * 1) + ($('#blockLengthfrac option:selected').val() * 1)) / 12)));
					var waste = wasteVar.val();

					var area = height * length;
					var areaWaste = 0;
					if(waste != 0){
						areaWaste = area * (1 + (waste/100));
					}else{
						areaWaste = area;
					}
					
					var blockArea = blockHeight * blockLength;
					
					var blocksRequired = Math.ceil(areaWaste/blockArea);
					
					var a = "<li>Blocks Required - <span class='answer'>" + formatCurrency(blocksRequired) + "</span></li>";
					
					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					 $('#heightLabel').removeClass(MISSING);
					 $('#lengthLabel').removeClass(MISSING);
					 $('#blockHeightLabel').removeClass(MISSING);
					 $('#blockLengthLabel').removeClass(MISSING);
					 $('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}