			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var diameterFtVar = null;
			var diameterInVar = null;
			var diameterFracVar = null;
			var heightFtVar = null;
			var heightInVar = null;
			var heightFracVar = null;
			var qtyVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					diameterFtVar = $('#diameterft');
					diameterInVar = $('#diameterin');
					diameterFracVar = $('#diameterfrac');
					heightFtVar = $('#heightft');
					heightInVar = $('#heightin');
					heightFracVar = $('#heightfrac');
					qtyVar = $('#qty');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					diameterFtVar.Watermark("Feet");
					diameterInVar.Watermark("Inches");
					heightFtVar.Watermark("Feet");
					heightInVar.Watermark("Inches");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(diameterFtVar.val()) && diameterFtVar.val() != 'Feet') || (isNaN(diameterInVar.val()) && diameterInVar.val() != 'Inches')) {
						$('#diameterLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(diameterFtVar.val() == "Feet") {
						diameterFtVar.val(0);
					}
					if(diameterInVar.val() == "Inches") {
						diameterInVar.val(0);
					}
					if((isNaN(heightFtVar.val()) && heightFtVar.val() != 'Feet') || (isNaN(heightInVar.val()) && heightInVar.val() != 'Inches')) {
						$('#heightLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(heightFtVar.val() == "Feet") {
						heightFtVar.val(0);
					}
					if(heightInVar.val() == "Inches") {
						heightInVar.val(0);
					}

					var diameter = (((diameterFtVar.val() * 1) + (((diameterInVar.val() * 1) + ($('#diameterfrac option:selected').val() * 1)) / 12)));
					var height = (((heightFtVar.val() * 1) + (((heightInVar.val() * 1) + ($('#heightfrac option:selected').val() * 1)) / 12)));

					var volume = (Math.PI * ((diameter/2)*(diameter/2))) * height;
					var volumeQty = 0;

					if(qtyVar.val() != 0){
						volumeQty = volume * qtyVar.val();
					}else{
						volumeQty = volume;
					}

					var a = "<li>Per Column:</li>";
					a += "<li>Volume - <span class='answer'>" + formatCurrency(volume) + " ft3</span></li>";
					a += "<li>Volume - <span class='answer'>" + formatCurrency(volume / 27) + " yd3</span></li>";
					a += "<li>60lb premixed bags - <span class='answer'>" + Math.ceil((volume / 27) * 60) + "</span></li>";
					a += "<li>80lb premixed bags - <span class='answer'>" + Math.ceil((volume / 27) * 45) + "</span></li>";
					a += "<li>10kg premixed bags - <span class='answer'>" + Math.ceil((volume / 27) * 163.3) + "</span></li>";
					a += "<li>25kg premixed bags - <span class='answer'>" + Math.ceil((volume / 27) * 65.3) + "</span></li>";
					a += "<li>50kg premixed bags - <span class='answer'>" + Math.ceil((volume / 27) * 32.7) + "</span></li>";
					a += "<li>Total</li>";
					a += "<li>Volume - <span class='answer'>" + formatCurrency(volumeQty) + " ft3</span></li>";
					a += "<li>Volume - <span class='answer'>" + formatCurrency(volumeQty / 27) + " yd3</span></li>";
					a += "<li>60lb premixed bags - <span class='answer'>" + Math.ceil((volumeQty / 27) * 60) + "</span></li>";
					a += "<li>80lb premixed bags - <span class='answer'>" + Math.ceil((volumeQty / 27) * 45) + "</span></li>";
					a += "<li>10kg premixed bags - <span class='answer'>" + Math.ceil((volumeQty / 27) * 163.3) + "</span></li>";
					a += "<li>25kg premixed bags - <span class='answer'>" + Math.ceil((volumeQty / 27) * 65.3) + "</span></li>";
					a += "<li>50kg premixed bags - <span class='answer'>" + Math.ceil((volumeQty / 27) * 32.7) + "</span></li>";

					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#diameterLabel').removeClass(MISSING);
					$('#lengthLabel').removeClass(MISSING);
					$('#heightLabel').removeClass(MISSING);
					$('#useRebarLabel').removeClass(MISSING);
					$('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}