			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var wallVar = null;
			var springVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";
				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					wallVar = $('#wall');
					springVar = $('#spring');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					wallVar.Watermark("Degrees");
					springVar.Watermark("Degrees");
					hideContentDialog();
					//hideContentTransition();
					hideConfirmation();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content

					removeError();
					
					if(isNaN(wallVar.val())){
						$('#wallLabel').add(MISSING);
						return false;
					}
					
					if(isNaN(springVar.val())){
						$('#springLabel').add(MISSING);
						return false;
					}
					
					var springAngle = springVar.val() * Math.PI / 180;
					var wallAngle = wallVar.val() * Math.PI / 180;
					
					var miterTop = Math.sin(springAngle);
					var miterBottom = Math.tan(wallAngle/2);
					var bevel1 = Math.cos(springAngle);
					var bevel2 = Math.cos(wallAngle/2);
					var divided = miterTop/miterBottom;
					var multiplied = bevel1 * bevel2;
					
					var ma = Math.atan(divided);
					var ba = Math.asin(multiplied);
					
					var miterAngle = Math.atan(miterTop/miterBottom)*(180/Math.PI);
					var bevelAngle = Math.asin(bevel1 * bevel2)*(180/Math.PI);

					$('#answerUL').html("<li>Miter Angle:  <span class='answer'>" + formatCurrency(miterAngle) + "</span></li><li>Bevel Angle:  <span class='answer'>" + formatCurrency(bevelAngle) + "</span></li>");
					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#wallLabel').removeClass(MISSING);
					$('#springLabel').removeClass(MISSING);

				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}

				function hideConfirmation() {
					hdrConfirmationVar.hide();
					contentConfirmationVar.hide();
					ftrConfirmationVar.hide();
				}

				function showConfirmation() {
					hdrConfirmationVar.show();
					contentConfirmationVar.show();
					ftrConfirmationVar.show();
				}