			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var widthFtVar = null;
			var widthInVar = null;
			var widthFracVar = null;
			var lengthFtVar = null;
			var lengthInVar = null;
			var lengthFracVar = null;
			var boardLengthFtVar = null;
			var boardLengthInVar = null;
			var boardWidthFtVar = null;
			var boardWidthInVar = null;
			var wasteVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";
				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					widthFtVar = $('#widthft');
					widthInVar = $('#widthin');
					lengthFtVar = $('#lengthft');
					lengthInVar = $('#lengthin');
					boardWidthInVar = $('#boardWidthin');
					boardLengthFtVar = $('#boardLengthft');
					boardLengthInVar = $('#boardLengthin');
					wasteVar = $('#waste');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					widthFtVar.Watermark("Feet");
					widthInVar.Watermark("Inches");
					lengthFtVar.Watermark("Feet");
					lengthInVar.Watermark("Inches");
					boardLengthFtVar.Watermark("Feet");
					boardLengthInVar.Watermark("Inches");
					boardWidthInVar.Watermark("Inches");
					wasteVar.Watermark("Percent");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(widthFtVar.val()) && widthFtVar.val() != 'Feet') || (isNaN(widthInVar.val()) && widthInVar.val() != 'Inches')) {
						$('#widthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(widthFtVar.val() == "Feet") {
						widthFtVar.val(0);
					}
					if(widthInVar.val() == "Inches") {
						widthInVar.val(0);
					}
					if((isNaN(lengthFtVar.val()) && lengthFtVar.val() != 'Feet') || (isNaN(lengthInVar.val()) && lengthInVar.val() != 'Inches')) {
						$('#lengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(lengthFtVar.val() == "Feet") {
						lengthFtVar.val(0);
					}
					if(lengthInVar.val() == "Inches") {
						lengthInVar.val(0);
					}
					if((isNaN(boardLengthFtVar.val()) && boardLengthFtVar.val() != 'Feet') || (isNaN(boardLengthInVar.val()) && boardLengthInVar.val() != 'Inches')) {
						$('#boardLengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(boardLengthFtVar.val() == "Feet") {
						boardLengthFtVar.val(0);
					}
					if(boardLengthInVar.val() == "Inches") {
						boardLengthInVar.val(0);
					}
					if(isNaN(boardWidthInVar.val())) {
						boardWidthInVar.val(0);
					}
					if(isNaN(wasteVar.val())){
						wasteVar.val(0);
					}

					var width = (((widthFtVar.val() * 1) + (((widthInVar.val() * 1) + ($('#widthfrac option:selected').val() * 1)) / 12)));
					var length = (((lengthFtVar.val() * 1) + (((lengthInVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12)));
					var boardLength = (((boardLengthFtVar.val() * 1) + (((boardLengthInVar.val() * 1) + ($('#boardLengthfrac option:selected').val() * 1)) / 12)));
					var boardWidth = (((((boardWidthInVar.val() * 1) + ($('#boardWidthfrac option:selected').val() * 1)) / 12)));
					var boardSpace = ($('#spacefrac option:selected').val() * 1) / 12;

					var area = width * length;
					if(wasteVar.val() != 0){
						area = area * (1 + (wasteVar.val()/100));
					}
					var boardArea = (boardWidth + boardSpace) * 1;
					var lnFt = Math.ceil(area / boardArea);
					var boards = Math.ceil(lnFt / boardLength);


					var a = "<li>Area - <span class='answer'>" + Math.ceil(area) + " ft2</span></li>";
					a += "<li>Linear Feet - <span class='answer'>" + Math.ceil(lnFt) + " ft</span></li>";
					a += "<li># of " + convertDecimalFeetToFraction(boardLength) + " Boards  - <span class='answer'>" + Math.ceil(boards) + "</span></li>";
					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#widthLabel').removeClass(MISSING);
					$('#lengthLabel').removeClass(MISSING);
					$('#boardLengthLabel').removeClass(MISSING);
					$('#useRebarLabel').removeClass(MISSING);
					$('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}