			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var widthFtVar = null;
			var widthInVar = null;
			var widthFracVar = null;
			var lengthFtVar = null;
			var lengthInVar = null;
			var lengthFracVar = null;
			var distanceInVar = null;
			var distanceFracVar = null;
			var tileSizeVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";
				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					widthFtVar = $('#widthft');
					widthInVar = $('#widthin');
					widthFracVar = $('#widthfrac');
					lengthFtVar = $('#lengthft');
					lengthInVar = $('#lengthin');
					lengthFracVar = $('#lengthfrac');
					distanceInVar = $('#distancein');
					distanceFracVar = $('#distancefrac');
					tileSizeVar = $('#tileSize');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					widthFtVar.Watermark("Feet");
					widthInVar.Watermark("Inches");
					lengthFtVar.Watermark("Feet");
					lengthInVar.Watermark("Inches");
					distanceInVar.Watermark("Inches");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(widthFtVar.val()) && widthFtVar.val() != 'Feet') || (isNaN(widthInVar.val()) && widthInVar.val() != 'Inches')) {
						$('#widthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(widthFtVar.val() == "Feet") {
						widthFtVar.val(0);
					}
					if(widthInVar.val() == "Inches") {
						widthInVar.val(0);
					}
					if((isNaN(lengthFtVar.val()) && lengthFtVar.val() != 'Feet') || (isNaN(lengthInVar.val()) && lengthInVar.val() != 'Inches')) {
						$('#lengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(lengthFtVar.val() == "Feet") {
						lengthFtVar.val(0);
					}
					if(lengthInVar.val() == "Inches") {
						lengthInVar.val(0);
					}
					if(distanceInVar.val() == "Inches") {
						distanceInVar.val(0);
					}
					
					var tile = $('#tileSize option:selected').val() * 1;
					var width = (((widthFtVar.val() * 1) + (((widthInVar.val() * 1) + ($('#widthfrac option:selected').val() * 1)) / 12)));
					var length = (((lengthFtVar.val() * 1) + (((lengthInVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12)));
					var drop = (((((distanceInVar.val() * 1) + ($('#distancefrac option:selected').val() * 1)))));
					
					var sqFt = width * length;
					var numTiles = sqFt/tile;
					var parimeter = (width * 2) + (length * 2);
					var tBrackets = ((width / 2)-1)*length;
					var mainSupport = Math.ceil(tBrackets/12);
					
					var tSupport = 0;
					if(tile == 4){
						tSupport = ((length/2)-1)*(width/2);
					}else{
						tSupport = ((length/4)-1)*(width/2);
					}
					
					var anchors = Math.ceil(tBrackets/4);
					var wire = Math.ceil(anchors * drop) + 12;

					var a = "<li>Ceiling Area - <span class='answer'>" + formatCurrency(sqFt) + " ft</span></li>";
					a += "<li>Ceiling Tiles - <span class='answer'>" + Math.ceil(numTiles) + "</span></li>";
					a += "<li>Parimeter Molding - <span class='answer'>" + Math.ceil(parimeter) + " ft</span></li>";
					a += "<li>Main Supports - <span class='answer'>" + mainSupport + " x 12ft</span></li>";
					a += "<li>2ft Tee Support - <span class='answer'>" + tSupport + "</span></li>";
					a += "<li>Wire Anchors - <span class='answer'>" + anchors + "</span></li>";
					a += "<li>Wire Length (each) - <span class='answer'>" + convertDecimalInchToFraction(drop + 12) + "</span></li>";
					a += "<li>Wire Length (total) - <span class='answer'>" + convertDecimalFeetToFraction(wire/12) + "</span></li>";

					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#widthLabel').removeClass(MISSING);
					$('#lengthLabel').removeClass(MISSING);
					$('#thickLabel').removeClass(MISSING);
					$('#tileSizeLabel').removeClass(MISSING);
					$('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}