			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var wallFtVar = null;
			var wallInVar = null;
			var wallFracVar = null;
			var spaceVar = null;
			var windowVar = null;
			var doorVar = null;
			var cornerVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";
			
				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					wallFtVar = $('#wallft');
					wallInVar = $('#wallin');
					wallFracVar = $('#wallfrac');
					spaceVar = $('#spacing');
					windowVar = $('#window');
					doorVar = $('#door');
					cornerVar = $('#corner');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					wallFtVar.Watermark("Feet");
					wallInVar.Watermark("Inches");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(wallFtVar.val()) && wallFtVar.val() != 'Feet') || (isNaN(wallInVar.val()) && wallInVar.val() != 'Inches')) {
						$('#wallLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(wallFtVar.val() == "Feet") {
						wallFtVar.val(0);
					}
					if(wallInVar.val() == "Inches") {
						wallInVar.val(0);
					}
					if(isNaN(windowVar.val())) {
						windowVar.val(0);
					}
					if(isNaN(spaceVar.val())) {
						spaceVar.val(0);
					}
					if(isNaN(doorVar.val())) {
						doorVar.val(0);
					}
					if(isNaN(cornerVar.val())) {
						cornerVar.val(0);
					}

					var wall = (((wallFtVar.val() * 1) + (((wallInVar.val() * 1) + ($('#wallfrac option:selected').val() * 1)) / 12)));
					var space = (spaceVar.val() * 1)/12;
					var window = windowVar.val() * 3;
					var door = doorVar.val() * 3;
					var corner = cornerVar.val() * 3;
					
					var wallPlates = Math.ceil(wall*3);
					var studs = Math.ceil(wall/space);
					if(window!=0){
						studs += window;
					}
					if(door!=0){
						studs += door;
					}
					if(corner!=0){
						studs += corner;
					}
					
					var a = "<li>Total Studs Needed - <span class='answer'>" + Math.ceil(studs) + "</span></li>";
					a += "<li>Total Plate Length - <span class='answer'>" + Math.ceil(wallPlates) + "</span></li>";
					a += "<li>Total 16' Plates - <span class='answer'>" + Math.ceil(wallPlates/16) + "</span></li>";
					
					
					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}