			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var lengthVar = null;
			var lengthInchVar = null;
			var lengthFracVar = null;
			var panelsVar = null;
			var costVar = null;
			var whatVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

	

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					lengthVar = $('#length');
					lengthInchVar = $('#lengthinch');
					lengthFracVar = $('#lengthfrac');
					panelsVar = $('#number');
					costVar = $('#cost');
					whatVar = $('#what');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					lengthVar.Watermark("Feet");
					lengthInchVar.Watermark("Inches");
					hideContentDialog();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content

					removeError();

					// Perform form validation
					if(lengthVar == null || lengthVar.val() == EMPTY || lengthVar.val() == 'Feet') {
						lengthVar.val(0);
					} else {
						if(isNaN(lengthVar.val())) {
							$('#lengthLabel').addClass(MISSING);
							err = true;
						}
					}

					if((lengthInchVar == null) || (lengthInchVar.val() == EMPTY) || lengthInchVar.val() == 'Inches') {
						lengthInchVar.val(0);
						//do nothing
					} else {
						if(isNaN(lengthInchVar.val())) {
							$('#lengthLabel').addClass(MISSING);
							err = true;
						}
					}

					if(panelsVar == null || panelsVar.val() == EMPTY) {
						$('#numberLabel').addClass(MISSING);
						err = true;
					}

					if(isNaN(costVar.val())) {
						costVar.val(0);
					}

					// If validation fails, show Dialog content
					if(err == true) {
						hideMain();
						showContentDialog();
						return false;
					}

					var length = lengthVar.val() * 1;
					if(!isNaN(lengthInchVar.val())) {
						length += (((lengthInchVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12);
					}

					var lnFt = length * panelsVar.val();
					var total = lnFt * costVar.val(); 

					$('#answerUL').html("<li>Total cost will be:  <span class='answer'>$" + formatCurrency(total) + "</span></li><li>Total Linear Ft:  <span class='answer'>" + Math.ceil(lnFt)) + "</span></li>";

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#lengthLabel').removeClass(MISSING);
					$('#numberLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}