			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var heightFtVar = null;
			var heightInVar = null;
			var heightFracVar = null;
			var lengthFtVar = null;
			var lengthInVar = null;
			var lengthFracVar = null;
			var surfaceInVar = null;
			var surfaceFracVar = null;
			var coatsVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					heightFtVar = $('#heightft');
					heightInVar = $('#heightin');
					heightFracVar = $('#heightfrac');
					lengthFtVar = $('#lengthft');
					lengthInVar = $('#lengthin');
					lengthFracVar = $('#lengthfrac');
					surfaceFracVar = $('#surfacefrac');
					coatsVar = $('#coats');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					heightFtVar.Watermark("Feet");
					heightInVar.Watermark("Inches");
					lengthFtVar.Watermark("Feet");
					lengthInVar.Watermark("Inches");
					coatsVar.Watermark("coats");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(heightFtVar.val()) && heightFtVar.val() != 'Feet') || (isNaN(heightInVar.val()) && heightInVar.val() != 'Inches')) {
						$('#heightLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(heightFtVar.val() == "Feet") {
						heightFtVar.val(0);
					}
					if(heightInVar.val() == "Inches") {
						heightInVar.val(0);
					}
					if((isNaN(lengthFtVar.val()) && lengthFtVar.val() != 'Feet') || (isNaN(lengthInVar.val()) && lengthInVar.val() != 'Inches')) {
						$('#lengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(lengthFtVar.val() == "Feet") {
						lengthFtVar.val(0);
					}
					if(lengthInVar.val() == "Inches") {
						lengthInVar.val(0);
					}
					if(isNaN(coatsVar.val())) {
						coatsVar.val(0);
					}

					var height = (((heightFtVar.val() * 1) + (((heightInVar.val() * 1) + ($('#heightfrac option:selected').val() * 1)) / 12)));
					var length = (((lengthFtVar.val() * 1) + (((lengthInVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12)));
					var surface = $('#surfacefrac option:selected').val();

					var area = height * length * coatsVar.val();
					var totalGal = 0;
					var totalLiter = 0;

					if(surface == "interiorsmooth") {
						totalGal = (area / 1000) * 2.67;
						totalLiter = (area / 1000) * 12.12;
					} else if(surface == "interiortextured") {
						totalGal = (area / 1000) * 4.0;
						totalLiter = (area / 1000) * 18.18;
					} else if(surface == "smoothceiling") {
						totalGal = (area / 1000) * 2.85;
						totalLiter = (area / 1000) * 12.96;
					} else if(surface == "texturedceiling") {
						totalGal = (area / 1000) * 4.44;
						totalLiter = (area / 1000) * 20.2;
					} else if(surface == "exteriorbuilding") {
						totalGal = (area / 1000) * 4.0;
						totalLiter = (area / 1000) * 18.18;
					}

					var a = "<li>Gallons Required - <span class='answer'>" + Math.ceil(totalGal) + "</span></li>";
					a += "<li>Liters Required - <span class='answer'>" + Math.ceil(totalLiter) + "</span></li>";

					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#heightLabel').removeClass(MISSING);
					$('#lengthLabel').removeClass(MISSING);
					$('#thickLabel').removeClass(MISSING);
					$('#useBatLabel').removeClass(MISSING);
					$('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}