			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var runVar = null;
			var runInchVar = null;
			var runFracVar = null;
			var panelsVar = null;
			var costVar = null;
			var whatVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";


				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					runVar = $('#run');
					runInchVar = $('#runinch');
					runFracVar = $('#runfrac');
					pitchVar = $('#pitch');
					whatVar = $('#what');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					runVar.Watermark("Feet");
					runInchVar.Watermark("Inches");
					hideContentDialog();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content

					removeError();

					// Perform form validation
					if(runVar == null || runVar.val() == EMPTY || runVar.val() == 'Feet') {
						runVar.val(0);
					} else {
						if(isNaN(runVar.val())) {
							$('#runLabel').addClass(MISSING);
							err = true;
						}
					}
					if((runInchVar == null) || (runInchVar.val() == EMPTY) || runInchVar.val() == 'Inches') {
						runInchVar.val(0);
						//do nothing
					} else {
						if(isNaN(runInchVar.val())) {
							$('#runLabel').addClass(MISSING);
							err = true;
						}
					}

					if(isNaN(pitchVar.val())) {
						err = true;
						$('#pitchLabel').addClass(MISSING);
					}

					if(isNaN(runVar.val() + runInchVar.val())) {
						err = true;
						$('#runLabel').addClass(MISSING);
					}

					// If validation fails, show Dialog content
					if(err == true) {
						hideMain();
						showContentDialog();
						return false;
					}

					var run = runVar.val() * 1;
					if(!isNaN(runInchVar.val())) {
						run += (((runInchVar.val() * 1) + ($('#runfrac option:selected').val() * 1)) / 12);
					}

					var pitch = pitchVar.val();

					var rise = (run / 12) * pitch;
					var hypot = findHypot(rise, run);

					$('#answerUL').html("<li>Rafter Length:  <span class='answer'>" + convertDecimalFeetToFraction(hypot) + "</span></li>");
					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#runLabel').removeClass(MISSING);
					$('#pitchLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}