			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var widthFtVar = null;
			var widthInVar = null;
			var widthFracVar = null;
			var lengthFtVar = null;
			var lengthInVar = null;
			var lengthFracVar = null;
			var overhangFtVar = null;
			var overhangInVar = null;
			var overhangFracVar = null;
			var sqftVar = null;
			var marginVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";
			

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					widthFtVar = $('#widthft');
					widthInVar = $('#widthin');
					widthFracVar = $('#widthfrac');
					lengthFtVar = $('#lengthft');
					lengthInVar = $('#lengthin');
					lengthFracVar = $('#lengthfrac');
					overhangFtVar = $('#overhangft');
					overhangInVar = $('#overhangin');
					overhangFracVar = $('#overhangfrac');
					sqftVar = $('#sqft');
					marginVar = $('#margin');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					widthFtVar.Watermark("Feet");
					widthInVar.Watermark("Inches");
					lengthFtVar.Watermark("Feet");
					lengthInVar.Watermark("Inches");
					overhangFtVar.Watermark("Feet");
					overhangInVar.Watermark("Inches");
					marginVar.Watermark("%");
					sqftVar.Watermark("Square Feet");

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if((isNaN(widthFtVar.val()) && widthFtVar.val() != 'Feet') || (isNaN(widthInVar.val()) && widthInVar.val() != 'Inches')) {
						$('#widthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(widthFtVar.val() == "Feet") {
						widthFtVar.val(0);
					}
					if(widthInVar.val() == "Inches") {
						widthInVar.val(0);
					}
					if((isNaN(lengthFtVar.val()) && lengthFtVar.val() != 'Feet') || (isNaN(lengthInVar.val()) && lengthInVar.val() != 'Inches')) {
						$('#lengthLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(lengthFtVar.val() == "Feet") {
						lengthFtVar.val(0);
					}
					if(lengthInVar.val() == "Inches") {
						lengthInVar.val(0);
					}
					if((isNaN(overhangFtVar.val()) && overhangFtVar.val() != 'Feet') || (isNaN(overhangInVar.val()) && overhangInVar.val() != 'Inches')) {
						$('#overhangLabel').addClass(MISSING);
						hideMain();
						showContentDialog();
						return false;
					}
					if(overhangFtVar.val() == "Feet") {
						overhangFtVar.val(0);
					}
					if(overhangInVar.val() == "Inches") {
						overhangInVar.val(0);
					}
					if(isNaN(sqftVar.val())) {
						sqftVar.val(0);
					}
					if(isNaN(marginVar.val())) {
						marginVar.val(0);
					}

					var pitch = $('#pitch option:selected').val();
					var type = $('#type option:selected').val();

					var width = (((widthFtVar.val() * 1) + (((widthInVar.val() * 1) + ($('#widthfrac option:selected').val() * 1)) / 12)));
					var length = (((lengthFtVar.val() * 1) + (((lengthInVar.val() * 1) + ($('#lengthfrac option:selected').val() * 1)) / 12)));
					var overhang = (((overhangFtVar.val() * 1) + (((overhangInVar.val() * 1) + ($('#overhangfrac option:selected').val() * 1)) / 12)));

					var area = 0;
					if(overhang != 0) {
						area = ((width + (overhang * 2)) * (length + (overhang * 2))) * pitch;
					} else {
						area = ((width) * (length)) * pitch;
					}
					var totalArea = 0;

					if(marginVar.val() != 0) {
						totalArea = area * ((marginVar.val() / 100)+1);
					} else {
						totalArea = area;
					}

					var fascia = 0;
					var ridge = 0;
					var gable = 0;
					var starter = 0;
					if(overhang != 0) {
						if($('#type option:selected').val() == "hip") {
							fascia = ((width + (overhang * 2)) + (length + (overhang * 2))) * 2;
							var l = (length + (overhang * 2)) - (width + (overhang * 2));
							ridge = ((((width + (overhang * 2)) * 2) * pitch) + l) * 1.1;
							starter = fascia;
						} else {
							fascia = (((width + (overhang * 2)) * pitch) + (length + (overhang * 2))) * 2;
							ridge = length + (overhang * 2);
							gable = ((width + (overhang * 2))*pitch)*2;
							starter = fascia - gable;
						}
					} else {
						if($('#type option:selected').val() == "hip") {
							fascia = ((width) + (length)) * 2;
							var l = (length) - (width);
							ridge = ((((width) * 2) * pitch) + l) * 1.1;
							starter = fascia;
						} else {
							fascia = (((width) * pitch) + (length)) * 2;
							ridge = length;
							gable = ((width)*pitch)*2;
							starter = fascia - gable;
						}
					}

					var a = "<li>Roof Area - <span class='answer'>" + formatCurrency(area) + " ft2</span></li>";
					a += "<li>Roof Area w/margin - <span class='answer'>" + formatCurrency(totalArea) + " ft2</span></li>";
					a += "<li>Start Shingles - <span class='answer'>" + Math.ceil(starter) + " ft</span></li>";
					a += "<li>Feet of Fascia/Drip Edge - <span class='answer'>" + Math.ceil(fascia) + " ft</span></li>";
					a += "<li>Bundles of Shingles - <span class='answer'>" + Math.ceil(totalArea/sqftVar.val()) + "</span></li>";
					a += "<li>Ridge Length - <span class='answer'>" + Math.ceil(ridge) + " ft</span></li>";
					a += "<li>Gable Length - <span class='answer'>" + Math.ceil(gable) + " ft</span></li>";
					a += "<li># 4x8 Sheathing  - <span class='answer'>" + Math.ceil(totalArea/32) + "</span></li>";

					$('#answerUL').html(a);

					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;
				});
				function removeError() {
					$('#widthLabel').removeClass(MISSING);
					$('#lengthLabel').removeClass(MISSING);
					$('#thickLabel').removeClass(MISSING);
					$('#useBatLabel').removeClass(MISSING);
					$('#wasteLabel').removeClass(MISSING);
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}