			// Global declarations - assignments made in $(document).ready() below
			var hdrMainvar = null;
			var contentMainVar = null;
			var ftrMainVar = null;
			var contentTransitionVar = null;
			var riseFtVar = null;
			var riseInVar = null;
			var riseFracVar = null;
			var runFtVar = null;
			var runInVar = null;
			var runFracVar = null;
			var angleVar = null;

			var costVar = null;
			var whatVar = null;
			var form1var = null;
			var confirmationVar = null;
			var contentDialogVar = null;
			var hdrConfirmationVar = null;
			var contentConfirmationVar = null;
			var ftrConfirmationVar = null;
			var inputMapVar = null;
			var calculated = false;

			// Constants
			var MISSING = "missing";
			var EMPTY = "";
			var NO_STATE = "ZZ";
			

				$(document).ready(function() {
					// Assign global variables
					hdrMainVar = $('#hdrMain');
					contentMainVar = $('#contentMain');
					ftrMainVar = $('#ftrMain');
					//contentTransitionVar = $('#contentTransition');
					riseFtVar = $('#riseft');
					riseInVar = $('#risein');
					riseFracVar = $('#risefrac');
					runFtVar = $('#runft');
					runInVar = $('#runin');
					runFracVar = $('#runfrac');
					valueVar = $('#what');
					angleVar = $('#angle');
					whatVar = $('#what');
					form1Var = $('#form1');
					confirmationVar = $('#confirmation');
					contentDialogVar = $('#contentDialog');
					hdrConfirmationVar = $('#hdrConfirmation');
					contentConfirmationVar = $('#contentConfirmation');
					ftrConfirmationVar = $('#ftrConfirmation');
					inputMapVar = $('input[name*="_r"]');

					riseFtVar.Watermark("Feet");
					riseInVar.Watermark("Inches");
					runFtVar.Watermark("Feet");
					runInVar.Watermark("Inches");
					angleVar.Watermark("Degrees");
					$('#riseLabel').removeClass('required');
					$('#runLabel').addClass('required');
					$('#angleLabel').addClass('required');

					hideContentDialog();
					//hideContentTransition();
				});

				$('#buttonOK').click(function() {
					hideContentDialog();
					showMain();
					return false;
				});

				$('#what').change(function() {
					if($('#what option:selected').val() == 'rise') {
						$('#riseLabel').removeClass('required');
						$('#runLabel').addClass('required');
						$('#angleLabel').addClass('required');
					}
					if($('#what option:selected').val() == 'run') {
						$('#riseLabel').addClass('required');
						$('#runLabel').removeClass('required');
						$('#angleLabel').addClass('required');
					}
					if($('#what option:selected').val() == 'angle') {
						$('#riseLabel').addClass('required');
						$('#runLabel').addClass('required');
						$('#angleLabel').removeClass('required');
					}

					return false;
				});

				$('#form1').submit(function() {
					var err = false;
					// Hide the Main content
					removeError();

					if($('#what option:selected').val() == 'rise') {
						if((isNaN(angleVar.val())) || (isNaN(runFtVar.val()) && runFtVar.val() != 'Feet') || (isNaN(runInVar.val()) && runInVar.val() != 'Inches')) {
							hideMain();
							showContentDialog();
							return false;
						}
						if(runFtVar.val() == "Feet") {
							runFtVar.val(0);
						}
						if(runInVar.val() == "Inches") {
							runInVar.val(0);
						}
						var run = ((runFtVar.val() * 1) + (((runInVar.val() * 1) + ($('#runfrac option:selected').val() * 1)) / 12));
						var rise = (Math.tan((angleVar.val()) * Math.PI / 180) * run);
						var answerHTML = "<li>Rise is:  <span class='answer'>" + convertDecimalFeetToFraction(rise) + "</span></li>";
						answerHTML += "<li>Hypotenuse is:  <span class='answer'>" + convertDecimalFeetToFraction(findHypot(rise, run)) + "</span></li>";

						$('#answerUL').html(answerHTML);
					}
					if($('#what option:selected').val() == 'run') {
						if((isNaN(angleVar.val())) || (isNaN(riseFtVar.val()) && riseFtVar.val() != 'Feet') || (isNaN(riseInVar.val()) && riseInVar.val() != 'Inches')) {
							hideMain();
							showContentDialog();
							return false;
						}
						if(riseFtVar.val() == "Feet") {
							riseFtVar.val(0);
						}
						if(riseInVar.val() == "Inches") {
							riseInVar.val(0);
						}
						var rise = (riseFtVar.val() * 1) + (((riseInVar.val() * 1) + ($('#risefrac option:selected').val() * 1)) / 12);
						var ans = (Math.tan(((90 - angleVar.val())) * Math.PI / 180) * rise);
						var answerHTML = "<li>Run is:  <span class='answer'>" + convertDecimalFeetToFraction(ans) + "</span></li>";
						answerHTML += "<li>Hypotenuse is:  <span class='answer'>" + convertDecimalFeetToFraction(findHypot(rise, ans)) + "</span></li>";
						$('#answerUL').html(answerHTML);
					}
					if($('#what option:selected').val() == 'angle') {
						if((isNaN(riseFtVar.val()) && riseFtVar.val() != 'Feet') || (isNaN(riseInVar.val()) && riseInVar.val() != 'Inches') || (isNaN(runFtVar.val()) && runFtVar.val() != 'Feet') || (isNaN(runInVar.val()) && runInVar.val() != 'Inches')) {
							hideMain();
							showContentDialog();
							return false;
						}
						if(riseFtVar.val() == "Feet") {
							riseFtVar.val(0);
						}
						if(riseInVar.val() == "Inches") {
							riseInVar.val(0);
						}
						if(runFtVar.val() == "Feet") {
							runFtVar.val(0);
						}
						if(runInVar.val() == "Inches") {
							runInVar.val(0);
						}

						var rise = ((riseFtVar.val() * 1) + (((riseInVar.val() * 1) + ($('#risefrac option:selected').val() * 1)) / 12));
						var run = ((runFtVar.val() * 1) + (((runInVar.val() * 1) + ($('#runfrac option:selected').val() * 1)) / 12));

						var hypot = findHypot(rise, run);
						var ans = ((Math.asin(rise / hypot)) * (180 / Math.PI));
						var answerHTML = "<li>Angle is:  <span class='answer'>" + formatCurrency(ans) + " degrees</span></li>";
						answerHTML += "<li>Hypotenuse is:  <span class='answer'>" + convertDecimalFeetToFraction(hypot) + "</span></li>";
						$('#answerUL').html(answerHTML);
					}
					if(calculated) {
						$('#answerUL').listview("refresh");
					} else {
						$('#answerUL').listview();
					}
					calculated = true;
					return false;

				});
				function removeError() {/*
					 $('#lengthLabel').removeClass(MISSING);
					 $('#widthLabel').removeClass(MISSING);
					 $('#costLabel').removeClass(MISSING);
					 */
				}

				function hideMain() {
					hdrMainVar.hide();
					contentMainVar.hide();
					ftrMainVar.hide();
				}

				function showMain() {
					hdrMainVar.show();
					contentMainVar.show();
					ftrMainVar.show();
				}

				function hideContentDialog() {
					contentDialogVar.hide();
				}

				function showContentDialog() {
					contentDialogVar.show();
				}